package com.floreantpos.model.dao;

import java.io.Serializable;
import java.util.List;

import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

import com.floreantpos.model.Customer;
import com.floreantpos.model.Discount;
import com.floreantpos.model.RegistrationReferrer;
import com.floreantpos.swing.PaginationSupport;

public class RegistrationReferrerDAO extends BaseRegistrationReferrerDAO {

	/**
	 * Default constructor.  Can be used in place of getInstance()
	 */
	public RegistrationReferrerDAO() {
	}

	@Override
	protected Serializable save(Object obj, Session s) {
		updateTime(obj);
		return super.save(obj, s);
	}

	@Override
	protected void update(Object obj, Session s) {
		updateTime(obj);
		super.update(obj, s);
	}

	@Override
	protected void saveOrUpdate(Object obj, Session s) {
		updateTime(obj);
		super.saveOrUpdate(obj, s);
	}

	public int getReferrerCustomersCount(Customer referrer, String couponCode) {
		if (referrer == null) {
			return 0;
		}
		try (Session session = createNewSession()) {
			Criteria criteria = session.createCriteria(getReferenceClass());
			criteria.setProjection(Projections.rowCount());
			criteria.add(Restrictions.eq(RegistrationReferrer.PROP_COUPON_CODE, couponCode));
			criteria.add(Restrictions.eq(RegistrationReferrer.PROP_REFERRER_ID, referrer.getId()));
			Number result = (Number) criteria.uniqueResult();
			if (result != null) {
				return result.intValue();
			}
			return 0;
		}
	}

	@SuppressWarnings("unchecked")
	public List<RegistrationReferrer> findByReferrer(PaginationSupport tableModel, Customer referrer, Discount discount) {
		try (Session session = createNewSession()) {
			Criteria criteria = session.createCriteria(getReferenceClass());
			if (referrer != null) {
				criteria.add(Restrictions.eq(RegistrationReferrer.PROP_REFERRER_ID, referrer.getId()));
			}
			if (discount != null) {
				criteria.add(Restrictions.eq(RegistrationReferrer.PROP_COUPON_CODE, discount.getBarcode()));
			}
			tableModel.setNumRows(rowCount(criteria));
			criteria.setFirstResult(tableModel.getCurrentRowIndex());
			criteria.setMaxResults(tableModel.getPageSize());
			List list = criteria.list();
			tableModel.setRows(list);
			return list;
		}
	}

	public List<Customer> findReferrers() {
		List<String> referrerIds = null;
		try (Session session = createNewSession()) {
			Criteria criteria = session.createCriteria(getReferenceClass());
			criteria.setProjection(Projections.distinct(Projections.property(RegistrationReferrer.PROP_REFERRER_ID)));
			referrerIds = criteria.list();
		}
		return CustomerDAO.getInstance().findByIds(referrerIds);
	}

}