package com.floreantpos.payment;

import org.hibernate.Session;

import com.floreantpos.extension.FloreantPlugin;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.User;
import com.floreantpos.util.NumberUtil;

public interface PaymentPlugin extends FloreantPlugin {
	String getName();

	void pay(PaymentListener paymentListener, Ticket ticket, double tenderAmount, User cashier) throws Exception;

	void voidPayment(PosTransaction transaction, Session session);

	public default void setTransactionAmounts(Ticket ticket, PosTransaction transaction, Double tenderAmount) {
		transaction.setTenderAmount(tenderAmount);
		if (tenderAmount >= ticket.getDueAmount()) {
			transaction.setAmount(ticket.getDueAmount());
		}
		else {
			transaction.setAmount(tenderAmount);
		}

		double changeAmount = NumberUtil.round(tenderAmount - transaction.getAmount());
		if (Math.abs(changeAmount) <= ticket.getToleranceFactor()) {
			if (changeAmount > 0) {
				transaction.setAmount(NumberUtil.round(transaction.getAmount() + changeAmount));
			}
			transaction.setToleranceAmount(changeAmount);
			transaction.setChangeAmount(0D);
		}
		else {
			transaction.setChangeAmount(changeAmount);
		}
	}


}
