package com.floreantpos.services;

import org.hibernate.Session;

import com.floreantpos.model.InventoryUnit;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.Store;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.util.DataProvider;

public class InventoryService {

	private static InventoryService instance;

	public static InventoryService getInstance() {
		if (instance == null) {
			instance = new InventoryService();
		}
		return instance;
	}

	private InventoryService() {
	}

	public void adjustMenuItemCost(MenuItem menuItem, double newCost, double newQuantity, InventoryUnit selectedUnit) {
		MenuItemDAO.getInstance().refresh(menuItem);
		try (Session session = TerminalDAO.getInstance().createNewSession()) {
			this.adjustMenuItemCost(menuItem, newCost, newQuantity, selectedUnit, session);
		}
	}

	public void adjustMenuItemCost(MenuItem menuItem, double newCost, double newQuantity, InventoryUnit selectedUnit, Session session) {
		Store store = DataProvider.get().getStore();
		if (store == null || menuItem == null || selectedUnit == null || session == null) {
			return;
		}
		//MenuItemDAO.getInstance().refresh(menuItem, session);

		InventoryUnit baseUnit = menuItem.getUnit();

		if (selectedUnit != null && baseUnit != null && !baseUnit.equals(selectedUnit)) {
			Double selectedConversionRate = selectedUnit.getConversionRate();
			Double baseConversionRate = baseUnit.getConversionRate();
			newCost = newCost * (selectedConversionRate / baseConversionRate);
			newQuantity = newQuantity * menuItem.getUnitQuantity(selectedUnit, baseUnit);
		}

		Double menuItemOnHand = menuItem.getUnitOnHand();
		if (menuItemOnHand < 0) {
			menuItemOnHand = 0.0;
		}
		Double menuItemCost = menuItem.getCost();

		double menuItemAverageCost = (menuItemOnHand * menuItemCost + newQuantity * newCost) / (menuItemOnHand + newQuantity);

		if (store.isInventoryAvgPricingMethod()) {
			menuItem.setCost(menuItemAverageCost);
		}
		else {
			menuItem.setCost(newCost);
		}
		menuItem.setLastPurchasedCost(newCost);
		menuItem.setAverageUnitPurchasePrice(menuItemAverageCost);
	}
}
