/**
 * ************************************************************************
 * * The contents of this file are subject to the MRPL 1.2
 * * (the  "License"),  being   the  Mozilla   Public  License
 * * Version 1.1  with a permitted attribution clause; you may not  use this
 * * file except in compliance with the License. You  may  obtain  a copy of
 * * the License at http://www.floreantpos.org/license.html
 * * Software distributed under the License  is  distributed  on  an "AS IS"
 * * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * * License for the specific  language  governing  rights  and  limitations
 * * under the License.
 * * The Original Code is FLOREANT POS.
 * * The Initial Developer of the Original Code is OROCUBE LLC
 * * All portions are Copyright (C) 2015 OROCUBE LLC
 * * All Rights Reserved.
 * ************************************************************************
 */
package com.floreantpos.model;

import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.base.BaseActionHistory;

@JsonIgnoreProperties(ignoreUnknown = true, value = { "objectReference" })
@XmlRootElement
public class ActionHistory extends BaseActionHistory implements TimedModel {
	private static final long serialVersionUID = 1L;

	private boolean updateLastUpdateTime = true;
	private boolean updateSyncTime = false;

	public boolean isUpdateSyncTime() {
		return updateSyncTime;
	}

	public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
		this.updateSyncTime = shouldUpdateSyncTime;
	}

	public boolean isUpdateLastUpdateTime() {
		return updateLastUpdateTime;
	}

	public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
		this.updateLastUpdateTime = shouldUpdateUpdateTime;
	}

	private Object objectReference;

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public ActionHistory() {
	}

	/**
	 * Constructor for primary key
	 */
	public ActionHistory(java.lang.String id) {
		super(id);
	}

	/*[CONSTRUCTOR MARKER END]*/

	public final static String MQTT_CHECK = "Mqtt ticket save"; //$NON-NLS-1$
	public final static String NEW_CHECK = "New check"; //$NON-NLS-1$
	public final static String SAVE_CHECK = "Save check"; //$NON-NLS-1$
	public final static String EDIT_CHECK = "Edit check"; //$NON-NLS-1$
	public final static String SPLIT_CHECK = "Split check"; //$NON-NLS-1$
	public final static String VOID_CHECK = "Void check"; //$NON-NLS-1$
	public static final String VOID_PAYMENT = "Void payment";
	public final static String TICKET_ITEM_VOID = "Ticket item void"; //$NON-NLS-1$
	public final static String REOPEN_CHECK = "Reopen check"; //$NON-NLS-1$
	public final static String SETTLE_CHECK = "Settle check"; //$NON-NLS-1$
	public final static String REFUND_CHECK = "Refund ticket"; //$NON-NLS-1$
	public final static String PRINT_CHECK = "Print receipt"; //$NON-NLS-1$
	public final static String PAY_CHECK = "Pay check"; //$NON-NLS-1$
	public final static String GROUP_SETTLE = "Group settle"; //$NON-NLS-1$
	public final static String PAY_OUT = "Pay out"; //$NON-NLS-1$
	public final static String PAY_TIPS = "Pay tips"; //$NON-NLS-1$
	public final static String STAFF_BANK_FORCE_CLOSE = "Staff bank force close";//$NON-NLS-1$
	public final static String TRANSFER_TICKET = "Transfer ticket"; //$NON-NLS-1$
	public final static String SENT_TO_KITCHEN = "Sent to kitchen"; //$NON-NLS-1$
	public final static String FORCED_CLOCK_OUT = "Forced clock out"; //$NON-NLS-1$
	public final static String CLOCK_IN = "Clock in"; //$NON-NLS-1$
	public final static String CLOCK_OUT = "Clock out"; //$NON-NLS-1$
	public final static String DATE_CHAGE = "Ticket create date change"; //$NON-NLS-1$
	public final static String CUSTOMER_SET = "Customer set"; //$NON-NLS-1$
	public final static String CUSTOMER_REMOVED = "Customer removed"; //$NON-NLS-1$
	public final static String MERGE_TICKET = "Merge ticket"; //$NON-NLS-1$
	public final static String TRANSFER_ITEMS = "Transfer items"; //$NON-NLS-1$
	public final static String TABLE_CHANGE = "Table change"; //$NON-NLS-1$
	public final static String TABLE_ADDED = "Table added"; //$NON-NLS-1$
	public final static String TABLE_RELEASED = "Table released"; //$NON-NLS-1$
	public static final String SALES_AREA_CHANGE = "Sales area change"; //$NON-NLS-1$
	public static final String ORDER_HOLD = "Hold order"; //$NON-NLS-1$
	public static final String CASH_DRAWER_CLOSE = "Cash drawer close"; //$NON-NLS-1$
	public static final String CASH_DRAWER_ASSIGNMENT = "Cash drawer assignment"; //$NON-NLS-1$
	public static final String CLOSE_TICKET = "Close ticket"; //$NON-NLS-1$
	public static final String TICKET_DISCOUNT_ADDED = "Ticket discount added"; //$NON-NLS-1$
	public static final String ITEM_DISCOUNT_ADDED = "Item discount added"; //$NON-NLS-1$
	public static final String LOYALTY_ADDED = "Loyalty added"; //$NON-NLS-1$
	public static final String TICKET_DISCOUNT_REMOVED = "Ticket discount removed"; //$NON-NLS-1$
	public static final String ITEM_DISCOUNT_REMOVED = "Item discount removed"; //$NON-NLS-1$
	public static final String LOYALTY_REMOVED = "Loyalty removed"; //$NON-NLS-1$
	public static final String GRATUITY_ADDED = "Gratuity set"; //$NON-NLS-1$
	public static final String SF_SYNC_GRATUITY_CHANGE = "Sf sync gratuity amount change"; //$NON-NLS-1$
	public static final String TAX_EXEMPT = "Tax exempt"; //$NON-NLS-1$
	public static final String TAX_UNEXEMPT = "Tax unexempt";//$NON-NLS-1$
	public static final String CASH_DRAWER_BLEED = "Cash drawer bleed"; //$NON-NLS-1$
	public static final String CASH_DRAWER_TRANSFER_USER = "Cash drawer assignment change"; //$NON-NLS-1$

	public static final String USER_CREATED = "user created"; //$NON-NLS-1$
	public static final String USER_MODIFIED = "user modified"; //$NON-NLS-1$
	public static final String USER_DELETED = "user deleted"; //$NON-NLS-1$

	@Override
	public void setDescription(String description) {
		if (description != null && description.length() > 255) {
			description = description.substring(0, 255);
		}
		super.setDescription(description);
	}

	@XmlTransient
	public Object getObjectReference() {
		return objectReference;
	}

	public void setObjectReference(Object objectReference) {
		this.objectReference = objectReference;
	}
}
