package com.floreantpos.model;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.xml.bind.annotation.XmlRootElement;

import org.apache.commons.lang.StringUtils;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.base.BaseMenuPage;
import com.floreantpos.model.dao.MenuPageDAO;

@JsonIgnoreProperties(ignoreUnknown = true, value = { "cellItemMap" })
@XmlRootElement
public class MenuPage extends BaseMenuPage implements TimedModel {
	private static final long serialVersionUID = 1L;
	public static final int MAX_SIZE = 16;
	private boolean updateLastUpdateTime = true;
	private boolean updateSyncTime = false;
	private Map<String, MenuPageItem> cellItemMap;

	public MenuPage() {
	}

	public MenuPage(java.lang.String id) {
		super(id);
	}

	public boolean isUpdateSyncTime() {
		return updateSyncTime;
	}

	public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
		this.updateSyncTime = shouldUpdateSyncTime;
	}

	public boolean isUpdateLastUpdateTime() {
		return updateLastUpdateTime;
	}

	public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
		this.updateLastUpdateTime = shouldUpdateUpdateTime;
	}

	@Override
	public Integer getButtonWidth() {
		Integer buttonWidth = super.getButtonWidth();
		if (buttonWidth < 30) {
			return 30;
		}
		if (buttonWidth > 300) {
			return 300;
		}
		return buttonWidth;
	}

	@Override
	public Integer getButtonHeight() {
		Integer buttonHeight = super.getButtonHeight();
		if (buttonHeight < 30) {
			return 30;
		}
		if (buttonHeight > 300) {
			return 300;
		}
		return buttonHeight;
	}

	public MenuPageItem getItemForCell(int col, int row) {
		MenuPageDAO.getInstance().initialize(this);
		List<MenuPageItem> pageItems = getPageItems();
		if (pageItems == null || pageItems.size() == 0) {
			return null;
		}
		if (cellItemMap == null || cellItemMap.size() != pageItems.size()) {
			cellItemMap = new HashMap<String, MenuPageItem>();
			for (MenuPageItem menuPageItem : pageItems) {
				String cellKey = String.valueOf(menuPageItem.getCol()) + String.valueOf(menuPageItem.getRow());
				cellItemMap.put(cellKey, menuPageItem);
			}
		}

		String cellKey = String.valueOf(col) + String.valueOf(row);
		MenuPageItem menuPageItem = cellItemMap.get(cellKey);
		if (menuPageItem == null || StringUtils.isEmpty(menuPageItem.getMenuItemId()) || StringUtils.isEmpty(menuPageItem.getMenuItemName())) {
			return null;
		}
		return menuPageItem;
	}

	@Override
	public String toString() {
		return super.getName();
	}

}