package com.floreantpos.model;

import javax.swing.ImageIcon;

import org.apache.commons.lang.StringUtils;

import com.floreantpos.model.base.BaseSiiopaCustomer;
import com.floreantpos.model.dao.CustomerGroupDAO;
import com.floreantpos.util.AESencrp;
import com.floreantpos.util.POSUtil;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

public class SiiopaCustomer extends BaseSiiopaCustomer implements TimedModel {
	private static final long serialVersionUID = 1L;

	private Boolean selected;
	private transient JsonObject propertiesContainer;

	private boolean updateLastUpdateTime = true;
	private boolean updateSyncTime = false;

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public SiiopaCustomer() {
	}

	/**
	 * Constructor for primary key
	 */
	public SiiopaCustomer(java.lang.String id) {
		super(id);
	}

	/*[CONSTRUCTOR MARKER END]*/
	public boolean isUpdateSyncTime() {
		return updateSyncTime;
	}

	public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
		this.updateSyncTime = shouldUpdateSyncTime;
	}

	public boolean isUpdateLastUpdateTime() {
		return updateLastUpdateTime;
	}

	public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
		this.updateLastUpdateTime = shouldUpdateUpdateTime;
	}

	@Override
	public String toString() {
		String fName = getName();
		if (fName == null) {
			fName = getEmail();
		}
		return fName;
	}

	public ImageIcon getImage() {
		return null;
	}

	public String getName() {
		String name = super.getFirstName(); //$NON-NLS-1$
		if (StringUtils.isNotEmpty(super.getLastName())) {
			name += " " + super.getLastName(); //$NON-NLS-1$
		}
		return name;
	}

	@Override
	public void setMobileNo(String mobileNo) {
		if (StringUtils.isNotEmpty(mobileNo)) {
			mobileNo = mobileNo.replaceAll("(\\+)?\\D", "$1"); //$NON-NLS-1$ //$NON-NLS-2$
		}
		super.setMobileNo(mobileNo);
	}

	@Override
	public void setWorkPhoneNo(String workPhoneNo) {
		if (StringUtils.isNotEmpty(workPhoneNo)) {
			workPhoneNo = workPhoneNo.replaceAll("(\\+)?\\D", "$1"); //$NON-NLS-1$ //$NON-NLS-2$
		}
		super.setWorkPhoneNo(workPhoneNo);
	}

	@Override
	public void setHomePhoneNo(String homePhoneNo) {
		if (StringUtils.isNotEmpty(homePhoneNo)) {
			homePhoneNo = homePhoneNo.replaceAll("(\\+)?\\D", "$1"); //$NON-NLS-1$ //$NON-NLS-2$
		}
		super.setHomePhoneNo(homePhoneNo);
	}

	public Boolean isSelected() {
		return selected == null ? Boolean.FALSE : selected;
	}

	public void setSelected(Boolean enable) {
		this.selected = enable;
	}

	public CustomerGroup getCustomerGroup() {
		if (StringUtils.isNotEmpty(getCustomerGroupId())) {
			return CustomerGroupDAO.getInstance().get(getCustomerGroupId());
		}
		return null;
	}

	public void setCustomerGroup(CustomerGroup customerGroup) {
		String customerGroupId = null;
		if (customerGroup != null) {
			customerGroupId = customerGroup.getId();
		}
		super.setCustomerGroupId(customerGroupId);
	}

	public void setEncryptedSecretCode(String secretCode) {
		try {
			setSecretCode(AESencrp.encrypt(secretCode));
		} catch (Exception e) {
			setSecretCode(secretCode);
		}
	}

	public String getUnencryptedSecretCode() {
		String secretKey = getSecretCode();
		if (StringUtils.isNotEmpty(secretKey)) {
			try {
				secretKey = AESencrp.decrypt(secretKey);
			} catch (Exception e) {
			}
		}
		return secretKey;
	}

	public void setEncryptedPin(String pin) {
		try {
			setPin(AESencrp.encrypt(pin));
		} catch (Exception e) {
			setPin(pin);
		}
	}

	public String getUnencryptedPin() {
		String pin = getPin();
		if (StringUtils.isNotEmpty(pin)) {
			try {
				pin = AESencrp.decrypt(pin);
			} catch (Exception e) {
			}
		}
		return pin;
	}

	@Override
	public String getProperties() {
		if (propertiesContainer != null) {
			return propertiesContainer.toString();
		}

		String properties = super.getProperties();
		if (StringUtils.isEmpty(properties)) {
			return null;
		}

		propertiesContainer = new Gson().fromJson(properties, JsonObject.class);
		return properties;
	}

	@Override
	public void setProperties(String properties) {
		super.setProperties(properties);
		if (StringUtils.isNotEmpty(properties)) {
			propertiesContainer = new Gson().fromJson(properties, JsonObject.class);
		}
	}

	public void addProperty(String key, String value) {
		if (propertiesContainer == null) {
			propertiesContainer = new JsonObject();
		}
		if (StringUtils.isNotEmpty(value)) {
			propertiesContainer.addProperty(key, value);
		}
	}

	public String getProperty(String key) {
		if (propertiesContainer == null) {
			return null;
		}
		if (propertiesContainer.has(key)) {
			JsonElement jsonElement = propertiesContainer.get(key);
			if (!jsonElement.isJsonNull()) {
				return jsonElement.getAsString();
			}
		}
		return null;
	}

	public boolean hasProperty(String key) {
		return getProperty(key) != null;
	}

	public boolean isPropertyValueTrue(String propertyName) {
		String property = getProperty(propertyName);

		return POSUtil.getBoolean(property);
	}

	public void removeProperty(String propertyName) {
		if (propertiesContainer != null) {
			propertiesContainer.remove(propertyName);
		}
	}

}