package com.floreantpos.model.base;

import java.lang.Comparable;
import java.io.Serializable;


/**
 * This is an object that contains data related to the PURCHASE_ORDER table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="PURCHASE_ORDER"
 */

public abstract class BasePurchaseOrder  implements Comparable, Serializable {

	public static String REF = "PurchaseOrder"; //$NON-NLS-1$
	public static String PROP_LAST_MODIFIED_DATE = "lastModifiedDate"; //$NON-NLS-1$
	public static String PROP_ADVANCE_AMOUNT = "advanceAmount"; //$NON-NLS-1$
	public static String PROP_SUBTOTAL_AMOUNT = "subtotalAmount"; //$NON-NLS-1$
	public static String PROP_DUE_AMOUNT = "dueAmount"; //$NON-NLS-1$
	public static String PROP_SENT_DATE = "sentDate"; //$NON-NLS-1$
	public static String PROP_RECEIVING_DATE = "receivingDate"; //$NON-NLS-1$
	public static String PROP_NAME = "name"; //$NON-NLS-1$
	public static String PROP_TAX_AMOUNT = "taxAmount"; //$NON-NLS-1$
	public static String PROP_LAST_UPDATE_TIME = "lastUpdateTime"; //$NON-NLS-1$
	public static String PROP_LAST_SYNC_TIME = "lastSyncTime"; //$NON-NLS-1$
	public static String PROP_VARIFICATION_DATE = "varificationDate"; //$NON-NLS-1$
	public static String PROP_INVOICE_NUMBER = "invoiceNumber"; //$NON-NLS-1$
	public static String PROP_DELETED = "deleted"; //$NON-NLS-1$
	public static String PROP_STATUS = "status"; //$NON-NLS-1$
	public static String PROP_OUTLET_ID = "outletId"; //$NON-NLS-1$
	public static String PROP_PICK_UP_ADDRESS = "pickUpAddress"; //$NON-NLS-1$
	public static String PROP_SHIP_DATE = "shipDate"; //$NON-NLS-1$
	public static String PROP_TOTAL_AMOUNT = "totalAmount"; //$NON-NLS-1$
	public static String PROP_VENDOR = "vendor"; //$NON-NLS-1$
	public static String PROP_ORDER_ID = "orderId"; //$NON-NLS-1$
	public static String PROP_TERMINAL = "terminal"; //$NON-NLS-1$
	public static String PROP_DISCOUNT_AMOUNT = "discountAmount"; //$NON-NLS-1$
	public static String PROP_PAID_AMOUNT = "paidAmount"; //$NON-NLS-1$
	public static String PROP_TYPE = "type"; //$NON-NLS-1$
	public static String PROP_CREATED_DATE = "createdDate"; //$NON-NLS-1$
	public static String PROP_CLOSING_DATE = "closingDate"; //$NON-NLS-1$
	public static String PROP_ID = "id"; //$NON-NLS-1$
	public static String PROP_INVENTORY_LOCATION = "inventoryLocation"; //$NON-NLS-1$
	public static String PROP_EXPECTED_DATE = "expectedDate"; //$NON-NLS-1$


	// constructors
	public BasePurchaseOrder () {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BasePurchaseOrder (java.lang.String id) {
		this.setId(id);
		initialize();
	}

	protected void initialize () {}



	private int hashCode = Integer.MIN_VALUE;

	// primary key
	private java.lang.String id;

	private long version;

	// fields
			private java.util.Date lastUpdateTime;
				private java.util.Date lastSyncTime;
				private java.lang.String type;
				private java.util.Date createdDate;
				private java.util.Date expectedDate;
				private java.util.Date shipDate;
				private java.util.Date lastModifiedDate;
				private java.util.Date varificationDate;
				private java.util.Date sentDate;
				private java.util.Date receivingDate;
				private java.util.Date closingDate;
				private java.lang.String orderId;
				private java.lang.String name;
				private java.lang.Double subtotalAmount;
				private java.lang.Double discountAmount;
				private java.lang.Double taxAmount;
				private java.lang.Double totalAmount;
				private java.lang.Double paidAmount;
				private java.lang.Double dueAmount;
				private java.lang.Double advanceAmount;
				private java.lang.Integer status;
				private java.lang.String outletId;
				private java.lang.String pickUpAddress;
				private java.lang.String invoiceNumber;
				private java.lang.Boolean deleted;
	
	// many to one
	private com.floreantpos.model.InventoryLocation inventoryLocation;
	private com.floreantpos.model.InventoryVendor vendor;
	private com.floreantpos.model.Terminal terminal;

	// collections
	private java.util.List<com.floreantpos.model.PurchaseOrderItem> orderItems;
	private java.util.Map<String, String> properties;



	/**
	 * Return the unique identifier of this class
     * @hibernate.id
     *  generator-class="com.floreantpos.util.GlobalIdGenerator"
     *  column="ID"
     */
	public java.lang.String getId () {
		return id;
	}

	/**
	 * Set the unique identifier of this class
	 * @param id the new ID
	 */
	public void setId (java.lang.String id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}



	/**
	 * Return the value associated with the column: VERSION_NO
	 */

	public long getVersion () {
			return version;
	}



	/**
	 * Set the value related to the column: VERSION_NO
	 * @param version the VERSION_NO value
	 */
			public void setVersion (long version) {
			this.version = version;
	}




	/**
	 * Return the value associated with the column: LAST_UPDATE_TIME
	 */

	public java.util.Date getLastUpdateTime () {
			return lastUpdateTime;
	}



	/**
	 * Set the value related to the column: LAST_UPDATE_TIME
	 * @param lastUpdateTime the LAST_UPDATE_TIME value
	 */
			public void setLastUpdateTime (java.util.Date lastUpdateTime) {
			this.lastUpdateTime = lastUpdateTime;
	}



	/**
	 * Return the value associated with the column: LAST_SYNC_TIME
	 */

	public java.util.Date getLastSyncTime () {
			return lastSyncTime;
	}



	/**
	 * Set the value related to the column: LAST_SYNC_TIME
	 * @param lastSyncTime the LAST_SYNC_TIME value
	 */
			public void setLastSyncTime (java.util.Date lastSyncTime) {
			this.lastSyncTime = lastSyncTime;
	}



	/**
	 * Return the value associated with the column: TYPE
	 */

	public java.lang.String getType () {
			return type;
	}



	/**
	 * Set the value related to the column: TYPE
	 * @param type the TYPE value
	 */
			public void setType (java.lang.String type) {
			this.type = type;
	}



	/**
	 * Return the value associated with the column: CREATED_DATE
	 */

	public java.util.Date getCreatedDate () {
			return createdDate;
	}



	/**
	 * Set the value related to the column: CREATED_DATE
	 * @param createdDate the CREATED_DATE value
	 */
			public void setCreatedDate (java.util.Date createdDate) {
			this.createdDate = createdDate;
	}



	/**
	 * Return the value associated with the column: EXPECTED_DATE
	 */

	public java.util.Date getExpectedDate () {
			return expectedDate;
	}



	/**
	 * Set the value related to the column: EXPECTED_DATE
	 * @param expectedDate the EXPECTED_DATE value
	 */
			public void setExpectedDate (java.util.Date expectedDate) {
			this.expectedDate = expectedDate;
	}



	/**
	 * Return the value associated with the column: SHIP_DATE
	 */

	public java.util.Date getShipDate () {
			return shipDate;
	}



	/**
	 * Set the value related to the column: SHIP_DATE
	 * @param shipDate the SHIP_DATE value
	 */
			public void setShipDate (java.util.Date shipDate) {
			this.shipDate = shipDate;
	}



	/**
	 * Return the value associated with the column: LAST_MODIFIED_DATE
	 */

	public java.util.Date getLastModifiedDate () {
			return lastModifiedDate;
	}



	/**
	 * Set the value related to the column: LAST_MODIFIED_DATE
	 * @param lastModifiedDate the LAST_MODIFIED_DATE value
	 */
			public void setLastModifiedDate (java.util.Date lastModifiedDate) {
			this.lastModifiedDate = lastModifiedDate;
	}



	/**
	 * Return the value associated with the column: VERIFICATION_DATE
	 */

	public java.util.Date getVarificationDate () {
			return varificationDate;
	}



	/**
	 * Set the value related to the column: VERIFICATION_DATE
	 * @param varificationDate the VERIFICATION_DATE value
	 */
			public void setVarificationDate (java.util.Date varificationDate) {
			this.varificationDate = varificationDate;
	}



	/**
	 * Return the value associated with the column: SENT_DATE
	 */

	public java.util.Date getSentDate () {
			return sentDate;
	}



	/**
	 * Set the value related to the column: SENT_DATE
	 * @param sentDate the SENT_DATE value
	 */
			public void setSentDate (java.util.Date sentDate) {
			this.sentDate = sentDate;
	}



	/**
	 * Return the value associated with the column: RECEIVING_DATE
	 */

	public java.util.Date getReceivingDate () {
			return receivingDate;
	}



	/**
	 * Set the value related to the column: RECEIVING_DATE
	 * @param receivingDate the RECEIVING_DATE value
	 */
			public void setReceivingDate (java.util.Date receivingDate) {
			this.receivingDate = receivingDate;
	}



	/**
	 * Return the value associated with the column: CLOSING_DATE
	 */

	public java.util.Date getClosingDate () {
			return closingDate;
	}



	/**
	 * Set the value related to the column: CLOSING_DATE
	 * @param closingDate the CLOSING_DATE value
	 */
			public void setClosingDate (java.util.Date closingDate) {
			this.closingDate = closingDate;
	}



	/**
	 * Return the value associated with the column: ORDER_ID
	 */

	public java.lang.String getOrderId () {
			return orderId;
	}



	/**
	 * Set the value related to the column: ORDER_ID
	 * @param orderId the ORDER_ID value
	 */
			public void setOrderId (java.lang.String orderId) {
			this.orderId = orderId;
	}



	/**
	 * Return the value associated with the column: NAME
	 */

	public java.lang.String getName () {
			return name;
	}



	/**
	 * Set the value related to the column: NAME
	 * @param name the NAME value
	 */
			public void setName (java.lang.String name) {
			this.name = name;
	}



	/**
	 * Return the value associated with the column: SUB_TOTAL
	 */

	public java.lang.Double getSubtotalAmount () {
						return subtotalAmount == null ? Double.valueOf(0) : subtotalAmount;
		}



	/**
	 * Set the value related to the column: SUB_TOTAL
	 * @param subtotalAmount the SUB_TOTAL value
	 */
			public void setSubtotalAmount (java.lang.Double subtotalAmount) {
			this.subtotalAmount = subtotalAmount;
	}



	/**
	 * Return the value associated with the column: TOTAL_DISCOUNT
	 */

	public java.lang.Double getDiscountAmount () {
						return discountAmount == null ? Double.valueOf(0) : discountAmount;
		}



	/**
	 * Set the value related to the column: TOTAL_DISCOUNT
	 * @param discountAmount the TOTAL_DISCOUNT value
	 */
			public void setDiscountAmount (java.lang.Double discountAmount) {
			this.discountAmount = discountAmount;
	}



	/**
	 * Return the value associated with the column: TOTAL_TAX
	 */

	public java.lang.Double getTaxAmount () {
						return taxAmount == null ? Double.valueOf(0) : taxAmount;
		}



	/**
	 * Set the value related to the column: TOTAL_TAX
	 * @param taxAmount the TOTAL_TAX value
	 */
			public void setTaxAmount (java.lang.Double taxAmount) {
			this.taxAmount = taxAmount;
	}



	/**
	 * Return the value associated with the column: TOTAL_PRICE
	 */

	public java.lang.Double getTotalAmount () {
						return totalAmount == null ? Double.valueOf(0) : totalAmount;
		}



	/**
	 * Set the value related to the column: TOTAL_PRICE
	 * @param totalAmount the TOTAL_PRICE value
	 */
			public void setTotalAmount (java.lang.Double totalAmount) {
			this.totalAmount = totalAmount;
	}



	/**
	 * Return the value associated with the column: PAID_AMOUNT
	 */

	public java.lang.Double getPaidAmount () {
						return paidAmount == null ? Double.valueOf(0) : paidAmount;
		}



	/**
	 * Set the value related to the column: PAID_AMOUNT
	 * @param paidAmount the PAID_AMOUNT value
	 */
			public void setPaidAmount (java.lang.Double paidAmount) {
			this.paidAmount = paidAmount;
	}



	/**
	 * Return the value associated with the column: DUE_AMOUNT
	 */

	public java.lang.Double getDueAmount () {
						return dueAmount == null ? Double.valueOf(0) : dueAmount;
		}



	/**
	 * Set the value related to the column: DUE_AMOUNT
	 * @param dueAmount the DUE_AMOUNT value
	 */
			public void setDueAmount (java.lang.Double dueAmount) {
			this.dueAmount = dueAmount;
	}



	/**
	 * Return the value associated with the column: ADVANCE_AMOUNT
	 */

	public java.lang.Double getAdvanceAmount () {
						return advanceAmount == null ? Double.valueOf(0) : advanceAmount;
		}



	/**
	 * Set the value related to the column: ADVANCE_AMOUNT
	 * @param advanceAmount the ADVANCE_AMOUNT value
	 */
			public void setAdvanceAmount (java.lang.Double advanceAmount) {
			this.advanceAmount = advanceAmount;
	}



	/**
	 * Return the value associated with the column: STATUS
	 */

	public java.lang.Integer getStatus () {
						return status == null ? Integer.valueOf(0) : status;
		}



	/**
	 * Set the value related to the column: STATUS
	 * @param status the STATUS value
	 */
			public void setStatus (java.lang.Integer status) {
			this.status = status;
	}



	/**
	 * Return the value associated with the column: OUTLET_ID
	 */

	public java.lang.String getOutletId () {
			return outletId;
	}



	/**
	 * Set the value related to the column: OUTLET_ID
	 * @param outletId the OUTLET_ID value
	 */
			public void setOutletId (java.lang.String outletId) {
			this.outletId = outletId;
	}



	/**
	 * Return the value associated with the column: PICKUP_ADDRESS
	 */

	public java.lang.String getPickUpAddress () {
			return pickUpAddress;
	}



	/**
	 * Set the value related to the column: PICKUP_ADDRESS
	 * @param pickUpAddress the PICKUP_ADDRESS value
	 */
			public void setPickUpAddress (java.lang.String pickUpAddress) {
			this.pickUpAddress = pickUpAddress;
	}



	/**
	 * Return the value associated with the column: INVOICE_NUMBER
	 */

	public java.lang.String getInvoiceNumber () {
			return invoiceNumber;
	}



	/**
	 * Set the value related to the column: INVOICE_NUMBER
	 * @param invoiceNumber the INVOICE_NUMBER value
	 */
			public void setInvoiceNumber (java.lang.String invoiceNumber) {
			this.invoiceNumber = invoiceNumber;
	}



	/**
	 * Return the value associated with the column: DELETED
	 */

	public java.lang.Boolean isDeleted () {
						return deleted == null ? Boolean.valueOf(false) : deleted;
			}

	public java.lang.Boolean getDeleted () {
					return deleted == null ? Boolean.valueOf(false) : deleted;
			}


	/**
	 * Set the value related to the column: DELETED
	 * @param deleted the DELETED value
	 */
			public void setDeleted (java.lang.Boolean deleted) {
			this.deleted = deleted;
	}


	/**
	 * Custom property
	 */
	public static String getDeletedDefaultValue () {
		return "false";
	}


	/**
	 * Return the value associated with the column: INVENTORY_LOCATION
	 */

	public com.floreantpos.model.InventoryLocation getInventoryLocation () {
			return inventoryLocation;
	}



	/**
	 * Set the value related to the column: INVENTORY_LOCATION
	 * @param inventoryLocation the INVENTORY_LOCATION value
	 */
			public void setInventoryLocation (com.floreantpos.model.InventoryLocation inventoryLocation) {
			this.inventoryLocation = inventoryLocation;
	}



	/**
	 * Return the value associated with the column: VENDOR_ID
	 */

	public com.floreantpos.model.InventoryVendor getVendor () {
			return vendor;
	}



	/**
	 * Set the value related to the column: VENDOR_ID
	 * @param vendor the VENDOR_ID value
	 */
			public void setVendor (com.floreantpos.model.InventoryVendor vendor) {
			this.vendor = vendor;
	}



	/**
	 * Return the value associated with the column: TERMINAL_ID
	 */

	public com.floreantpos.model.Terminal getTerminal () {
			return terminal;
	}



	/**
	 * Set the value related to the column: TERMINAL_ID
	 * @param terminal the TERMINAL_ID value
	 */
			public void setTerminal (com.floreantpos.model.Terminal terminal) {
			this.terminal = terminal;
	}



	/**
	 * Return the value associated with the column: orderItems
	 */

	public java.util.List<com.floreantpos.model.PurchaseOrderItem> getOrderItems () {
			return orderItems;
	}



	/**
	 * Set the value related to the column: orderItems
	 * @param orderItems the orderItems value
	 */
			public void setOrderItems (java.util.List<com.floreantpos.model.PurchaseOrderItem> orderItems) {
			this.orderItems = orderItems;
	}

	public void addToorderItems (com.floreantpos.model.PurchaseOrderItem purchaseOrderItem) {
		if (null == getOrderItems()) setOrderItems(new java.util.ArrayList<com.floreantpos.model.PurchaseOrderItem>());
		getOrderItems().add(purchaseOrderItem);
	}



	/**
	 * Return the value associated with the column: properties
	 */

	public java.util.Map<String, String> getProperties () {
			return properties;
	}



	/**
	 * Set the value related to the column: properties
	 * @param properties the properties value
	 */
			public void setProperties (java.util.Map<String, String> properties) {
			this.properties = properties;
	}





	public boolean equals (Object obj) {
		if (null == obj) return false;
		if (!(obj instanceof com.floreantpos.model.PurchaseOrder)) return false;
		else {
			com.floreantpos.model.PurchaseOrder purchaseOrder = (com.floreantpos.model.PurchaseOrder) obj;
			if (null == this.getId() || null == purchaseOrder.getId()) return this == obj;
			else return (this.getId().equals(purchaseOrder.getId()));
		}
	}

	public int hashCode () {
		if (Integer.MIN_VALUE == this.hashCode) {
			if (null == this.getId()) return super.hashCode();
			else {
				String hashStr = this.getClass().getName() + ":" + this.getId().hashCode();
				this.hashCode = hashStr.hashCode();
			}
		}
		return this.hashCode;
	}

	public int compareTo (Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString () {
		return super.toString();
	}


}