/**
 * ************************************************************************
 * * The contents of this file are subject to the MRPL 1.2
 * * (the  "License"),  being   the  Mozilla   Public  License
 * * Version 1.1  with a permitted attribution clause; you may not  use this
 * * file except in compliance with the License. You  may  obtain  a copy of
 * * the License at http://www.floreantpos.org/license.html
 * * Software distributed under the License  is  distributed  on  an "AS IS"
 * * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * * License for the specific  language  governing  rights  and  limitations
 * * under the License.
 * * The Original Code is FLOREANT POS.
 * * The Initial Developer of the Original Code is OROCUBE LLC
 * * All portions are Copyright (C) 2015 OROCUBE LLC
 * * All Rights Reserved.
 * ************************************************************************
 */
package com.floreantpos.report;

import java.util.Date;

import com.floreantpos.model.User;

public class WeeklyPayrollReportData {
	private User user;
	private long totalWorkHourMs;
	private double regularWorkHour;
	private double overtimeHour;
	private double costPerHour, overtimeRatePerHour;
	private double regularPayment, overtimePayment, totalPayment;
	private Date fromDateOfWeek, toDateOfWeek;
	private double totalDeclaredTips, totalNoCashTips;
	private int firstDayOfWeek;
	private String regularHourDisplay, overtimeDisplay, totalHourDisplay;

	public void calculateTotalHour() {
		double totalWorkHour = totalWorkHourMs / 3600000d;
		regularWorkHour = totalWorkHour < 40 ? totalWorkHour : 40;
		overtimeHour = (totalWorkHour > 40) ? totalWorkHour - 40 : 0;
		costPerHour = user.getCostPerHour();
		overtimeRatePerHour = user.getOvertimeRatePerHour();
		regularPayment = regularWorkHour * costPerHour;
		overtimePayment = overtimeHour * overtimeRatePerHour;
		totalPayment = regularPayment + overtimePayment;

		long totalWorkInHour = getHour(totalWorkHourMs);
		long totalWorkInMin = getMin(totalWorkHourMs);

		totalHourDisplay = totalWorkInHour + "h " + totalWorkInMin + "m"; //$NON-NLS-1$ //$NON-NLS-2$
		regularHourDisplay = totalWorkHour < 40 ? totalHourDisplay : 40 + "h"; //$NON-NLS-1$

		long overtimeMS = (long) (overtimeHour * 3600000);
		long otHour = getHour(overtimeMS);
		long otMin = getMin(overtimeMS);
		overtimeDisplay = otHour + "h " + otMin + "m"; //$NON-NLS-1$ //$NON-NLS-2$
	}

	private long getHour(long valueInMS) {
		return valueInMS / (60 * 60 * 1000);
	}

	private long getMin(long valueInMS) {
		long hour = valueInMS / (60 * 60 * 1000);
		valueInMS = valueInMS - hour * (60 * 60 * 1000);
		return valueInMS / (60 * 1000);
	}

	public User getUser() {
		return user;
	}

	public void setUser(User user) {
		this.user = user;
	}

	public double getRegularHour() {
		return regularWorkHour;
	}

	public void setRegularHour(double totalHour) {
		this.regularWorkHour = totalHour;
	}

	public double getRate() {
		return costPerHour;
	}

	public void setRate(double rate) {
		this.costPerHour = rate;
	}

	public double getTotalPayment() {
		return totalPayment;
	}

	public void setTotalPayment(double payment) {
		this.totalPayment = payment;
	}

	public Date getFromDateOfWeek() {
		return fromDateOfWeek;
	}

	public void setFromDateOfWeek(Date fromDateOfWeek) {
		this.fromDateOfWeek = fromDateOfWeek;
	}

	public Date getToDateOfWeek() {
		return toDateOfWeek;
	}

	public void setToDateOfWeek(Date toDateOfWeek) {
		this.toDateOfWeek = toDateOfWeek;
	}

	public double getOvertime() {
		return overtimeHour;
	}

	public void setOvertime(double overtime) {
		this.overtimeHour = overtime;
	}

	public double getOvertimeRate() {
		return overtimeRatePerHour;
	}

	public void setOvertimeRate(double overtimeRate) {
		this.overtimeRatePerHour = overtimeRate;
	}

	public double getRegularPayment() {
		return regularPayment;
	}

	public void setRegularPayment(double regularPayment) {
		this.regularPayment = regularPayment;
	}

	public double getOvertimePayment() {
		return overtimePayment;
	}

	public void setOvertimePayment(double overtimePayment) {
		this.overtimePayment = overtimePayment;
	}

	public double getTotalDeclaredTips() {
		return totalDeclaredTips;
	}

	public void setTotalDeclaredTips(double totalDeclaredTips) {
		this.totalDeclaredTips = totalDeclaredTips;
	}

	public double getTotalNoCashTips() {
		return totalNoCashTips;
	}

	public void setTotalNoCashTips(double totalNoCashTips) {
		this.totalNoCashTips = totalNoCashTips;
	}

	public int getFirstDayOfWeek() {
		return firstDayOfWeek;
	}

	public void setFirstDayOfWeek(int firstDayOfWeek) {
		this.firstDayOfWeek = firstDayOfWeek;
	}

	public long getTotalWorkHourMs() {
		return totalWorkHourMs;
	}

	public void setTotalWorkHourMs(long totalWorkHourMs) {
		this.totalWorkHourMs = totalWorkHourMs;
	}

	public String getRegularHourDisplay() {
		return regularHourDisplay;
	}

	public void setRegularHourDisplay(String regularHourDisplay) {
		this.regularHourDisplay = regularHourDisplay;
	}

	public String getOvertimeDisplay() {
		return overtimeDisplay;
	}

	public void setOvertimeDisplay(String overtimeDisplay) {
		this.overtimeDisplay = overtimeDisplay;
	}

	public String getTotalHourDisplay() {
		return totalHourDisplay;
	}

	public void setTotalHourDisplay(String totalHourDisplay) {
		this.totalHourDisplay = totalHourDisplay;
	}
}
