package com.floreantpos.model;

public enum TicketSource {
	Default,
	Online
	;
	
	public static TicketSource fromName(String name) {
		TicketSource[] values = values();
		for (TicketSource ticketSource : values) {
			if (ticketSource.name().equalsIgnoreCase(name)) {
				return ticketSource;
			}
		}
		
		return TicketSource.Default;
	}
}
