package com.floreantpos.model.base;

import java.lang.Comparable;
import java.io.Serializable;


/**
 * This is an object that contains data related to the INVOICE table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="INVOICE"
 */

public abstract class BaseInvoice  implements Comparable, Serializable {

	public static String REF = "Invoice"; //$NON-NLS-1$
	public static String PROP_OUTLET_ID = "outletId"; //$NON-NLS-1$
	public static String PROP_EXPIRY_DATE = "expiryDate"; //$NON-NLS-1$
	public static String PROP_CUSTOMER_ID = "customerId"; //$NON-NLS-1$
	public static String PROP_OWNER_ID = "ownerId"; //$NON-NLS-1$
	public static String PROP_INVOICE_ID = "invoiceId"; //$NON-NLS-1$
	public static String PROP_PROPERTIES = "properties"; //$NON-NLS-1$
	public static String PROP_TICKET_JSON = "ticketJson"; //$NON-NLS-1$
	public static String PROP_ORDER_DATE = "orderDate"; //$NON-NLS-1$
	public static String PROP_ORDER_STATUS = "orderStatus"; //$NON-NLS-1$
	public static String PROP_TICKET_ID = "ticketId"; //$NON-NLS-1$
	public static String PROP_ORDER_TYPE = "orderType"; //$NON-NLS-1$
	public static String PROP_LAST_UPDATE_TIME = "lastUpdateTime"; //$NON-NLS-1$
	public static String PROP_LAST_SYNC_TIME = "lastSyncTime"; //$NON-NLS-1$
	public static String PROP_ID = "id"; //$NON-NLS-1$
	public static String PROP_DUE_DATE = "dueDate"; //$NON-NLS-1$
	public static String PROP_DELETED = "deleted"; //$NON-NLS-1$


	// constructors
	public BaseInvoice () {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BaseInvoice (java.lang.String id) {
		this.setId(id);
		initialize();
	}

	protected void initialize () {}



	private int hashCode = Integer.MIN_VALUE;

	// primary key
	private java.lang.String id;

	 long version;

	// fields
			private java.util.Date lastUpdateTime;
				private java.util.Date lastSyncTime;
				private java.util.Date orderDate;
				private java.util.Date dueDate;
				private java.lang.Integer invoiceId;
				private java.lang.String customerId;
				private java.lang.String ownerId;
				private java.lang.String outletId;
				private java.lang.String ticketId;
				private java.lang.String orderType;
				private java.lang.String orderStatus;
				private java.util.Date expiryDate;
				private java.lang.String ticketJson;
				private java.lang.String properties;
				private java.lang.Boolean deleted;
				
	


	/**
	 * Return the unique identifier of this class
     * @hibernate.id
     *  generator-class="com.floreantpos.util.UUIdGenerator"
     *  column="ID"
     */
	public java.lang.String getId () {
		return id;
	}

	/**
	 * Set the unique identifier of this class
	 * @param id the new ID
	 */
	public void setId (java.lang.String id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}



	/**
	 * Return the value associated with the column: VERSION_NO
	 */

	public long getVersion () {
			return version;
	}



	/**
	 * Set the value related to the column: VERSION_NO
	 * @param version the VERSION_NO value
	 */
			public void setVersion (long version) {
			this.version = version;
	}




	/**
	 * Return the value associated with the column: LAST_UPDATE_TIME
	 */

	public java.util.Date getLastUpdateTime () {
			return lastUpdateTime;
	}



	/**
	 * Set the value related to the column: LAST_UPDATE_TIME
	 * @param lastUpdateTime the LAST_UPDATE_TIME value
	 */
			public void setLastUpdateTime (java.util.Date lastUpdateTime) {
			this.lastUpdateTime = lastUpdateTime;
	}



	/**
	 * Return the value associated with the column: LAST_SYNC_TIME
	 */

	public java.util.Date getLastSyncTime () {
			return lastSyncTime;
	}



	/**
	 * Set the value related to the column: LAST_SYNC_TIME
	 * @param lastSyncTime the LAST_SYNC_TIME value
	 */
			public void setLastSyncTime (java.util.Date lastSyncTime) {
			this.lastSyncTime = lastSyncTime;
	}



	/**
	 * Return the value associated with the column: ORDER_DATE
	 */

	public java.util.Date getOrderDate () {
			return orderDate;
	}



	/**
	 * Set the value related to the column: ORDER_DATE
	 * @param orderDate the ORDER_DATE value
	 */
			public void setOrderDate (java.util.Date orderDate) {
			this.orderDate = orderDate;
	}



	/**
	 * Return the value associated with the column: DUE_DATE
	 */

	public java.util.Date getDueDate () {
			return dueDate;
	}



	/**
	 * Set the value related to the column: DUE_DATE
	 * @param dueDate the DUE_DATE value
	 */
			public void setDueDate (java.util.Date dueDate) {
			this.dueDate = dueDate;
	}



	/**
	 * Return the value associated with the column: INVOICE_ID
	 */

	public java.lang.Integer getInvoiceId () {
			return invoiceId;
	}



	/**
	 * Set the value related to the column: INVOICE_ID
	 * @param invoiceId the INVOICE_ID value
	 */
			public void setInvoiceId (java.lang.Integer invoiceId) {
			this.invoiceId = invoiceId;
	}



	/**
	 * Return the value associated with the column: CUST_ID
	 */

	public java.lang.String getCustomerId () {
			return customerId;
	}



	/**
	 * Set the value related to the column: CUST_ID
	 * @param customerId the CUST_ID value
	 */
			public void setCustomerId (java.lang.String customerId) {
			this.customerId = customerId;
	}

	/**
	 * Return the value associated with the column: OWNER_ID
	 */

	public java.lang.String getOwnerId () {
			return ownerId;
	}



	/**
	 * Set the value related to the column: OWNER_ID
	 * @param ownerId the OWNER_ID value
	 */
			public void setOwnerId (java.lang.String ownerId) {
			this.ownerId = ownerId;
	}


	/**
	 * Return the value associated with the column: OUTLET_ID
	 */

	public java.lang.String getOutletId () {
			return outletId;
	}



	/**
	 * Set the value related to the column: OUTLET_ID
	 * @param outletId the OUTLET_ID value
	 */
			public void setOutletId (java.lang.String outletId) {
			this.outletId = outletId;
	}



	/**
	 * Return the value associated with the column: TICKET_ID
	 */

	public java.lang.String getTicketId () {
			return ticketId;
	}



	/**
	 * Set the value related to the column: TICKET_ID
	 * @param ticketId the TICKET_ID value
	 */
			public void setTicketId (java.lang.String ticketId) {
			this.ticketId = ticketId;
	}



	/**
	 * Return the value associated with the column: ORDER_TYPE
	 */

	public java.lang.String getOrderType () {
			return orderType;
	}



	/**
	 * Set the value related to the column: ORDER_TYPE
	 * @param orderType the ORDER_TYPE value
	 */
			public void setOrderType (java.lang.String orderType) {
			this.orderType = orderType;
	}



	/**
	 * Return the value associated with the column: ORDER_STATUS
	 */

	public java.lang.String getOrderStatus () {
			return orderStatus;
	}



	/**
	 * Set the value related to the column: ORDER_STATUS
	 * @param orderStatus the ORDER_STATUS value
	 */
			public void setOrderStatus (java.lang.String orderStatus) {
			this.orderStatus = orderStatus;
	}



	/**
	 * Return the value associated with the column: EXPIRY_DATE
	 */

	public java.util.Date getExpiryDate () {
			return expiryDate;
	}



	/**
	 * Set the value related to the column: EXPIRY_DATE
	 * @param expiryDate the EXPIRY_DATE value
	 */
			public void setExpiryDate (java.util.Date expiryDate) {
			this.expiryDate = expiryDate;
	}



	/**
	 * Return the value associated with the column: TICKET_JSON
	 */

	public java.lang.String getTicketJson () {
			return ticketJson;
	}



	/**
	 * Set the value related to the column: TICKET_JSON
	 * @param ticketJson the TICKET_JSON value
	 */
			public void setTicketJson (java.lang.String ticketJson) {
			this.ticketJson = ticketJson;
	}



	/**
	 * Return the value associated with the column: PROPERTIES
	 */

	public java.lang.String getProperties () {
			return properties;
	}



	/**
	 * Set the value related to the column: PROPERTIES
	 * @param properties the PROPERTIES value
	 */
			public void setProperties (java.lang.String properties) {
			this.properties = properties;
	}


	/**
	 * Return the value associated with the column: DELETED
	 */

	public java.lang.Boolean isDeleted () {
						return deleted == null ? Boolean.valueOf(false) : deleted;
			}

	public java.lang.Boolean getDeleted () {
					return deleted == null ? Boolean.valueOf(false) : deleted;
			}


	/**
	 * Set the value related to the column: DELETED
	 * @param deleted the DELETED value
	 */
			public void setDeleted (java.lang.Boolean deleted) {
			this.deleted = deleted;
	}


	/**
	 * Custom property
	 */
	public static String getDeletedDefaultValue () {
		return "false";
	}



	public boolean equals (Object obj) {
		if (null == obj) return false;
		if (!(obj instanceof com.floreantpos.model.Invoice)) return false;
		else {
			com.floreantpos.model.Invoice invoice = (com.floreantpos.model.Invoice) obj;
			if (null == this.getId() || null == invoice.getId()) return this == obj;
			else return (this.getId().equals(invoice.getId()));
		}
	}

	public int hashCode () {
		if (Integer.MIN_VALUE == this.hashCode) {
			if (null == this.getId()) return super.hashCode();
			else {
				String hashStr = this.getClass().getName() + ":" + this.getId().hashCode();
				this.hashCode = hashStr.hashCode();
			}
		}
		return this.hashCode;
	}

	public int compareTo (Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString () {
		return super.toString();
	}


}