package com.floreantpos.model.base;

import java.lang.Comparable;
import java.io.Serializable;


/**
 * This is an object that contains data related to the SHOP_TABLE_STATUS table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="SHOP_TABLE_STATUS"
 */

public abstract class BaseShopTableStatus  implements Comparable, Serializable {

	public static String REF = "ShopTableStatus"; //$NON-NLS-1$
	public static String PROP_LAST_UPDATE_TIME = "lastUpdateTime"; //$NON-NLS-1$
	public static String PROP_LAST_SYNC_TIME = "lastSyncTime"; //$NON-NLS-1$
	public static String PROP_TICKET_INFORMATIONS = "ticketInformations"; //$NON-NLS-1$
	public static String PROP_TABLE_STATUS_NUM = "tableStatusNum"; //$NON-NLS-1$
	public static String PROP_PROPERTIES = "properties"; //$NON-NLS-1$


	// constructors
	public BaseShopTableStatus () {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BaseShopTableStatus (
		java.lang.Integer id,
		java.lang.String outletId) {

		this.setId(id);
		this.setOutletId(outletId);
		initialize();
	}

	protected void initialize () {}



	private int hashCode = Integer.MIN_VALUE;

	// primary key

	private java.lang.Integer id;

	private java.lang.String outletId;

	 long version;

	// fields
			private java.util.Date lastUpdateTime;
				private java.util.Date lastSyncTime;
				private java.lang.Integer tableStatusNum;
				private java.lang.String ticketInformations;
				private java.lang.String properties;
	


	/**
     * @hibernate.property
     *  column=ID
	 * not-null=true
	 */
	public java.lang.Integer getId () {
		return this.id;
	}

	/**
	 * Set the value related to the column: ID
	 * @param id the ID value
	 */
	public void setId (java.lang.Integer id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}

	/**
     * @hibernate.property
     *  column=OUTLET_ID
	 * not-null=true
	 */
	public java.lang.String getOutletId () {
		return this.outletId;
	}

	/**
	 * Set the value related to the column: OUTLET_ID
	 * @param outletId the OUTLET_ID value
	 */
	public void setOutletId (java.lang.String outletId) {
		this.outletId = outletId;
		this.hashCode = Integer.MIN_VALUE;
	}



	/**
	 * Return the value associated with the column: VERSION_NO
	 */

	public long getVersion () {
			return version;
	}



	/**
	 * Set the value related to the column: VERSION_NO
	 * @param version the VERSION_NO value
	 */
			public void setVersion (long version) {
			this.version = version;
	}




	/**
	 * Return the value associated with the column: LAST_UPDATE_TIME
	 */

	public java.util.Date getLastUpdateTime () {
			return lastUpdateTime;
	}



	/**
	 * Set the value related to the column: LAST_UPDATE_TIME
	 * @param lastUpdateTime the LAST_UPDATE_TIME value
	 */
			public void setLastUpdateTime (java.util.Date lastUpdateTime) {
			this.lastUpdateTime = lastUpdateTime;
	}



	/**
	 * Return the value associated with the column: LAST_SYNC_TIME
	 */

	public java.util.Date getLastSyncTime () {
			return lastSyncTime;
	}



	/**
	 * Set the value related to the column: LAST_SYNC_TIME
	 * @param lastSyncTime the LAST_SYNC_TIME value
	 */
			public void setLastSyncTime (java.util.Date lastSyncTime) {
			this.lastSyncTime = lastSyncTime;
	}



	/**
	 * Return the value associated with the column: TABLE_STATUS
	 */

	public java.lang.Integer getTableStatusNum () {
						return tableStatusNum == null ? Integer.valueOf(0) : tableStatusNum;
		}



	/**
	 * Set the value related to the column: TABLE_STATUS
	 * @param tableStatusNum the TABLE_STATUS value
	 */
			public void setTableStatusNum (java.lang.Integer tableStatusNum) {
			this.tableStatusNum = tableStatusNum;
	}



	/**
	 * Return the value associated with the column: TICKET_INFORMATIONS
	 */

	public java.lang.String getTicketInformations () {
			return ticketInformations;
	}



	/**
	 * Set the value related to the column: TICKET_INFORMATIONS
	 * @param ticketInformations the TICKET_INFORMATIONS value
	 */
			public void setTicketInformations (java.lang.String ticketInformations) {
			this.ticketInformations = ticketInformations;
	}



	/**
	 * Return the value associated with the column: PROPERTIES
	 */

	public java.lang.String getProperties () {
			return properties;
	}



	/**
	 * Set the value related to the column: PROPERTIES
	 * @param properties the PROPERTIES value
	 */
			public void setProperties (java.lang.String properties) {
			this.properties = properties;
	}





	public boolean equals (Object obj) {
		if (null == obj) return false;//abcd
		if (!(obj instanceof com.floreantpos.model.ShopTableStatus)) return false;
		else {
			com.floreantpos.model.ShopTableStatus shopTableStatus = (com.floreantpos.model.ShopTableStatus) obj;
			if (null != this.getId() && null != shopTableStatus.getId()) {
				if (!this.getId().equals(shopTableStatus.getId())) {
					return false;
				}
			}
			else {
				return false;
			}
			if (null != this.getOutletId() && null != shopTableStatus.getOutletId()) {
				if (!this.getOutletId().equals(shopTableStatus.getOutletId())) {
					return false;
				}
			}
			else {
				return false;
			}
			return true;
		}
	}

	public int hashCode () {
		if (Integer.MIN_VALUE == this.hashCode) {
			StringBuilder sb = new StringBuilder();
			if (null != this.getId()) {
				sb.append(this.getId().hashCode());
				sb.append(":");
			}
			else {
				return super.hashCode();
			}
			if (null != this.getOutletId()) {
				sb.append(this.getOutletId().hashCode());
				sb.append(":");
			}
			else {
				return super.hashCode();
			}
			this.hashCode = sb.toString().hashCode();
		}
		return this.hashCode;
	}

	public int compareTo (Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString () {
		return super.toString();
	}


}