package com.floreantpos.model.dao;

import java.io.Serializable;
import java.util.List;

import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

import com.floreantpos.model.MenuItemSize;
import com.floreantpos.model.PizzaModifierPrice;

public class PizzaModifierPriceDAO extends BasePizzaModifierPriceDAO {

	/**
	 * Default constructor.  Can be used in place of getInstance()
	 */
	public PizzaModifierPriceDAO() {
	}

	@Override
	protected Serializable save(Object obj, Session s) {
		updateTime(obj);
		return super.save(obj, s);
	}

	@Override
	protected void update(Object obj, Session s) {
		updateTime(obj);
		super.update(obj, s);
	}

	@Override
	protected void saveOrUpdate(Object obj, Session s) {
		updateTime(obj);
		super.saveOrUpdate(obj, s);
	}

	public List<String> findByMenuItemSize(MenuItemSize menuItemSize, Session session) {
		Criteria criteria = session.createCriteria(getReferenceClass());
		criteria.add(Restrictions.eq(PizzaModifierPrice.PROP_SIZE, menuItemSize));
		criteria.setProjection(Projections.alias(Projections.property(PizzaModifierPrice.PROP_ID), PizzaModifierPrice.PROP_ID));
		return criteria.list();
	}

}