package com.floreantpos.util;

import java.util.Date;

import org.hibernate.Session;

import com.floreantpos.Messages;
import com.floreantpos.StoreAlreadyCloseException;
import com.floreantpos.StoreAlreadyOpenException;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.SequenceNumber;
import com.floreantpos.model.Store;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.StoreSessionControl;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.SequenceNumberDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao.StoreSessionControlDAO;
import com.floreantpos.model.dao.StoreSessionDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.util.DataProvider;

public class StoreUtil {
	public static StoreSession getCurrentStoreSession() {
		return StoreSessionDAO.getInstance().getLastStoreSession();
	}

	public static boolean isStoreOpen() {
		StoreSession storeSession = getCurrentStoreSession();
		return storeSession != null && storeSession.isOpen();
	}

	public static void openStore(User openByUser) {
		Outlet outlet = DataProvider.get().getOutlet();
		openStore(openByUser, outlet == null ? null : outlet.getId());
	}

	public static void openStore(User openByUser, String outletId) {
		if (isStoreOpen()) {
			throw new StoreAlreadyOpenException(Messages.getString("StoreUtil.0")); //$NON-NLS-1$
		}

		StoreSession storeSession = new StoreSession();
		storeSession.setOpenedBy(openByUser);
		storeSession.setOpenTime(new Date());
		storeSession.setOutletId(outletId);

		SequenceNumber sequenceNumber = SequenceNumberDAO.getInstance().get(SequenceNumber.TICKET_TOKEN);
		if (sequenceNumber == null)
			sequenceNumber = new SequenceNumber(SequenceNumber.TICKET_TOKEN);

		Store store = DataProvider.get().getStore();
		boolean isResetToken = store.getBooleanProperty(Store.PROP_RESET_TOKEN, true);
		String startTokenNo = store.getProperty(Store.PROP_TOKEN_NO_START_FROM);
		Integer tokenNO = POSUtil.parseInteger(startTokenNo);
		if (isResetToken) {
			if (tokenNO > 0) {
				sequenceNumber.setNextSequenceNumber(tokenNO);
			}
			else {
				sequenceNumber.setNextSequenceNumber(1);
			}
		}
		StoreSessionDAO.getInstance().save(storeSession);
		DataProvider.get().setStoreSession(storeSession);

		StoreSessionControl storeOperation = getCurrentStoreOperation();
		if (storeOperation != null) {
			storeOperation.setCurrentData(storeSession);
		}
		TerminalDAO.getInstance().performBatchSave(sequenceNumber, storeOperation);
	}

	public static void closeStore(User closeByUser) throws Exception {
		StoreSession currentSession = getCurrentStoreSession();
		if (!currentSession.isOpen()) {
			throw new StoreAlreadyCloseException("Store is already closed.");
		}
		StoreDAO.getInstance().closeStore(currentSession, closeByUser);
		DataProvider.get().setStoreSession(null);
	}

	/**
	 * This is here only for backward compatibility. This will be removed in future.
	 * 
	 * @return
	 */
	@Deprecated
	private static StoreSessionControl getCurrentStoreOperation() {
		return StoreSessionControlDAO.getInstance().getCurrent();
	}

	public static void closeStore(Session session, User closeByUser) throws Exception {
		StoreSession currentSession = getCurrentStoreSession();
		if (!currentSession.isOpen()) {
			throw new StoreAlreadyCloseException("Store is already closed.");
		}
		StoreDAO.getInstance().closeStore(session, currentSession, closeByUser);
		DataProvider.get().setStoreSession(null);
	}
}
