package com.floreantpos.model.base;

import java.lang.Comparable;
import java.io.Serializable;


/**
 * This is an object that contains data related to the OUTLET table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="OUTLET"
 */

public abstract class BaseOutlet  implements Comparable, Serializable {

	public static String REF = "Outlet"; //$NON-NLS-1$
	public static String PROP_DESCRIPTION = "description"; //$NON-NLS-1$
	public static String PROP_TELEPHONE = "telephone"; //$NON-NLS-1$
	public static String PROP_SERVICE_CHARGE_PERCENTAGE = "serviceChargePercentage"; //$NON-NLS-1$
	public static String PROP_LATITUDE = "latitude"; //$NON-NLS-1$
	public static String PROP_ADMIN_EMAIL = "adminEmail"; //$NON-NLS-1$
	public static String PROP_CURRENCY_ID = "currencyId"; //$NON-NLS-1$
	public static String PROP_NAME = "name"; //$NON-NLS-1$
	public static String PROP_DEFAULT_GRATUITY_PERCENTAGE = "defaultGratuityPercentage"; //$NON-NLS-1$
	public static String PROP_LAST_UPDATE_TIME = "lastUpdateTime"; //$NON-NLS-1$
	public static String PROP_LAST_SYNC_TIME = "lastSyncTime"; //$NON-NLS-1$
	public static String PROP_EXTRA_PROPERTIES = "extraProperties"; //$NON-NLS-1$
	public static String PROP_STREET = "street"; //$NON-NLS-1$
	public static String PROP_DELETED = "deleted"; //$NON-NLS-1$
	public static String PROP_COUNTRY_CODE = "countryCode"; //$NON-NLS-1$
	public static String PROP_USE_DETAILED_RECONCILIATION = "useDetailedReconciliation"; //$NON-NLS-1$
	public static String PROP_ADDRESS_ID = "addressId"; //$NON-NLS-1$
	public static String PROP_STORE_NAME = "storeName"; //$NON-NLS-1$
	public static String PROP_TAX_GROUP_ID = "taxGroupId"; //$NON-NLS-1$
	public static String PROP_ZIP_CODE = "zipCode"; //$NON-NLS-1$
	public static String PROP_FLAT_NO = "flatNo"; //$NON-NLS-1$
	public static String PROP_HOUSE = "house"; //$NON-NLS-1$
	public static String PROP_CITY = "city"; //$NON-NLS-1$
	public static String PROP_LONGITUDE = "longitude"; //$NON-NLS-1$
	public static String PROP_ADDRESS_LINE3 = "addressLine3"; //$NON-NLS-1$
	public static String PROP_ADDRESS_LINE2 = "addressLine2"; //$NON-NLS-1$
	public static String PROP_ADDRESS_LINE1 = "addressLine1"; //$NON-NLS-1$
	public static String PROP_TYPE = "type"; //$NON-NLS-1$
	public static String PROP_ITEM_PRICE_INCLUDES_TAX = "itemPriceIncludesTax"; //$NON-NLS-1$
	public static String PROP_STATE = "state"; //$NON-NLS-1$
	public static String PROP_COUNTRY = "country"; //$NON-NLS-1$
	public static String PROP_ID = "id"; //$NON-NLS-1$
	public static String PROP_ENABLE_ONLINE_ORDERING = "enableOnlineOrdering"; //$NON-NLS-1$


	// constructors
	public BaseOutlet () {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BaseOutlet (java.lang.String id) {
		this.setId(id);
		initialize();
	}

	protected void initialize () {}



	private int hashCode = Integer.MIN_VALUE;

	// primary key
	private java.lang.String id;

	private long version;

	// fields
			private java.util.Date lastUpdateTime;
				private java.util.Date lastSyncTime;
				private java.lang.String name;
				private java.lang.String storeName;
				private java.lang.String description;
				private java.lang.Double serviceChargePercentage;
				private java.lang.Double defaultGratuityPercentage;
				private java.lang.String addressId;
				private java.lang.String addressLine1;
				private java.lang.String addressLine2;
				private java.lang.String addressLine3;
				private java.lang.String house;
				private java.lang.String flatNo;
				private java.lang.String type;
				private java.lang.String street;
				private java.lang.String city;
				private java.lang.String state;
				private java.lang.String zipCode;
				private java.lang.String country;
				private java.lang.String countryCode;
				private java.lang.Double latitude;
				private java.lang.Double longitude;
				private java.lang.String telephone;
				private java.lang.String adminEmail;
				private java.lang.String taxGroupId;
				private java.lang.String currencyId;
				private java.lang.String extraProperties;
				private java.lang.Boolean deleted;
				private java.lang.Boolean itemPriceIncludesTax;
				private java.lang.Boolean useDetailedReconciliation;
				private java.lang.Boolean enableOnlineOrdering;
	
	// collections
	private java.util.List<com.floreantpos.model.Department> departments;
	private java.util.Map<String, String> properties;



	/**
	 * Return the unique identifier of this class
     * @hibernate.id
     *  generator-class="com.floreantpos.util.UUIdGenerator"
     *  column="ID"
     */
	public java.lang.String getId () {
		return id;
	}

	/**
	 * Set the unique identifier of this class
	 * @param id the new ID
	 */
	public void setId (java.lang.String id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}



	/**
	 * Return the value associated with the column: VERSION_NO
	 */

	public long getVersion () {
			return version;
	}



	/**
	 * Set the value related to the column: VERSION_NO
	 * @param version the VERSION_NO value
	 */
			public void setVersion (long version) {
			this.version = version;
	}




	/**
	 * Return the value associated with the column: LAST_UPDATE_TIME
	 */

	public java.util.Date getLastUpdateTime () {
			return lastUpdateTime;
	}



	/**
	 * Set the value related to the column: LAST_UPDATE_TIME
	 * @param lastUpdateTime the LAST_UPDATE_TIME value
	 */
			public void setLastUpdateTime (java.util.Date lastUpdateTime) {
			this.lastUpdateTime = lastUpdateTime;
	}



	/**
	 * Return the value associated with the column: LAST_SYNC_TIME
	 */

	public java.util.Date getLastSyncTime () {
			return lastSyncTime;
	}



	/**
	 * Set the value related to the column: LAST_SYNC_TIME
	 * @param lastSyncTime the LAST_SYNC_TIME value
	 */
			public void setLastSyncTime (java.util.Date lastSyncTime) {
			this.lastSyncTime = lastSyncTime;
	}



	/**
	 * Return the value associated with the column: NAME
	 */

	public java.lang.String getName () {
			return name;
	}



	/**
	 * Set the value related to the column: NAME
	 * @param name the NAME value
	 */
			public void setName (java.lang.String name) {
			this.name = name;
	}



	/**
	 * Return the value associated with the column: STORE_NAME
	 */

	public java.lang.String getStoreName () {
			return storeName;
	}



	/**
	 * Set the value related to the column: STORE_NAME
	 * @param storeName the STORE_NAME value
	 */
			public void setStoreName (java.lang.String storeName) {
			this.storeName = storeName;
	}



	/**
	 * Return the value associated with the column: DESCRIPTION
	 */

	public java.lang.String getDescription () {
			return description;
	}



	/**
	 * Set the value related to the column: DESCRIPTION
	 * @param description the DESCRIPTION value
	 */
			public void setDescription (java.lang.String description) {
			this.description = description;
	}



	/**
	 * Return the value associated with the column: SC_PERCENTAGE
	 */

	public java.lang.Double getServiceChargePercentage () {
						return serviceChargePercentage == null ? Double.valueOf(0) : serviceChargePercentage;
		}



	/**
	 * Set the value related to the column: SC_PERCENTAGE
	 * @param serviceChargePercentage the SC_PERCENTAGE value
	 */
			public void setServiceChargePercentage (java.lang.Double serviceChargePercentage) {
			this.serviceChargePercentage = serviceChargePercentage;
	}



	/**
	 * Return the value associated with the column: GRATUITY_PERCENTAGE
	 */

	public java.lang.Double getDefaultGratuityPercentage () {
						return defaultGratuityPercentage == null ? Double.valueOf(0) : defaultGratuityPercentage;
		}



	/**
	 * Set the value related to the column: GRATUITY_PERCENTAGE
	 * @param defaultGratuityPercentage the GRATUITY_PERCENTAGE value
	 */
			public void setDefaultGratuityPercentage (java.lang.Double defaultGratuityPercentage) {
			this.defaultGratuityPercentage = defaultGratuityPercentage;
	}



	/**
	 * Return the value associated with the column: ADDRESS_ID
	 */

	public java.lang.String getAddressId () {
			return addressId;
	}



	/**
	 * Set the value related to the column: ADDRESS_ID
	 * @param addressId the ADDRESS_ID value
	 */
			public void setAddressId (java.lang.String addressId) {
			this.addressId = addressId;
	}



	/**
	 * Return the value associated with the column: ADDRESS_LINE_1
	 */

	public java.lang.String getAddressLine1 () {
			return addressLine1;
	}



	/**
	 * Set the value related to the column: ADDRESS_LINE_1
	 * @param addressLine1 the ADDRESS_LINE_1 value
	 */
			public void setAddressLine1 (java.lang.String addressLine1) {
			this.addressLine1 = addressLine1;
	}



	/**
	 * Return the value associated with the column: ADDRESS_LINE_2
	 */

	public java.lang.String getAddressLine2 () {
			return addressLine2;
	}



	/**
	 * Set the value related to the column: ADDRESS_LINE_2
	 * @param addressLine2 the ADDRESS_LINE_2 value
	 */
			public void setAddressLine2 (java.lang.String addressLine2) {
			this.addressLine2 = addressLine2;
	}



	/**
	 * Return the value associated with the column: ADDRESS_LINE_3
	 */

	public java.lang.String getAddressLine3 () {
			return addressLine3;
	}



	/**
	 * Set the value related to the column: ADDRESS_LINE_3
	 * @param addressLine3 the ADDRESS_LINE_3 value
	 */
			public void setAddressLine3 (java.lang.String addressLine3) {
			this.addressLine3 = addressLine3;
	}



	/**
	 * Return the value associated with the column: HOUSE
	 */

	public java.lang.String getHouse () {
			return house;
	}



	/**
	 * Set the value related to the column: HOUSE
	 * @param house the HOUSE value
	 */
			public void setHouse (java.lang.String house) {
			this.house = house;
	}



	/**
	 * Return the value associated with the column: FLAT_NO
	 */

	public java.lang.String getFlatNo () {
			return flatNo;
	}



	/**
	 * Set the value related to the column: FLAT_NO
	 * @param flatNo the FLAT_NO value
	 */
			public void setFlatNo (java.lang.String flatNo) {
			this.flatNo = flatNo;
	}



	/**
	 * Return the value associated with the column: TYPE
	 */

	public java.lang.String getType () {
			return type;
	}



	/**
	 * Set the value related to the column: TYPE
	 * @param type the TYPE value
	 */
			public void setType (java.lang.String type) {
			this.type = type;
	}



	/**
	 * Return the value associated with the column: STREET
	 */

	public java.lang.String getStreet () {
			return street;
	}



	/**
	 * Set the value related to the column: STREET
	 * @param street the STREET value
	 */
			public void setStreet (java.lang.String street) {
			this.street = street;
	}



	/**
	 * Return the value associated with the column: CITY
	 */

	public java.lang.String getCity () {
			return city;
	}



	/**
	 * Set the value related to the column: CITY
	 * @param city the CITY value
	 */
			public void setCity (java.lang.String city) {
			this.city = city;
	}



	/**
	 * Return the value associated with the column: STATE
	 */

	public java.lang.String getState () {
			return state;
	}



	/**
	 * Set the value related to the column: STATE
	 * @param state the STATE value
	 */
			public void setState (java.lang.String state) {
			this.state = state;
	}



	/**
	 * Return the value associated with the column: ZIPCODE
	 */

	public java.lang.String getZipCode () {
			return zipCode;
	}



	/**
	 * Set the value related to the column: ZIPCODE
	 * @param zipCode the ZIPCODE value
	 */
			public void setZipCode (java.lang.String zipCode) {
			this.zipCode = zipCode;
	}



	/**
	 * Return the value associated with the column: COUNTRY
	 */

	public java.lang.String getCountry () {
			return country;
	}



	/**
	 * Set the value related to the column: COUNTRY
	 * @param country the COUNTRY value
	 */
			public void setCountry (java.lang.String country) {
			this.country = country;
	}



	/**
	 * Return the value associated with the column: COUNTRY_CODE
	 */

	public java.lang.String getCountryCode () {
			return countryCode;
	}



	/**
	 * Set the value related to the column: COUNTRY_CODE
	 * @param countryCode the COUNTRY_CODE value
	 */
			public void setCountryCode (java.lang.String countryCode) {
			this.countryCode = countryCode;
	}



	/**
	 * Return the value associated with the column: LATITUDE
	 */

	public java.lang.Double getLatitude () {
						return latitude == null ? Double.valueOf(0) : latitude;
		}



	/**
	 * Set the value related to the column: LATITUDE
	 * @param latitude the LATITUDE value
	 */
			public void setLatitude (java.lang.Double latitude) {
			this.latitude = latitude;
	}



	/**
	 * Return the value associated with the column: LONGITUDE
	 */

	public java.lang.Double getLongitude () {
						return longitude == null ? Double.valueOf(0) : longitude;
		}



	/**
	 * Set the value related to the column: LONGITUDE
	 * @param longitude the LONGITUDE value
	 */
			public void setLongitude (java.lang.Double longitude) {
			this.longitude = longitude;
	}



	/**
	 * Return the value associated with the column: TELEPHONE
	 */

	public java.lang.String getTelephone () {
			return telephone;
	}



	/**
	 * Set the value related to the column: TELEPHONE
	 * @param telephone the TELEPHONE value
	 */
			public void setTelephone (java.lang.String telephone) {
			this.telephone = telephone;
	}



	/**
	 * Return the value associated with the column: ADMIN_MAIL
	 */

	public java.lang.String getAdminEmail () {
			return adminEmail;
	}



	/**
	 * Set the value related to the column: ADMIN_MAIL
	 * @param adminEmail the ADMIN_MAIL value
	 */
			public void setAdminEmail (java.lang.String adminEmail) {
			this.adminEmail = adminEmail;
	}



	/**
	 * Return the value associated with the column: TAX_GROUP_ID
	 */

	public java.lang.String getTaxGroupId () {
			return taxGroupId;
	}



	/**
	 * Set the value related to the column: TAX_GROUP_ID
	 * @param taxGroupId the TAX_GROUP_ID value
	 */
			public void setTaxGroupId (java.lang.String taxGroupId) {
			this.taxGroupId = taxGroupId;
	}



	/**
	 * Return the value associated with the column: CURRENCY
	 */

	public java.lang.String getCurrencyId () {
			return currencyId;
	}



	/**
	 * Set the value related to the column: CURRENCY
	 * @param currencyId the CURRENCY value
	 */
			public void setCurrencyId (java.lang.String currencyId) {
			this.currencyId = currencyId;
	}



	/**
	 * Return the value associated with the column: EXTRA_PROPERTIES
	 */

	public java.lang.String getExtraProperties () {
			return extraProperties;
	}



	/**
	 * Set the value related to the column: EXTRA_PROPERTIES
	 * @param extraProperties the EXTRA_PROPERTIES value
	 */
			public void setExtraProperties (java.lang.String extraProperties) {
			this.extraProperties = extraProperties;
	}



	/**
	 * Return the value associated with the column: DELETED
	 */

	public java.lang.Boolean isDeleted () {
						return deleted == null ? Boolean.valueOf(false) : deleted;
			}

	public java.lang.Boolean getDeleted () {
					return deleted == null ? Boolean.valueOf(false) : deleted;
			}


	/**
	 * Set the value related to the column: DELETED
	 * @param deleted the DELETED value
	 */
			public void setDeleted (java.lang.Boolean deleted) {
			this.deleted = deleted;
	}


	/**
	 * Custom property
	 */
	public static String getDeletedDefaultValue () {
		return "false";
	}


	/**
	 * Return the value associated with the column: PRICE_INCLUDES_TAX
	 */

	public java.lang.Boolean isItemPriceIncludesTax () {
					return itemPriceIncludesTax == null ? Boolean.FALSE : itemPriceIncludesTax;
		}

	public java.lang.Boolean getItemPriceIncludesTax () {
				return itemPriceIncludesTax == null ? Boolean.FALSE : itemPriceIncludesTax;
			}


	/**
	 * Set the value related to the column: PRICE_INCLUDES_TAX
	 * @param itemPriceIncludesTax the PRICE_INCLUDES_TAX value
	 */
			public void setItemPriceIncludesTax (java.lang.Boolean itemPriceIncludesTax) {
			this.itemPriceIncludesTax = itemPriceIncludesTax;
	}



	/**
	 * Return the value associated with the column: USE_DETAILED_RECONCILIATION
	 */

	public java.lang.Boolean isUseDetailedReconciliation () {
					return useDetailedReconciliation == null ? Boolean.FALSE : useDetailedReconciliation;
		}

	public java.lang.Boolean getUseDetailedReconciliation () {
				return useDetailedReconciliation == null ? Boolean.FALSE : useDetailedReconciliation;
			}


	/**
	 * Set the value related to the column: USE_DETAILED_RECONCILIATION
	 * @param useDetailedReconciliation the USE_DETAILED_RECONCILIATION value
	 */
			public void setUseDetailedReconciliation (java.lang.Boolean useDetailedReconciliation) {
			this.useDetailedReconciliation = useDetailedReconciliation;
	}



	/**
	 * Return the value associated with the column: ENABLE_ONLINE_ORDERING
	 */

	public java.lang.Boolean isEnableOnlineOrdering () {
					return enableOnlineOrdering == null ? Boolean.FALSE : enableOnlineOrdering;
		}

	public java.lang.Boolean getEnableOnlineOrdering () {
				return enableOnlineOrdering == null ? Boolean.FALSE : enableOnlineOrdering;
			}


	/**
	 * Set the value related to the column: ENABLE_ONLINE_ORDERING
	 * @param enableOnlineOrdering the ENABLE_ONLINE_ORDERING value
	 */
			public void setEnableOnlineOrdering (java.lang.Boolean enableOnlineOrdering) {
			this.enableOnlineOrdering = enableOnlineOrdering;
	}



	/**
	 * Return the value associated with the column: departments
	 */

	public java.util.List<com.floreantpos.model.Department> getDepartments () {
			return departments;
	}



	/**
	 * Set the value related to the column: departments
	 * @param departments the departments value
	 */
			public void setDepartments (java.util.List<com.floreantpos.model.Department> departments) {
			this.departments = departments;
	}

	public void addTodepartments (com.floreantpos.model.Department department) {
		if (null == getDepartments()) setDepartments(new java.util.ArrayList<com.floreantpos.model.Department>());
		getDepartments().add(department);
	}



	/**
	 * Return the value associated with the column: properties
	 */

	public java.util.Map<String, String> getProperties () {
			return properties;
	}



	/**
	 * Set the value related to the column: properties
	 * @param properties the properties value
	 */
			public void setProperties (java.util.Map<String, String> properties) {
			this.properties = properties;
	}





	public boolean equals (Object obj) {
		if (null == obj) return false;
		if (!(obj instanceof com.floreantpos.model.Outlet)) return false;
		else {
			com.floreantpos.model.Outlet outlet = (com.floreantpos.model.Outlet) obj;
			if (null == this.getId() || null == outlet.getId()) return this == obj;
			else return (this.getId().equals(outlet.getId()));
		}
	}

	public int hashCode () {
		if (Integer.MIN_VALUE == this.hashCode) {
			if (null == this.getId()) return super.hashCode();
			else {
				String hashStr = this.getClass().getName() + ":" + this.getId().hashCode();
				this.hashCode = hashStr.hashCode();
			}
		}
		return this.hashCode;
	}

	public int compareTo (Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString () {
		return super.toString();
	}


}