package com.floreantpos.model.base;

import java.lang.Comparable;
import java.io.Serializable;


/**
 * This is an object that contains data related to the PURCHASE_ORDER_ITEM table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="PURCHASE_ORDER_ITEM"
 */

public abstract class BasePurchaseOrderItem  implements Comparable, Serializable {

	public static String REF = "PurchaseOrderItem"; //$NON-NLS-1$
	public static String PROP_GROUP_NAME = "groupName"; //$NON-NLS-1$
	public static String PROP_STATUS = "status"; //$NON-NLS-1$
	public static String PROP_SUBTOTAL_AMOUNT = "subtotalAmount"; //$NON-NLS-1$
	public static String PROP_ITEM_UNIT_NAME = "itemUnitName"; //$NON-NLS-1$
	public static String PROP_TOTAL_AMOUNT = "totalAmount"; //$NON-NLS-1$
	public static String PROP_VENDOR = "vendor"; //$NON-NLS-1$
	public static String PROP_PROPERTIES = "properties"; //$NON-NLS-1$
	public static String PROP_DISCOUNT_AMOUNT = "discountAmount"; //$NON-NLS-1$
	public static String PROP_NAME = "name"; //$NON-NLS-1$
	public static String PROP_UNIT_PRICE = "unitPrice"; //$NON-NLS-1$
	public static String PROP_TAX_AMOUNT = "taxAmount"; //$NON-NLS-1$
	public static String PROP_ITEM_QUANTITY = "itemQuantity"; //$NON-NLS-1$
	public static String PROP_NOTE = "note"; //$NON-NLS-1$
	public static String PROP_MENU_ITEM_ID = "menuItemId"; //$NON-NLS-1$
	public static String PROP_TAX_RATE = "taxRate"; //$NON-NLS-1$
	public static String PROP_CATEGORY_NAME = "categoryName"; //$NON-NLS-1$
	public static String PROP_PURCHASE_ORDER = "purchaseOrder"; //$NON-NLS-1$
	public static String PROP_QUANTITY_RECEIVED = "quantityReceived"; //$NON-NLS-1$
	public static String PROP_ID = "id"; //$NON-NLS-1$
	public static String PROP_SKU = "sku"; //$NON-NLS-1$
	public static String PROP_BEVERAGE = "beverage"; //$NON-NLS-1$


	// constructors
	public BasePurchaseOrderItem () {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BasePurchaseOrderItem (java.lang.String id) {
		this.setId(id);
		initialize();
	}

	/**
	 * Constructor for required fields
	 */
	public BasePurchaseOrderItem (
		java.lang.String id,
		com.floreantpos.model.PurchaseOrder purchaseOrder) {

		this.setId(id);
		this.setPurchaseOrder(purchaseOrder);
		initialize();
	}

	protected void initialize () {}



	private int hashCode = Integer.MIN_VALUE;

	// primary key
	private java.lang.String id;

	 long version;

	// fields
			private java.lang.String sku;
				private java.lang.String menuItemId;
				private java.lang.Double itemQuantity;
				private java.lang.Double quantityReceived;
				private java.lang.String name;
				private java.lang.String itemUnitName;
				private java.lang.String groupName;
				private java.lang.String categoryName;
				private java.lang.Double unitPrice;
				private java.lang.Double taxRate;
				private java.lang.Double subtotalAmount;
				private java.lang.Double discountAmount;
				private java.lang.Double taxAmount;
				private java.lang.Double totalAmount;
				private java.lang.Boolean beverage;
				private java.lang.String status;
				private java.lang.String note;
				private java.lang.String properties;
	
	// many to one
	private com.floreantpos.model.InventoryVendor vendor;
	private com.floreantpos.model.PurchaseOrder purchaseOrder;

	// collections
	private java.util.Set<com.floreantpos.model.Customer> customers;



	/**
	 * Return the unique identifier of this class
     * @hibernate.id
     *  generator-class="com.floreantpos.util.UUIdGenerator"
     *  column="ID"
     */
	public java.lang.String getId () {
		return id;
	}

	/**
	 * Set the unique identifier of this class
	 * @param id the new ID
	 */
	public void setId (java.lang.String id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}



	/**
	 * Return the value associated with the column: VERSION_NO
	 */

	public long getVersion () {
			return version;
	}



	/**
	 * Set the value related to the column: VERSION_NO
	 * @param version the VERSION_NO value
	 */
			public void setVersion (long version) {
			this.version = version;
	}




	/**
	 * Return the value associated with the column: SKU
	 */

	public java.lang.String getSku () {
			return sku;
	}



	/**
	 * Set the value related to the column: SKU
	 * @param sku the SKU value
	 */
			public void setSku (java.lang.String sku) {
			this.sku = sku;
	}



	/**
	 * Return the value associated with the column: MENU_ITEM_ID
	 */

	public java.lang.String getMenuItemId () {
			return menuItemId;
	}



	/**
	 * Set the value related to the column: MENU_ITEM_ID
	 * @param menuItemId the MENU_ITEM_ID value
	 */
			public void setMenuItemId (java.lang.String menuItemId) {
			this.menuItemId = menuItemId;
	}



	/**
	 * Return the value associated with the column: ITEM_QUANTITY
	 */

	public java.lang.Double getItemQuantity () {
						return itemQuantity == null ? Double.valueOf(0) : itemQuantity;
		}



	/**
	 * Set the value related to the column: ITEM_QUANTITY
	 * @param itemQuantity the ITEM_QUANTITY value
	 */
			public void setItemQuantity (java.lang.Double itemQuantity) {
			this.itemQuantity = itemQuantity;
	}



	/**
	 * Return the value associated with the column: QUANTITY_RECEIVED
	 */

	public java.lang.Double getQuantityReceived () {
						return quantityReceived == null ? Double.valueOf(0) : quantityReceived;
			}



	/**
	 * Set the value related to the column: QUANTITY_RECEIVED
	 * @param quantityReceived the QUANTITY_RECEIVED value
	 */
			public void setQuantityReceived (java.lang.Double quantityReceived) {
			this.quantityReceived = quantityReceived;
	}


	/**
	 * Custom property
	 */
	public static String getQuantityReceivedDefaultValue () {
		return "-1";
	}


	/**
	 * Return the value associated with the column: ITEM_NAME
	 */

	public java.lang.String getName () {
			return name;
	}



	/**
	 * Set the value related to the column: ITEM_NAME
	 * @param name the ITEM_NAME value
	 */
			public void setName (java.lang.String name) {
			this.name = name;
	}



	/**
	 * Return the value associated with the column: ITEM_UNIT_NAME
	 */

	public java.lang.String getItemUnitName () {
			return itemUnitName;
	}



	/**
	 * Set the value related to the column: ITEM_UNIT_NAME
	 * @param itemUnitName the ITEM_UNIT_NAME value
	 */
			public void setItemUnitName (java.lang.String itemUnitName) {
			this.itemUnitName = itemUnitName;
	}



	/**
	 * Return the value associated with the column: GROUP_NAME
	 */

	public java.lang.String getGroupName () {
			return groupName;
	}



	/**
	 * Set the value related to the column: GROUP_NAME
	 * @param groupName the GROUP_NAME value
	 */
			public void setGroupName (java.lang.String groupName) {
			this.groupName = groupName;
	}



	/**
	 * Return the value associated with the column: CATEGORY_NAME
	 */

	public java.lang.String getCategoryName () {
			return categoryName;
	}



	/**
	 * Set the value related to the column: CATEGORY_NAME
	 * @param categoryName the CATEGORY_NAME value
	 */
			public void setCategoryName (java.lang.String categoryName) {
			this.categoryName = categoryName;
	}



	/**
	 * Return the value associated with the column: ITEM_PRICE
	 */

	public java.lang.Double getUnitPrice () {
						return unitPrice == null ? Double.valueOf(0) : unitPrice;
		}



	/**
	 * Set the value related to the column: ITEM_PRICE
	 * @param unitPrice the ITEM_PRICE value
	 */
			public void setUnitPrice (java.lang.Double unitPrice) {
			this.unitPrice = unitPrice;
	}



	/**
	 * Return the value associated with the column: ITEM_TAX_RATE
	 */

	public java.lang.Double getTaxRate () {
						return taxRate == null ? Double.valueOf(0) : taxRate;
		}



	/**
	 * Set the value related to the column: ITEM_TAX_RATE
	 * @param taxRate the ITEM_TAX_RATE value
	 */
			public void setTaxRate (java.lang.Double taxRate) {
			this.taxRate = taxRate;
	}



	/**
	 * Return the value associated with the column: SUB_TOTAL
	 */

	public java.lang.Double getSubtotalAmount () {
						return subtotalAmount == null ? Double.valueOf(0) : subtotalAmount;
		}



	/**
	 * Set the value related to the column: SUB_TOTAL
	 * @param subtotalAmount the SUB_TOTAL value
	 */
			public void setSubtotalAmount (java.lang.Double subtotalAmount) {
			this.subtotalAmount = subtotalAmount;
	}



	/**
	 * Return the value associated with the column: DISCOUNT
	 */

	public java.lang.Double getDiscountAmount () {
						return discountAmount == null ? Double.valueOf(0) : discountAmount;
		}



	/**
	 * Set the value related to the column: DISCOUNT
	 * @param discountAmount the DISCOUNT value
	 */
			public void setDiscountAmount (java.lang.Double discountAmount) {
			this.discountAmount = discountAmount;
	}



	/**
	 * Return the value associated with the column: TAX_AMOUNT
	 */

	public java.lang.Double getTaxAmount () {
						return taxAmount == null ? Double.valueOf(0) : taxAmount;
		}



	/**
	 * Set the value related to the column: TAX_AMOUNT
	 * @param taxAmount the TAX_AMOUNT value
	 */
			public void setTaxAmount (java.lang.Double taxAmount) {
			this.taxAmount = taxAmount;
	}



	/**
	 * Return the value associated with the column: TOTAL_PRICE
	 */

	public java.lang.Double getTotalAmount () {
						return totalAmount == null ? Double.valueOf(0) : totalAmount;
		}



	/**
	 * Set the value related to the column: TOTAL_PRICE
	 * @param totalAmount the TOTAL_PRICE value
	 */
			public void setTotalAmount (java.lang.Double totalAmount) {
			this.totalAmount = totalAmount;
	}



	/**
	 * Return the value associated with the column: BEVERAGE
	 */

	public java.lang.Boolean isBeverage () {
					return beverage == null ? Boolean.FALSE : beverage;
		}

	public java.lang.Boolean getBeverage () {
				return beverage == null ? Boolean.FALSE : beverage;
			}


	/**
	 * Set the value related to the column: BEVERAGE
	 * @param beverage the BEVERAGE value
	 */
			public void setBeverage (java.lang.Boolean beverage) {
			this.beverage = beverage;
	}



	/**
	 * Return the value associated with the column: STATUS
	 */

	public java.lang.String getStatus () {
			return status;
	}



	/**
	 * Set the value related to the column: STATUS
	 * @param status the STATUS value
	 */
			public void setStatus (java.lang.String status) {
			this.status = status;
	}



	/**
	 * Return the value associated with the column: NOTE
	 */

	public java.lang.String getNote () {
			return note;
	}



	/**
	 * Set the value related to the column: NOTE
	 * @param note the NOTE value
	 */
			public void setNote (java.lang.String note) {
			this.note = note;
	}



	/**
	 * Return the value associated with the column: PROPERTIES
	 */

	public java.lang.String getProperties () {
			return properties;
	}



	/**
	 * Set the value related to the column: PROPERTIES
	 * @param properties the PROPERTIES value
	 */
			public void setProperties (java.lang.String properties) {
			this.properties = properties;
	}



	/**
	 * Return the value associated with the column: VENDOR_ID
	 */

	public com.floreantpos.model.InventoryVendor getVendor () {
			return vendor;
	}



	/**
	 * Set the value related to the column: VENDOR_ID
	 * @param vendor the VENDOR_ID value
	 */
			public void setVendor (com.floreantpos.model.InventoryVendor vendor) {
			this.vendor = vendor;
	}



	/**
	 * Return the value associated with the column: PURCHASE_ORDER_ID
	 */

	public com.floreantpos.model.PurchaseOrder getPurchaseOrder () {
			return purchaseOrder;
	}



	/**
	 * Set the value related to the column: PURCHASE_ORDER_ID
	 * @param purchaseOrder the PURCHASE_ORDER_ID value
	 */
			public void setPurchaseOrder (com.floreantpos.model.PurchaseOrder purchaseOrder) {
			this.purchaseOrder = purchaseOrder;
	}



	/**
	 * Return the value associated with the column: customers
	 */

	public java.util.Set<com.floreantpos.model.Customer> getCustomers () {
			return customers;
	}



	/**
	 * Set the value related to the column: customers
	 * @param customers the customers value
	 */
			public void setCustomers (java.util.Set<com.floreantpos.model.Customer> customers) {
			this.customers = customers;
	}

	public void addTocustomers (com.floreantpos.model.Customer customer) {
		if (null == getCustomers()) setCustomers(new java.util.TreeSet<com.floreantpos.model.Customer>());
		getCustomers().add(customer);
	}





	public boolean equals (Object obj) {
		if (null == obj) return false;
		if (!(obj instanceof com.floreantpos.model.PurchaseOrderItem)) return false;
		else {
			com.floreantpos.model.PurchaseOrderItem purchaseOrderItem = (com.floreantpos.model.PurchaseOrderItem) obj;
			if (null == this.getId() || null == purchaseOrderItem.getId()) return this == obj;
			else return (this.getId().equals(purchaseOrderItem.getId()));
		}
	}

	public int hashCode () {
		if (Integer.MIN_VALUE == this.hashCode) {
			if (null == this.getId()) return super.hashCode();
			else {
				String hashStr = this.getClass().getName() + ":" + this.getId().hashCode();
				this.hashCode = hashStr.hashCode();
			}
		}
		return this.hashCode;
	}

	public int compareTo (Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString () {
		return super.toString();
	}


}