package com.floreantpos.model.dao;

import java.util.ArrayList;
import java.util.Date;

import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

import com.floreantpos.PosLog;
import com.floreantpos.model.AccessLog;
import com.floreantpos.model.Customer;
import com.floreantpos.model.Pagination;
import com.floreantpos.util.NumericGlobalIdGenerator;

public class AccessLogDAO extends BaseAccessLogDAO {

	/**
	 * Default constructor.  Can be used in place of getInstance()
	 */
	public AccessLogDAO() {
	}

	public void create(String ipAddress) {
		create(null, null, null, null, null, null, null, ipAddress);
	}

	public void create(Customer currentCustomer, String clientIpAddress) {
		create(currentCustomer, clientIpAddress, null, null);
	}

	public void create(Customer currentCustomer, String ipAddress, String orderId, String action) {
		if (currentCustomer == null) {
			create(null, null, null, null, null, orderId, null, ipAddress, null);
			return;
		}
		create(currentCustomer.getId(), currentCustomer.getName(), currentCustomer.getEmail(), currentCustomer.getAddress(), currentCustomer.getCountry(),
				orderId, null, ipAddress, action);
	}

	public void create(String customerId, String name, String email, String address, String country, String orderId, String cvcCheck, String ipAddress) {
		create(customerId, name, email, address, country, orderId, cvcCheck, ipAddress, null);
	}

	public void create(String customerId, String name, String email, String address, String country, String orderId, String cvcCheck, String ipAddress,
			String action) {
		try {
			AccessLog accessLog = new AccessLog();
			accessLog.setId(NumericGlobalIdGenerator.generateGlobalId());
			accessLog.setAccessLogDate(new Date());
			accessLog.setCountry(country);
			accessLog.setCustomerEmail(email);
			accessLog.setIpAddress(ipAddress);
			accessLog.setOrderId(orderId);
			if (customerId != null) {
				accessLog.addProperty("customerId", customerId); //$NON-NLS-1$
			}
			if (name != null) {
				accessLog.addProperty("customerName", name); //$NON-NLS-1$
			}
			if (address != null) {
				accessLog.addProperty("customerAddress", address); //$NON-NLS-1$
			}
			if (cvcCheck != null) {
				accessLog.addProperty("cvcCheck", cvcCheck); //$NON-NLS-1$
			}
			if (action != null) {
				accessLog.setAction(action);
			}
			save(accessLog);
		} catch (Exception e) {
			PosLog.error(getReferenceClass(), "Failed to save access log: Customer ID: " + customerId + " IP Address:" + ipAddress + " Name: " + name //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
					+ " Address: " + address + " Country: " + country + " CVC Check: " + cvcCheck + " Order Id: " + orderId); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
		}
	}

	@SuppressWarnings("unchecked")
	public void loadData(String searchKeyword, Pagination<AccessLog> pagination) {
		try (Session session = this.createNewSession()) {
			Criteria criteria = session.createCriteria(getReferenceClass());
			criteria.setProjection(Projections.rowCount());
			if (StringUtils.isNotBlank(searchKeyword)) {
				Disjunction disjunction = Restrictions.disjunction();
				disjunction.add(Restrictions.eq(AccessLog.PROP_CUSTOMER_EMAIL, searchKeyword));
				disjunction.add(Restrictions.eq(AccessLog.PROP_ORDER_ID, searchKeyword));
				criteria.add(disjunction);
			}
			Number uniqueResult = (Number) criteria.uniqueResult();
			int rowCount = uniqueResult == null ? 0 : uniqueResult.intValue();
			pagination.setNumRows(rowCount);
			if (rowCount == 0) {
				pagination.setData(new ArrayList<>());
				return;
			}
			criteria.setProjection(null);
			criteria.setFirstResult(pagination.getCurrentRowIndex());
			criteria.setMaxResults(pagination.getPageSize());
			criteria.addOrder(Order.desc(AccessLog.PROP_ACCESS_LOG_DATE));
			pagination.setData(criteria.list());
		}
	}

}