package com.floreantpos.model.dao;

import java.util.Iterator;
import java.util.List;

import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Restrictions;

import com.floreantpos.model.DayPart;
import com.floreantpos.model.PriceShift;
import com.floreantpos.model.Shift;

public class DayPartDAO extends BaseDayPartDAO {

	/**
	 * Default constructor.  Can be used in place of getInstance()
	 */
	public DayPartDAO() {
	}

	@Override
	public List<DayPart> findAll() {
		try (Session session = createNewSession()) {
			Criteria criteria = session.createCriteria(getReferenceClass());
			addDeletedFilter(criteria);
			return criteria.list();
		}
	}

	/*
	 * convertShiftToDayPart() method is used for updating old version database
	 * shift to new version daypart shift.
	 * 
	 */
	public List<Shift> convertShiftToDayPart() {
		Transaction tx = null;

		try (Session session = createNewSession()) {
			List<Shift> existingShift = ShiftDAO.getInstance().findAll();
			if (existingShift.isEmpty()) {
				return existingShift;
			}
			String whereClause = "";
			for (Iterator iterator = existingShift.iterator(); iterator.hasNext();) {
				Shift shift = (Shift) iterator.next();
				if (shift instanceof PriceShift) {
					iterator.remove();
				}
				else {
					whereClause += "ID = '" + shift.getId() + "'";
					if (iterator.hasNext()) {
						whereClause += " or ";
					}
				}
			}

			tx = session.beginTransaction();
			String queryString = "update SHIFT set TYPE='%s' where %s";
			queryString = String.format(queryString, "2", whereClause);
			Query query = session.createSQLQuery(queryString);
			query.executeUpdate();
			tx.commit();
			return existingShift;
		} catch (Exception e) {
			try {
				tx.rollback();
			} catch (Exception x) {
			}
			throw e;
		}
	}

	public DayPart findByName(String name) {
		try (Session session = createNewSession()) {
			Criteria criteria = session.createCriteria(getReferenceClass());
			criteria.add(Restrictions.eq(Shift.PROP_NAME, name));
			List list = criteria.list();
			if (list.size() > 0) {
				return (DayPart) list.get(0);
			}
			return null;
		}
	}
}