package com.floreantpos.model.util;

public enum InventoryUnitConversionRule {
	DIVISION("division", "Divide"),  //$NON-NLS-1$ //$NON-NLS-2$
	MULTIPLICATION("multiplication", "Multiply") //$NON-NLS-1$ //$NON-NLS-2$
	;

	private String name;
	private String displayString;

	private InventoryUnitConversionRule(String name, String displayString) {
		this.name = name;
		this.displayString = displayString;
	}

	public String getName() {
		return this.name;
	}
	
	public String getDisplayString() {
		return displayString;
	}
	
	@Override
	public String toString() {
		return getDisplayString();
	}

	public static InventoryUnitConversionRule fromName(String name) {
		InventoryUnitConversionRule[] rules = values();
		for (InventoryUnitConversionRule rule : rules) {
			if (rule.name.equals(name)) {
				return rule;
			}
		}
		return InventoryUnitConversionRule.DIVISION;
	}
}
