package com.floreantpos.model;

import org.apache.commons.lang.StringUtils;

import com.floreantpos.model.base.BaseRegistrationReferrer;
import com.floreantpos.model.dao.CustomerDAO;

public class RegistrationReferrer extends BaseRegistrationReferrer implements TimedModel {
	private static final long serialVersionUID = 1L;

	private boolean updateLastUpdateTime = true;
	private boolean updateSyncTime = false;
	private transient Customer referrer;
	private transient Customer customer;

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public RegistrationReferrer() {
	}

	/**
	 * Constructor for primary key
	 */
	public RegistrationReferrer(java.lang.String id) {
		super(id);
	}

	/*[CONSTRUCTOR MARKER END]*/

	public boolean isUpdateSyncTime() {
		return updateSyncTime;
	}

	public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
		this.updateSyncTime = shouldUpdateSyncTime;
	}

	public boolean isUpdateLastUpdateTime() {
		return updateLastUpdateTime;
	}

	public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
		this.updateLastUpdateTime = shouldUpdateUpdateTime;
	}

	public void setReferrer(Customer referrer) {
		this.referrer = referrer;
	}

	public Customer getReferrer() {
		if (referrer == null && StringUtils.isNotBlank(super.getReferrerId())) {
			referrer = CustomerDAO.getInstance().get(super.getReferrerId());
		}
		return referrer;
	}

	public void setCustomer(Customer customer) {
		this.customer = customer;
	}

	public Customer getCustomer() {
		if (customer == null && StringUtils.isNotBlank(super.getCustomerId())) {
			customer = CustomerDAO.getInstance().get(super.getCustomerId());
		}
		return customer;
	}

	public String getCustomerEmail() {
		Customer customer = getCustomer();
		return customer == null ? "" : customer.getEmail(); //$NON-NLS-1$
	}

	public String getReferrerEmail() {
		Customer referrer = getReferrer();
		return referrer == null ? "" : referrer.getEmail(); //$NON-NLS-1$
	}

}