package com.floreantpos.model.base;

import java.lang.Comparable;
import java.io.Serializable;


/**
 * This is an object that contains data related to the CAMPAIGN table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="CAMPAIGN"
 */

public abstract class BaseCampaign  implements Comparable, Serializable {

	public static String REF = "Campaign"; //$NON-NLS-1$
	public static String PROP_START_DATE = "startDate"; //$NON-NLS-1$
	public static String PROP_EXPIRY_DATE = "expiryDate"; //$NON-NLS-1$
	public static String PROP_LAST_UPDATE_TIME = "lastUpdateTime"; //$NON-NLS-1$
	public static String PROP_CAMPAIGN_ID = "campaignId"; //$NON-NLS-1$
	public static String PROP_LAST_SYNC_TIME = "lastSyncTime"; //$NON-NLS-1$
	public static String PROP_SORT_ORDER = "sortOrder"; //$NON-NLS-1$
	public static String PROP_ID = "id"; //$NON-NLS-1$
	public static String PROP_TICKET_JSON = "ticketJson"; //$NON-NLS-1$
	public static String PROP_PROPERTIES = "properties"; //$NON-NLS-1$


	// constructors
	public BaseCampaign () {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BaseCampaign (java.lang.String id) {
		this.setId(id);
		initialize();
	}

	protected void initialize () {}



	private int hashCode = Integer.MIN_VALUE;

	// primary key
	private java.lang.String id;

	 long version;

	// fields
			private java.util.Date lastUpdateTime;
				private java.util.Date lastSyncTime;
				private java.lang.String campaignId;
				private java.util.Date startDate;
				private java.util.Date expiryDate;
				private java.lang.Integer sortOrder;
				private java.lang.String ticketJson;
				private java.lang.String properties;
	

	/**
	 * Return the unique identifier of this class
     * @hibernate.id
     *  generator-class="com.floreantpos.util.UUIdGenerator"
     *  column="ID"
     */
	public java.lang.String getId () {
		return id;
	}

	/**
	 * Set the unique identifier of this class
	 * @param id the new ID
	 */
	public void setId (java.lang.String id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}



	/**
	 * Return the value associated with the column: VERSION_NO
	 */

	public long getVersion () {
			return version;
	}



	/**
	 * Set the value related to the column: VERSION_NO
	 * @param version the VERSION_NO value
	 */
			public void setVersion (long version) {
			this.version = version;
	}




	/**
	 * Return the value associated with the column: LAST_UPDATE_TIME
	 */

	public java.util.Date getLastUpdateTime () {
			return lastUpdateTime;
	}



	/**
	 * Set the value related to the column: LAST_UPDATE_TIME
	 * @param lastUpdateTime the LAST_UPDATE_TIME value
	 */
			public void setLastUpdateTime (java.util.Date lastUpdateTime) {
			this.lastUpdateTime = lastUpdateTime;
	}



	/**
	 * Return the value associated with the column: LAST_SYNC_TIME
	 */

	public java.util.Date getLastSyncTime () {
			return lastSyncTime;
	}



	/**
	 * Set the value related to the column: LAST_SYNC_TIME
	 * @param lastSyncTime the LAST_SYNC_TIME value
	 */
			public void setLastSyncTime (java.util.Date lastSyncTime) {
			this.lastSyncTime = lastSyncTime;
	}



	/**
	 * Return the value associated with the column: CAMPAIGN_ID
	 */

	public java.lang.String getCampaignId () {
			return campaignId;
	}



	/**
	 * Set the value related to the column: CAMPAIGN_ID
	 * @param campaignId the CAMPAIGN_ID value
	 */
			public void setCampaignId (java.lang.String campaignId) {
			this.campaignId = campaignId;
	}
	/**
	 * Return the value associated with the column: START_DATE
	 */

	public java.util.Date getStartDate () {
			return startDate;
	}



	/**
	 * Set the value related to the column: START_DATE
	 * @param startDate the START_DATE value
	 */
			public void setStartDate (java.util.Date startDate) {
			this.startDate = startDate;
	}

	/**
	 * Return the value associated with the column: EXPIRY_DATE
	 */

	public java.util.Date getExpiryDate () {
			return expiryDate;
	}



	/**
	 * Set the value related to the column: EXPIRY_DATE
	 * @param expiryDate the EXPIRY_DATE value
	 */
			public void setExpiryDate (java.util.Date expiryDate) {
			this.expiryDate = expiryDate;
	}


	/**
	 * Return the value associated with the column: SORT_ORDER
	 */

	public java.lang.Integer getSortOrder () {
						return sortOrder == null ? Integer.valueOf(0) : sortOrder;
		}



	/**
	 * Set the value related to the column: SORT_ORDER
	 * @param sortOrder the SORT_ORDER value
	 */
			public void setSortOrder (java.lang.Integer sortOrder) {
			this.sortOrder = sortOrder;
	}

	/**
	 * Return the value associated with the column: TICKET_JSON
	 */

	public java.lang.String getTicketJson () {
			return ticketJson;
	}



	/**
	 * Set the value related to the column: TICKET_JSON
	 * @param ticketJson the TICKET_JSON value
	 */
			public void setTicketJson (java.lang.String ticketJson) {
			this.ticketJson = ticketJson;
	}

	/**
	 * Return the value associated with the column: PROPERTIES
	 */

	public java.lang.String getProperties () {
			return properties;
	}



	/**
	 * Set the value related to the column: PROPERTIES
	 * @param properties the PROPERTIES value
	 */
			public void setProperties (java.lang.String properties) {
			this.properties = properties;
	}



	public boolean equals (Object obj) {
		if (null == obj) return false;
		if (!(obj instanceof com.floreantpos.model.Campaign)) return false;
		else {
			com.floreantpos.model.Campaign campaign = (com.floreantpos.model.Campaign) obj;
			if (null == this.getId() || null == campaign.getId()) return this == obj;
			else return (this.getId().equals(campaign.getId()));
		}
	}

	public int hashCode () {
		if (Integer.MIN_VALUE == this.hashCode) {
			if (null == this.getId()) return super.hashCode();
			else {
				String hashStr = this.getClass().getName() + ":" + this.getId().hashCode();
				this.hashCode = hashStr.hashCode();
			}
		}
		return this.hashCode;
	}

	public int compareTo (Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString () {
		return super.toString();
	}


}