package com.floreantpos.model.base;

import java.lang.Comparable;
import java.io.Serializable;


/**
 * This is an object that contains data related to the INVENTORY_STOCK table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="INVENTORY_STOCK"
 */

public abstract class BaseInventoryStock  implements Comparable, Serializable {

	public static String REF = "InventoryStock"; //$NON-NLS-1$
	public static String PROP_LOCATION_ID = "locationId"; //$NON-NLS-1$
	public static String PROP_BARCODE = "barcode"; //$NON-NLS-1$
	public static String PROP_QUANTITY_IN_HAND = "quantityInHand"; //$NON-NLS-1$
	public static String PROP_OUTLET_ID = "outletId"; //$NON-NLS-1$
	public static String PROP_ITEM_NAME = "itemName"; //$NON-NLS-1$
	public static String PROP_ID = "id"; //$NON-NLS-1$
	public static String PROP_LAST_SYNC_TIME = "lastSyncTime"; //$NON-NLS-1$
	public static String PROP_LAST_UPDATE_TIME = "lastUpdateTime"; //$NON-NLS-1$
	public static String PROP_UNIT = "unit"; //$NON-NLS-1$
	public static String PROP_SKU = "sku"; //$NON-NLS-1$
	public static String PROP_PROPERTIES = "properties"; //$NON-NLS-1$
	public static String PROP_MENU_ITEM_ID = "menuItemId"; //$NON-NLS-1$


	// constructors
	public BaseInventoryStock () {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BaseInventoryStock (java.lang.String id) {
		this.setId(id);
		initialize();
	}

	protected void initialize () {}



	private int hashCode = Integer.MIN_VALUE;

	// primary key
	private java.lang.String id;

	private long version;

	// fields
			private java.util.Date lastUpdateTime;
				private java.util.Date lastSyncTime;
				private java.lang.Double quantityInHand;
				private java.lang.String menuItemId;
				private java.lang.String itemName;
				private java.lang.String sku;
				private java.lang.String barcode;
				private java.lang.String unit;
				private java.lang.String locationId;
				private java.lang.String outletId;
				private java.lang.String properties;
	


	/**
	 * Return the unique identifier of this class
     * @hibernate.id
     *  generator-class="com.floreantpos.util.GlobalIdGenerator"
     *  column="ID"
     */
	public java.lang.String getId () {
		return id;
	}

	/**
	 * Set the unique identifier of this class
	 * @param id the new ID
	 */
	public void setId (java.lang.String id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}



	/**
	 * Return the value associated with the column: VERSION_NO
	 */
				public long getVersion () {
						return version;
			}

	/**
	 * Set the value related to the column: VERSION_NO
	 * @param version the VERSION_NO value
	 */
			public void setVersion (long version) {
			this.version = version;
	}




	/**
	 * Return the value associated with the column: LAST_UPDATE_TIME
	 */
				public java.util.Date getLastUpdateTime () {
						return lastUpdateTime;
			}

	/**
	 * Set the value related to the column: LAST_UPDATE_TIME
	 * @param lastUpdateTime the LAST_UPDATE_TIME value
	 */
			public void setLastUpdateTime (java.util.Date lastUpdateTime) {
			this.lastUpdateTime = lastUpdateTime;
	}



	/**
	 * Return the value associated with the column: LAST_SYNC_TIME
	 */
				public java.util.Date getLastSyncTime () {
						return lastSyncTime;
			}

	/**
	 * Set the value related to the column: LAST_SYNC_TIME
	 * @param lastSyncTime the LAST_SYNC_TIME value
	 */
			public void setLastSyncTime (java.util.Date lastSyncTime) {
			this.lastSyncTime = lastSyncTime;
	}



	/**
	 * Return the value associated with the column: QUANTITY_IN_HAND
	 */
				public java.lang.Double getQuantityInHand () {
										return quantityInHand == null ? Double.valueOf(0) : quantityInHand;
					}

	/**
	 * Set the value related to the column: QUANTITY_IN_HAND
	 * @param quantityInHand the QUANTITY_IN_HAND value
	 */
			public void setQuantityInHand (java.lang.Double quantityInHand) {
			this.quantityInHand = quantityInHand;
	}



	/**
	 * Return the value associated with the column: MENU_ITEM_ID
	 */
				public java.lang.String getMenuItemId () {
						return menuItemId;
			}

	/**
	 * Set the value related to the column: MENU_ITEM_ID
	 * @param menuItemId the MENU_ITEM_ID value
	 */
			public void setMenuItemId (java.lang.String menuItemId) {
			this.menuItemId = menuItemId;
	}



	/**
	 * Return the value associated with the column: ITEM_NAME
	 */
				public java.lang.String getItemName () {
						return itemName;
			}

	/**
	 * Set the value related to the column: ITEM_NAME
	 * @param itemName the ITEM_NAME value
	 */
			public void setItemName (java.lang.String itemName) {
			this.itemName = itemName;
	}



	/**
	 * Return the value associated with the column: SKU
	 */
				public java.lang.String getSku () {
						return sku;
			}

	/**
	 * Set the value related to the column: SKU
	 * @param sku the SKU value
	 */
			public void setSku (java.lang.String sku) {
			this.sku = sku;
	}



	/**
	 * Return the value associated with the column: BARCODE
	 */
				public java.lang.String getBarcode () {
						return barcode;
			}

	/**
	 * Set the value related to the column: BARCODE
	 * @param barcode the BARCODE value
	 */
			public void setBarcode (java.lang.String barcode) {
			this.barcode = barcode;
	}



	/**
	 * Return the value associated with the column: UNIT
	 */
				public java.lang.String getUnit () {
						return unit;
			}

	/**
	 * Set the value related to the column: UNIT
	 * @param unit the UNIT value
	 */
			public void setUnit (java.lang.String unit) {
			this.unit = unit;
	}



	/**
	 * Return the value associated with the column: LOCATION_ID
	 */
				public java.lang.String getLocationId () {
						return locationId;
			}

	/**
	 * Set the value related to the column: LOCATION_ID
	 * @param locationId the LOCATION_ID value
	 */
			public void setLocationId (java.lang.String locationId) {
			this.locationId = locationId;
	}



	/**
	 * Return the value associated with the column: OUTLET_ID
	 */
				public java.lang.String getOutletId () {
						return outletId;
			}

	/**
	 * Set the value related to the column: OUTLET_ID
	 * @param outletId the OUTLET_ID value
	 */
			public void setOutletId (java.lang.String outletId) {
			this.outletId = outletId;
	}



	/**
	 * Return the value associated with the column: PROPERTIES
	 */
				public java.lang.String getProperties () {
						return properties;
			}

	/**
	 * Set the value related to the column: PROPERTIES
	 * @param properties the PROPERTIES value
	 */
			public void setProperties (java.lang.String properties) {
			this.properties = properties;
	}





	public boolean equals (Object obj) {
		if (null == obj) return false;
		if (!(obj instanceof com.floreantpos.model.InventoryStock)) return false;
		else {
			com.floreantpos.model.InventoryStock inventoryStock = (com.floreantpos.model.InventoryStock) obj;
			if (null == this.getId() || null == inventoryStock.getId()) return this == obj;
			else return (this.getId().equals(inventoryStock.getId()));
		}
	}

	public int hashCode () {
		if (Integer.MIN_VALUE == this.hashCode) {
			if (null == this.getId()) return super.hashCode();
			else {
				String hashStr = this.getClass().getName() + ":" + this.getId().hashCode();
				this.hashCode = hashStr.hashCode();
			}
		}
		return this.hashCode;
	}

	public int compareTo (Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString () {
		return super.toString();
	}


}