/**
 * ************************************************************************
 * * The contents of this file are subject to the MRPL 1.2
 * * (the  "License"),  being   the  Mozilla   Public  License
 * * Version 1.1  with a permitted attribution clause; you may not  use this
 * * file except in compliance with the License. You  may  obtain  a copy of
 * * the License at http://www.floreantpos.org/license.html
 * * Software distributed under the License  is  distributed  on  an "AS IS"
 * * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * * License for the specific  language  governing  rights  and  limitations
 * * under the License.
 * * The Original Code is FLOREANT POS.
 * * The Initial Developer of the Original Code is OROCUBE LLC
 * * All portions are Copyright (C) 2015 OROCUBE LLC
 * * All Rights Reserved.
 * ************************************************************************
 */
package com.floreantpos.model;

import java.beans.Transient;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

import org.apache.commons.lang.StringUtils;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.base.BaseAttendenceHistory;
import com.floreantpos.model.util.DataProvider;
import com.google.gson.Gson;
import com.google.gson.JsonObject;

@JsonIgnoreProperties(ignoreUnknown = true, value = { "terminal" })
@XmlAccessorType(XmlAccessType.FIELD)
@XmlRootElement
public class AttendenceHistory extends BaseAttendenceHistory implements TimedModel, PropertyContainer {
	private static final long serialVersionUID = 1L;
	private transient JsonObject propertiesContainer;

	private boolean updateLastUpdateTime = true;
	private boolean updateSyncTime = false;

	public boolean isUpdateSyncTime() {
		return updateSyncTime;
	}

	public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
		this.updateSyncTime = shouldUpdateSyncTime;
	}

	public boolean isUpdateLastUpdateTime() {
		return updateLastUpdateTime;
	}

	public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
		this.updateLastUpdateTime = shouldUpdateUpdateTime;
	}

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public AttendenceHistory() {
	}

	/**
	 * Constructor for primary key
	 */
	public AttendenceHistory(java.lang.String id) {
		super(id);
	}

	/*[CONSTRUCTOR MARKER END]*/

	//	public Boolean isClockedOut() {
	//		if (super.isClockedOut() == null) {
	//			return Boolean.FALSE;
	//		}
	//		return super.isClockedOut();
	//	}

	public User getUser() {
		if (StringUtils.isEmpty(super.getUserId()))
			return null;
		return DataProvider.get().getUserById(super.getUserId(), getOutletId());
	}

	public void setUser(User user) {
		super.setUserId(user == null ? null : user.getId());
	}

	public Shift getShift() {
		if (StringUtils.isEmpty(super.getShiftId()))
			return null;
		return DataProvider.get().getShiftById(super.getShiftId(), getOutletId());
	}

	public void setShift(Shift shift) {
		super.setShiftId(shift == null ? null : shift.getId());
	}

	@Transient
	public Terminal getTerminal() {
		if (super.getTerminalId() == null)
			return null;
		return DataProvider.get().getTerminalById(super.getTerminalId(), getOutletId());
	}

	public void setTerminal(Terminal terminal) {
		super.setTerminalId(terminal == null ? null : terminal.getId());
	}

	@Override
	public String getProperties() {
		if (propertiesContainer != null) {
			return propertiesContainer.toString();
		}

		String properties = super.getProperties();
		if (StringUtils.isEmpty(properties)) {
			return null;
		}

		propertiesContainer = new Gson().fromJson(properties, JsonObject.class);
		return properties;
	}

	@Override
	public void setProperties(String properties) {
		super.setProperties(properties);
		propertiesContainer = new Gson().fromJson(properties, JsonObject.class);
	}

	@Override
	public JsonObject getPropertyStore() {
		if (propertiesContainer == null) {
			propertiesContainer = new JsonObject();
		}
		return propertiesContainer;
	}

}