package com.floreantpos.model;

import javax.xml.bind.annotation.XmlRootElement;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.base.BaseInventoryStockUnit;

@JsonIgnoreProperties(ignoreUnknown = true, value = { "uniqueCode" })
@XmlRootElement
public class InventoryStockUnit extends BaseInventoryStockUnit implements IUnit, TimedModel {
	private static final long serialVersionUID = 1L;

	private boolean updateLastUpdateTime = true;
	private boolean updateSyncTime = false;

	public boolean isUpdateSyncTime() {
		return updateSyncTime;
	}

	public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
		this.updateSyncTime = shouldUpdateSyncTime;
	}

	public boolean isUpdateLastUpdateTime() {
		return updateLastUpdateTime;
	}

	public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
		this.updateLastUpdateTime = shouldUpdateUpdateTime;
	}

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public InventoryStockUnit() {
	}

	/**
	 * Constructor for primary key
	 */
	public InventoryStockUnit(java.lang.String id) {
		super(id);
	}

	/*[CONSTRUCTOR MARKER END]*/

	public void calculateBaseUnitValue() {
		double conversionValue = getConversionValue();
		double unitFactor = getUnit().getConversionRate();
		setBaseUnitValue(conversionValue / unitFactor);
	}

	@Override
	public String getUniqueCode() {
		return super.getPackagingUnit().getCode();
	}

	@Override
	public String toString() {
		return super.getPackagingUnit().getName();
	}

	@Override
	public String getName() {
		return super.getPackagingUnit().getName();
	}

	@Override
	public Double getConversionRate() {
		return getBaseUnitValue();
	}

	@Override
	public String getDisplayName() {
		return getUniqueCode();
	}
}