package com.floreantpos.model.ext;

public enum KitchenStickerPaperSize {
	FiftyOneMM("2x3 inch = 50.8x76.2 mm", "51mm"), FiftyTwoMM("2.04x1.57 inch = 51.86x30.69 mm", "52mm"), FiftyFourMM("2.125x2.75 inch = 54x70 mm", //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$
			"54mm"), FiftyFiveMM("2.15x3.14 inch = 55x80 mm", "55mm"), Test("Test", "Test"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$//$NON-NLS-4$

	private String displayString;
	private String size;

	private KitchenStickerPaperSize(String displayString, String size) {
		this.displayString = displayString;
		this.size = size;
	}

	public String getReportNameAccording2Size(String reportName) {
		return reportName + "-" + size; //$NON-NLS-1$
	}

	public static KitchenStickerPaperSize fromName(String name) {
		try {
			return valueOf(name);
		} catch (Exception e) {
			return KitchenStickerPaperSize.FiftyOneMM;
		}
	}

	public String getSize() {
		return size;
	}

	@Override
	public String toString() {
		return displayString;
	}
}
