package com.floreantpos.util;

import org.json.JSONObject;

public class OrgJsonUtil {
	public static String getString(JSONObject jsonObject, String key) {
		if (!jsonObject.has(key)) {
			return null;
		}

		return jsonObject.getString(key);
	}

	public static Boolean getBoolean(JSONObject jsonObject, String key) {
		if (!jsonObject.has(key)) {
			return false;
		}

		return jsonObject.getBoolean(key);
	}

	public static Boolean getBoolean(JSONObject jsonObject, String key, boolean defaultValue) {
		if (!jsonObject.has(key)) {
			return defaultValue;
		}

		return jsonObject.getBoolean(key);
	}

	public static Integer getInt(JSONObject jsonObject, String key) {
		if (!jsonObject.has(key)) {
			return 0;
		}

		return jsonObject.getInt(key);
	}

	public static Double getDouble(JSONObject jsonObject, String key) {
		if (!jsonObject.has(key)) {
			return 0.0;
		}

		return jsonObject.getDouble(key);
	}
}
