package com.floreantpos.model;

import java.util.Iterator;

import com.floreantpos.model.base.BaseCampaign;

public class Campaign extends BaseCampaign {
	private static final long serialVersionUID = 1L;

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public Campaign() {
	}

	/**
	 * Constructor for primary key
	 */
	public Campaign(java.lang.String id) {
		super(id);
	}

	/*[CONSTRUCTOR MARKER END]*/

	private MenuItem item;
	private Ticket ticket;

	public void setItem(MenuItem item) {
		this.item = item;
	}

	public Ticket getTicket() {
		return ticket;
	}

	public void setTicket(Ticket ticket) {
		this.ticket = ticket;
	}

	public String getProductsName() {
		if (ticket == null) {
			return "";
		}
		String productsName = "";
		for (Iterator<TicketItem> iterator = ticket.getTicketItems().iterator(); iterator.hasNext();) {
			TicketItem ticketItem = (TicketItem) iterator.next();
			productsName += ticketItem.getName();
			if (iterator.hasNext()) {
				productsName += ", ";
			}
		}
		return productsName;
	}

	public void setProductName(String productsName) {
	}

}