package com.floreantpos.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import javax.xml.bind.annotation.XmlRootElement;

import com.floreantpos.model.base.BasePizzaModifierPrice;

@XmlRootElement
public class PizzaModifierPrice extends BasePizzaModifierPrice implements TimedModel{
	private static final long serialVersionUID = 1L;
	private Map<String, ModifierMultiplierPrice> priceMap = new HashMap<>();
	private boolean updateLastUpdateTime = true;
	private boolean updateSyncTime = false;

	/* [CONSTRUCTOR MARKER BEGIN] */
	public PizzaModifierPrice() {
	}

	/**
	 * Constructor for primary key
	 */
	public PizzaModifierPrice(java.lang.String id) {
		super(id);
	}

	/* [CONSTRUCTOR MARKER END] */

	public boolean isUpdateSyncTime() {
		return updateSyncTime;
	}

	public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
		this.updateSyncTime = shouldUpdateSyncTime;
	}

	public boolean isUpdateLastUpdateTime() {
		return updateLastUpdateTime;
	}

	public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
		this.updateLastUpdateTime = shouldUpdateUpdateTime;
	}

	public double getPrice() {
		return 0;
	}

	public double getExtraPrice() {
		return 0;
	}

	public void setPrice(double price) {

	}

	public void setExtraPrice(double price) {

	}

	public void initializeSizeAndPriceList(List<Multiplier> multipliers) {
		List<ModifierMultiplierPrice> priceList = getMultiplierPriceList();
		if (priceList == null) {
			priceList = new ArrayList<>();
		}
		for (ModifierMultiplierPrice price : priceList) {
			priceMap.put(price.getMultiplier().getId(), price);
		}
		for (Multiplier multiplier : multipliers) {
			ModifierMultiplierPrice priceItem = priceMap.get(multiplier.getId());
			if (priceItem == null) {
				priceItem = new ModifierMultiplierPrice();
				priceItem.setMultiplier(multiplier);
				priceList.add(priceItem);
				priceMap.put(multiplier.getId(), priceItem);
			}
		}
		setMultiplierPriceList(priceList);
	}

	public ModifierMultiplierPrice getMultiplier(String columnName) {
		return priceMap.get(columnName);
	}

	public void populateMultiplierPriceListRowValue(MenuModifier modifier) {
		for (Iterator iterator = getMultiplierPriceList().iterator(); iterator.hasNext();) {
			ModifierMultiplierPrice price = (ModifierMultiplierPrice) iterator.next();
			if (price.getPrice() == null) {
				iterator.remove();
				continue;
			}
			price.setModifierId(modifier.getId());
			price.setPizzaModifierPriceId(this.getId());

		}
	}

	@Override
	public String toString() {
		return getId();
	}
}