package com.floreantpos.model.base;

import java.lang.Comparable;
import java.io.Serializable;


/**
 * This is an object that contains data related to the MENU_MODIFIER table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="MENU_MODIFIER"
 */

public abstract class BaseMenuModifier  implements Comparable, Serializable {

	public static String REF = "MenuModifier"; //$NON-NLS-1$
	public static String PROP_COMBO_MODIFIER = "comboModifier"; //$NON-NLS-1$
	public static String PROP_SHOW_IMAGE_ONLY = "showImageOnly"; //$NON-NLS-1$
	public static String PROP_SHOULD_PRINT_TO_KITCHEN = "shouldPrintToKitchen"; //$NON-NLS-1$
	public static String PROP_HAS_SYNC_ERROR = "hasSyncError"; //$NON-NLS-1$
	public static String PROP_PROPERTIES = "properties"; //$NON-NLS-1$
	public static String PROP_COST = "cost"; //$NON-NLS-1$
	public static String PROP_NAME = "name"; //$NON-NLS-1$
	public static String PROP_BUTTON_COLOR = "buttonColor"; //$NON-NLS-1$
	public static String PROP_LAST_UPDATE_TIME = "lastUpdateTime"; //$NON-NLS-1$
	public static String PROP_TRANSLATED_NAME = "translatedName"; //$NON-NLS-1$
	public static String PROP_LAST_SYNC_TIME = "lastSyncTime"; //$NON-NLS-1$
	public static String PROP_SHOULD_SECTION_WISE_PRICE = "shouldSectionWisePrice"; //$NON-NLS-1$
	public static String PROP_IMAGE_ID = "imageId"; //$NON-NLS-1$
	public static String PROP_ENABLE = "enable"; //$NON-NLS-1$
	public static String PROP_TEXT_COLOR = "textColor"; //$NON-NLS-1$
	public static String PROP_DELETED = "deleted"; //$NON-NLS-1$
	public static String PROP_FIXED_PRICE = "fixedPrice"; //$NON-NLS-1$
	public static String PROP_TAX_GROUP_ID = "taxGroupId"; //$NON-NLS-1$
	public static String PROP_EXTRA_PRICE = "extraPrice"; //$NON-NLS-1$
	public static String PROP_SORT_ORDER = "sortOrder"; //$NON-NLS-1$
	public static String PROP_PRICE = "price"; //$NON-NLS-1$
	public static String PROP_CLOUD_SYNCED = "cloudSynced"; //$NON-NLS-1$
	public static String PROP_PIZZA_MODIFIER = "pizzaModifier"; //$NON-NLS-1$
	public static String PROP_TAG = "tag"; //$NON-NLS-1$
	public static String PROP_ID = "id"; //$NON-NLS-1$
	public static String PROP_TAXABLE = "taxable"; //$NON-NLS-1$


	// constructors
	public BaseMenuModifier () {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BaseMenuModifier (java.lang.String id) {
		this.setId(id);
		initialize();
	}

	protected void initialize () {}



	private int hashCode = Integer.MIN_VALUE;

	// primary key
	private java.lang.String id;

	 long version;

	// fields
			private java.util.Date lastUpdateTime;
				private java.util.Date lastSyncTime;
				private java.lang.String name;
				private java.lang.String translatedName;
				private java.lang.Double price;
				private java.lang.Double extraPrice;
				private java.lang.Double cost;
				private java.lang.Integer sortOrder;
				private java.lang.Integer buttonColor;
				private java.lang.Integer textColor;
				private java.lang.Boolean enable;
				private java.lang.Boolean taxable;
				private java.lang.Boolean shouldPrintToKitchen;
				private java.lang.String imageId;
				private java.lang.Boolean showImageOnly;
				private java.lang.Boolean fixedPrice;
				private java.lang.Boolean shouldSectionWisePrice;
				private java.lang.Boolean pizzaModifier;
				private java.lang.Boolean comboModifier;
				private java.lang.String tag;
				private java.lang.String taxGroupId;
				private java.lang.Boolean cloudSynced;
				private java.lang.Boolean hasSyncError;
				private java.lang.Boolean deleted;
				private java.lang.String properties;
	
	// collections
	private java.util.List<com.floreantpos.model.PizzaModifierPrice> pizzaModifierPriceList;
	private java.util.List<com.floreantpos.model.ModifierMultiplierPrice> multiplierPriceList;
	private java.util.List<com.floreantpos.model.ModifierGroup> modifierGroups;



	/**
	 * Return the unique identifier of this class
     * @hibernate.id
     *  generator-class="com.floreantpos.util.GlobalIdGenerator"
     *  column="ID"
     */
	public java.lang.String getId () {
		return id;
	}

	/**
	 * Set the unique identifier of this class
	 * @param id the new ID
	 */
	public void setId (java.lang.String id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}



	/**
	 * Return the value associated with the column: VERSION_NO
	 */

	public long getVersion () {
			return version;
	}



	/**
	 * Set the value related to the column: VERSION_NO
	 * @param version the VERSION_NO value
	 */
			public void setVersion (long version) {
			this.version = version;
	}




	/**
	 * Return the value associated with the column: LAST_UPDATE_TIME
	 */

	public java.util.Date getLastUpdateTime () {
			return lastUpdateTime;
	}



	/**
	 * Set the value related to the column: LAST_UPDATE_TIME
	 * @param lastUpdateTime the LAST_UPDATE_TIME value
	 */
			public void setLastUpdateTime (java.util.Date lastUpdateTime) {
			this.lastUpdateTime = lastUpdateTime;
	}



	/**
	 * Return the value associated with the column: LAST_SYNC_TIME
	 */

	public java.util.Date getLastSyncTime () {
			return lastSyncTime;
	}



	/**
	 * Set the value related to the column: LAST_SYNC_TIME
	 * @param lastSyncTime the LAST_SYNC_TIME value
	 */
			public void setLastSyncTime (java.util.Date lastSyncTime) {
			this.lastSyncTime = lastSyncTime;
	}



	/**
	 * Return the value associated with the column: NAME
	 */

	public java.lang.String getName () {
			return name;
	}



	/**
	 * Set the value related to the column: NAME
	 * @param name the NAME value
	 */
			public void setName (java.lang.String name) {
			this.name = name;
	}



	/**
	 * Return the value associated with the column: TRANSLATED_NAME
	 */

	public java.lang.String getTranslatedName () {
			return translatedName;
	}



	/**
	 * Set the value related to the column: TRANSLATED_NAME
	 * @param translatedName the TRANSLATED_NAME value
	 */
			public void setTranslatedName (java.lang.String translatedName) {
			this.translatedName = translatedName;
	}



	/**
	 * Return the value associated with the column: PRICE
	 */

	public java.lang.Double getPrice () {
						return price == null ? Double.valueOf(0) : price;
		}



	/**
	 * Set the value related to the column: PRICE
	 * @param price the PRICE value
	 */
			public void setPrice (java.lang.Double price) {
			this.price = price;
	}



	/**
	 * Return the value associated with the column: EXTRA_PRICE
	 */

	public java.lang.Double getExtraPrice () {
						return extraPrice == null ? Double.valueOf(0) : extraPrice;
		}



	/**
	 * Set the value related to the column: EXTRA_PRICE
	 * @param extraPrice the EXTRA_PRICE value
	 */
			public void setExtraPrice (java.lang.Double extraPrice) {
			this.extraPrice = extraPrice;
	}



	/**
	 * Return the value associated with the column: COST
	 */

	public java.lang.Double getCost () {
						return cost == null ? Double.valueOf(0) : cost;
		}



	/**
	 * Set the value related to the column: COST
	 * @param cost the COST value
	 */
			public void setCost (java.lang.Double cost) {
			this.cost = cost;
	}



	/**
	 * Return the value associated with the column: SORT_ORDER
	 */

	public java.lang.Integer getSortOrder () {
						return sortOrder == null ? Integer.valueOf(0) : sortOrder;
		}



	/**
	 * Set the value related to the column: SORT_ORDER
	 * @param sortOrder the SORT_ORDER value
	 */
			public void setSortOrder (java.lang.Integer sortOrder) {
			this.sortOrder = sortOrder;
	}



	/**
	 * Return the value associated with the column: BTN_COLOR
	 */

	public java.lang.Integer getButtonColor () {
						return buttonColor == null ? Integer.valueOf(0) : buttonColor;
		}



	/**
	 * Set the value related to the column: BTN_COLOR
	 * @param buttonColor the BTN_COLOR value
	 */
			public void setButtonColor (java.lang.Integer buttonColor) {
			this.buttonColor = buttonColor;
	}



	/**
	 * Return the value associated with the column: TEXT_COLOR
	 */

	public java.lang.Integer getTextColor () {
						return textColor == null ? Integer.valueOf(0) : textColor;
		}



	/**
	 * Set the value related to the column: TEXT_COLOR
	 * @param textColor the TEXT_COLOR value
	 */
			public void setTextColor (java.lang.Integer textColor) {
			this.textColor = textColor;
	}



	/**
	 * Return the value associated with the column: ENABLE
	 */

	public java.lang.Boolean isEnable () {
					return enable == null ? Boolean.FALSE : enable;
		}

	public java.lang.Boolean getEnable () {
				return enable == null ? Boolean.FALSE : enable;
			}


	/**
	 * Set the value related to the column: ENABLE
	 * @param enable the ENABLE value
	 */
			public void setEnable (java.lang.Boolean enable) {
			this.enable = enable;
	}



	/**
	 * Return the value associated with the column: TAXABLE
	 */

	public java.lang.Boolean isTaxable () {
					return taxable == null ? Boolean.FALSE : taxable;
		}

	public java.lang.Boolean getTaxable () {
				return taxable == null ? Boolean.FALSE : taxable;
			}


	/**
	 * Set the value related to the column: TAXABLE
	 * @param taxable the TAXABLE value
	 */
			public void setTaxable (java.lang.Boolean taxable) {
			this.taxable = taxable;
	}



	/**
	 * Return the value associated with the column: PRINT_TO_KITCHEN
	 */

	public java.lang.Boolean isShouldPrintToKitchen () {
						return shouldPrintToKitchen == null ? Boolean.valueOf(true) : shouldPrintToKitchen;
			}

	public java.lang.Boolean getShouldPrintToKitchen () {
					return shouldPrintToKitchen == null ? Boolean.valueOf(true) : shouldPrintToKitchen;
			}


	/**
	 * Set the value related to the column: PRINT_TO_KITCHEN
	 * @param shouldPrintToKitchen the PRINT_TO_KITCHEN value
	 */
			public void setShouldPrintToKitchen (java.lang.Boolean shouldPrintToKitchen) {
			this.shouldPrintToKitchen = shouldPrintToKitchen;
	}


	/**
	 * Custom property
	 */
	public static String getShouldPrintToKitchenDefaultValue () {
		return "true";
	}


	/**
	 * Return the value associated with the column: IMAGE_ID
	 */

	public java.lang.String getImageId () {
			return imageId;
	}



	/**
	 * Set the value related to the column: IMAGE_ID
	 * @param imageId the IMAGE_ID value
	 */
			public void setImageId (java.lang.String imageId) {
			this.imageId = imageId;
	}



	/**
	 * Return the value associated with the column: SHOW_IMAGE_ONLY
	 */

	public java.lang.Boolean isShowImageOnly () {
					return showImageOnly == null ? Boolean.FALSE : showImageOnly;
		}

	public java.lang.Boolean getShowImageOnly () {
				return showImageOnly == null ? Boolean.FALSE : showImageOnly;
			}


	/**
	 * Set the value related to the column: SHOW_IMAGE_ONLY
	 * @param showImageOnly the SHOW_IMAGE_ONLY value
	 */
			public void setShowImageOnly (java.lang.Boolean showImageOnly) {
			this.showImageOnly = showImageOnly;
	}



	/**
	 * Return the value associated with the column: FIXED_PRICE
	 */

	public java.lang.Boolean isFixedPrice () {
					return fixedPrice == null ? Boolean.FALSE : fixedPrice;
		}

	public java.lang.Boolean getFixedPrice () {
				return fixedPrice == null ? Boolean.FALSE : fixedPrice;
			}


	/**
	 * Set the value related to the column: FIXED_PRICE
	 * @param fixedPrice the FIXED_PRICE value
	 */
			public void setFixedPrice (java.lang.Boolean fixedPrice) {
			this.fixedPrice = fixedPrice;
	}



	/**
	 * Return the value associated with the column: SECTION_WISE_PRICING
	 */

	public java.lang.Boolean isShouldSectionWisePrice () {
					return shouldSectionWisePrice == null ? Boolean.FALSE : shouldSectionWisePrice;
		}

	public java.lang.Boolean getShouldSectionWisePrice () {
				return shouldSectionWisePrice == null ? Boolean.FALSE : shouldSectionWisePrice;
			}


	/**
	 * Set the value related to the column: SECTION_WISE_PRICING
	 * @param shouldSectionWisePrice the SECTION_WISE_PRICING value
	 */
			public void setShouldSectionWisePrice (java.lang.Boolean shouldSectionWisePrice) {
			this.shouldSectionWisePrice = shouldSectionWisePrice;
	}



	/**
	 * Return the value associated with the column: PIZZA_MODIFIER
	 */

	public java.lang.Boolean isPizzaModifier () {
					return pizzaModifier == null ? Boolean.FALSE : pizzaModifier;
		}

	public java.lang.Boolean getPizzaModifier () {
				return pizzaModifier == null ? Boolean.FALSE : pizzaModifier;
			}


	/**
	 * Set the value related to the column: PIZZA_MODIFIER
	 * @param pizzaModifier the PIZZA_MODIFIER value
	 */
			public void setPizzaModifier (java.lang.Boolean pizzaModifier) {
			this.pizzaModifier = pizzaModifier;
	}



	/**
	 * Return the value associated with the column: COMBO_MODIFIER
	 */

	public java.lang.Boolean isComboModifier () {
					return comboModifier == null ? Boolean.FALSE : comboModifier;
		}

	public java.lang.Boolean getComboModifier () {
				return comboModifier == null ? Boolean.FALSE : comboModifier;
			}


	/**
	 * Set the value related to the column: COMBO_MODIFIER
	 * @param comboModifier the COMBO_MODIFIER value
	 */
			public void setComboModifier (java.lang.Boolean comboModifier) {
			this.comboModifier = comboModifier;
	}



	/**
	 * Return the value associated with the column: TAG
	 */

	public java.lang.String getTag () {
			return tag;
	}



	/**
	 * Set the value related to the column: TAG
	 * @param tag the TAG value
	 */
			public void setTag (java.lang.String tag) {
			this.tag = tag;
	}



	/**
	 * Return the value associated with the column: TAX_GROUP_ID
	 */

	public java.lang.String getTaxGroupId () {
			return taxGroupId;
	}



	/**
	 * Set the value related to the column: TAX_GROUP_ID
	 * @param taxGroupId the TAX_GROUP_ID value
	 */
			public void setTaxGroupId (java.lang.String taxGroupId) {
			this.taxGroupId = taxGroupId;
	}



	/**
	 * Return the value associated with the column: CLOUD_SYNCED
	 */

	public java.lang.Boolean isCloudSynced () {
					return cloudSynced == null ? Boolean.FALSE : cloudSynced;
		}

	public java.lang.Boolean getCloudSynced () {
				return cloudSynced == null ? Boolean.FALSE : cloudSynced;
			}


	/**
	 * Set the value related to the column: CLOUD_SYNCED
	 * @param cloudSynced the CLOUD_SYNCED value
	 */
			public void setCloudSynced (java.lang.Boolean cloudSynced) {
			this.cloudSynced = cloudSynced;
	}



	/**
	 * Return the value associated with the column: HAS_SYNC_ERROR
	 */

	public java.lang.Boolean isHasSyncError () {
					return hasSyncError == null ? Boolean.FALSE : hasSyncError;
		}

	public java.lang.Boolean getHasSyncError () {
				return hasSyncError == null ? Boolean.FALSE : hasSyncError;
			}


	/**
	 * Set the value related to the column: HAS_SYNC_ERROR
	 * @param hasSyncError the HAS_SYNC_ERROR value
	 */
			public void setHasSyncError (java.lang.Boolean hasSyncError) {
			this.hasSyncError = hasSyncError;
	}



	/**
	 * Return the value associated with the column: DELETED
	 */

	public java.lang.Boolean isDeleted () {
						return deleted == null ? Boolean.valueOf(false) : deleted;
			}

	public java.lang.Boolean getDeleted () {
					return deleted == null ? Boolean.valueOf(false) : deleted;
			}


	/**
	 * Set the value related to the column: DELETED
	 * @param deleted the DELETED value
	 */
			public void setDeleted (java.lang.Boolean deleted) {
			this.deleted = deleted;
	}


	/**
	 * Custom property
	 */
	public static String getDeletedDefaultValue () {
		return "false";
	}


	/**
	 * Return the value associated with the column: PROPERTIES
	 */

	public java.lang.String getProperties () {
			return properties;
	}



	/**
	 * Set the value related to the column: PROPERTIES
	 * @param properties the PROPERTIES value
	 */
			public void setProperties (java.lang.String properties) {
			this.properties = properties;
	}



	/**
	 * Return the value associated with the column: pizzaModifierPriceList
	 */

	public java.util.List<com.floreantpos.model.PizzaModifierPrice> getPizzaModifierPriceList () {
			return pizzaModifierPriceList;
	}



	/**
	 * Set the value related to the column: pizzaModifierPriceList
	 * @param pizzaModifierPriceList the pizzaModifierPriceList value
	 */
			public void setPizzaModifierPriceList (java.util.List<com.floreantpos.model.PizzaModifierPrice> pizzaModifierPriceList) {
			this.pizzaModifierPriceList = pizzaModifierPriceList;
	}

	public void addTopizzaModifierPriceList (com.floreantpos.model.PizzaModifierPrice pizzaModifierPrice) {
		if (null == getPizzaModifierPriceList()) setPizzaModifierPriceList(new java.util.ArrayList<com.floreantpos.model.PizzaModifierPrice>());
		getPizzaModifierPriceList().add(pizzaModifierPrice);
	}



	/**
	 * Return the value associated with the column: multiplierPriceList
	 */

	public java.util.List<com.floreantpos.model.ModifierMultiplierPrice> getMultiplierPriceList () {
			return multiplierPriceList;
	}



	/**
	 * Set the value related to the column: multiplierPriceList
	 * @param multiplierPriceList the multiplierPriceList value
	 */
			public void setMultiplierPriceList (java.util.List<com.floreantpos.model.ModifierMultiplierPrice> multiplierPriceList) {
			this.multiplierPriceList = multiplierPriceList;
	}

	public void addTomultiplierPriceList (com.floreantpos.model.ModifierMultiplierPrice modifierMultiplierPrice) {
		if (null == getMultiplierPriceList()) setMultiplierPriceList(new java.util.ArrayList<com.floreantpos.model.ModifierMultiplierPrice>());
		getMultiplierPriceList().add(modifierMultiplierPrice);
	}



	/**
	 * Return the value associated with the column: modifierGroups
	 */

	public java.util.List<com.floreantpos.model.ModifierGroup> getModifierGroups () {
			return modifierGroups;
	}



	/**
	 * Set the value related to the column: modifierGroups
	 * @param modifierGroups the modifierGroups value
	 */
			public void setModifierGroups (java.util.List<com.floreantpos.model.ModifierGroup> modifierGroups) {
			this.modifierGroups = modifierGroups;
	}

	public void addTomodifierGroups (com.floreantpos.model.ModifierGroup modifierGroup) {
		if (null == getModifierGroups()) setModifierGroups(new java.util.ArrayList<com.floreantpos.model.ModifierGroup>());
		getModifierGroups().add(modifierGroup);
	}





	public boolean equals (Object obj) {
		if (null == obj) return false;
		if (!(obj instanceof com.floreantpos.model.MenuModifier)) return false;
		else {
			com.floreantpos.model.MenuModifier menuModifier = (com.floreantpos.model.MenuModifier) obj;
			if (null == this.getId() || null == menuModifier.getId()) return this == obj;
			else return (this.getId().equals(menuModifier.getId()));
		}
	}

	public int hashCode () {
		if (Integer.MIN_VALUE == this.hashCode) {
			if (null == this.getId()) return super.hashCode();
			else {
				String hashStr = this.getClass().getName() + ":" + this.getId().hashCode();
				this.hashCode = hashStr.hashCode();
			}
		}
		return this.hashCode;
	}

	public int compareTo (Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString () {
		return super.toString();
	}


}