package com.floreantpos.model.base;

import java.lang.Comparable;
import java.io.Serializable;


/**
 * This is an object that contains data related to the STOCK_COUNT table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="STOCK_COUNT"
 */

public abstract class BaseStockCount  implements Comparable, Serializable {

	public static String REF = "StockCount"; //$NON-NLS-1$
	public static String PROP_LAST_MODIFIED_DATE = "lastModifiedDate"; //$NON-NLS-1$
	public static String PROP_OUTLET_ID = "outletId"; //$NON-NLS-1$
	public static String PROP_USER = "user"; //$NON-NLS-1$
	public static String PROP_LAST_UPDATE_TIME = "lastUpdateTime"; //$NON-NLS-1$
	public static String PROP_LAST_SYNC_TIME = "lastSyncTime"; //$NON-NLS-1$
	public static String PROP_REF_NUMBER = "refNumber"; //$NON-NLS-1$
	public static String PROP_CREATED_DATE = "createdDate"; //$NON-NLS-1$
	public static String PROP_VERIFIED_BY = "verifiedBy"; //$NON-NLS-1$
	public static String PROP_VARIFICATION_DATE = "varificationDate"; //$NON-NLS-1$
	public static String PROP_ID = "id"; //$NON-NLS-1$


	// constructors
	public BaseStockCount () {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BaseStockCount (java.lang.String id) {
		this.setId(id);
		initialize();
	}

	protected void initialize () {}



	private int hashCode = Integer.MIN_VALUE;

	// primary key
	private java.lang.String id;

	 long version;

	// fields
			private java.util.Date lastUpdateTime;
				private java.util.Date lastSyncTime;
				private java.lang.String refNumber;
				private java.util.Date createdDate;
				private java.util.Date lastModifiedDate;
				private java.util.Date varificationDate;
				private java.lang.String outletId;
	
	// many to one
	private com.floreantpos.model.User user;
	private com.floreantpos.model.User verifiedBy;

	// collections
	private java.util.List<com.floreantpos.model.StockCountItem> countItems;



	/**
	 * Return the unique identifier of this class
     * @hibernate.id
     *  generator-class="com.floreantpos.util.GlobalIdGenerator"
     *  column="ID"
     */
	public java.lang.String getId () {
		return id;
	}

	/**
	 * Set the unique identifier of this class
	 * @param id the new ID
	 */
	public void setId (java.lang.String id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}



	/**
	 * Return the value associated with the column: VERSION_NO
	 */

	public long getVersion () {
			return version;
	}



	/**
	 * Set the value related to the column: VERSION_NO
	 * @param version the VERSION_NO value
	 */
			public void setVersion (long version) {
			this.version = version;
	}




	/**
	 * Return the value associated with the column: LAST_UPDATE_TIME
	 */

	public java.util.Date getLastUpdateTime () {
			return lastUpdateTime;
	}



	/**
	 * Set the value related to the column: LAST_UPDATE_TIME
	 * @param lastUpdateTime the LAST_UPDATE_TIME value
	 */
			public void setLastUpdateTime (java.util.Date lastUpdateTime) {
			this.lastUpdateTime = lastUpdateTime;
	}



	/**
	 * Return the value associated with the column: LAST_SYNC_TIME
	 */

	public java.util.Date getLastSyncTime () {
			return lastSyncTime;
	}



	/**
	 * Set the value related to the column: LAST_SYNC_TIME
	 * @param lastSyncTime the LAST_SYNC_TIME value
	 */
			public void setLastSyncTime (java.util.Date lastSyncTime) {
			this.lastSyncTime = lastSyncTime;
	}



	/**
	 * Return the value associated with the column: REF_NUMBER
	 */

	public java.lang.String getRefNumber () {
			return refNumber;
	}



	/**
	 * Set the value related to the column: REF_NUMBER
	 * @param refNumber the REF_NUMBER value
	 */
			public void setRefNumber (java.lang.String refNumber) {
			this.refNumber = refNumber;
	}



	/**
	 * Return the value associated with the column: CREATED_DATE
	 */

	public java.util.Date getCreatedDate () {
			return createdDate;
	}



	/**
	 * Set the value related to the column: CREATED_DATE
	 * @param createdDate the CREATED_DATE value
	 */
			public void setCreatedDate (java.util.Date createdDate) {
			this.createdDate = createdDate;
	}



	/**
	 * Return the value associated with the column: LAST_MODIFIED_DATE
	 */

	public java.util.Date getLastModifiedDate () {
			return lastModifiedDate;
	}



	/**
	 * Set the value related to the column: LAST_MODIFIED_DATE
	 * @param lastModifiedDate the LAST_MODIFIED_DATE value
	 */
			public void setLastModifiedDate (java.util.Date lastModifiedDate) {
			this.lastModifiedDate = lastModifiedDate;
	}



	/**
	 * Return the value associated with the column: VERIFICATION_DATE
	 */

	public java.util.Date getVarificationDate () {
			return varificationDate;
	}



	/**
	 * Set the value related to the column: VERIFICATION_DATE
	 * @param varificationDate the VERIFICATION_DATE value
	 */
			public void setVarificationDate (java.util.Date varificationDate) {
			this.varificationDate = varificationDate;
	}



	/**
	 * Return the value associated with the column: OUTLET_ID
	 */

	public java.lang.String getOutletId () {
			return outletId;
	}



	/**
	 * Set the value related to the column: OUTLET_ID
	 * @param outletId the OUTLET_ID value
	 */
			public void setOutletId (java.lang.String outletId) {
			this.outletId = outletId;
	}



	/**
	 * Return the value associated with the column: USER_OUTLET_ID
	 */

	public com.floreantpos.model.User getUser () {
			return user;
	}



	/**
	 * Set the value related to the column: USER_OUTLET_ID
	 * @param user the USER_OUTLET_ID value
	 */
			public void setUser (com.floreantpos.model.User user) {
			this.user = user;
	}



	/**
	 * Return the value associated with the column: VERIFIED_OUTLET_ID
	 */

	public com.floreantpos.model.User getVerifiedBy () {
			return verifiedBy;
	}



	/**
	 * Set the value related to the column: VERIFIED_OUTLET_ID
	 * @param verifiedBy the VERIFIED_OUTLET_ID value
	 */
			public void setVerifiedBy (com.floreantpos.model.User verifiedBy) {
			this.verifiedBy = verifiedBy;
	}



	/**
	 * Return the value associated with the column: countItems
	 */

	public java.util.List<com.floreantpos.model.StockCountItem> getCountItems () {
			return countItems;
	}



	/**
	 * Set the value related to the column: countItems
	 * @param countItems the countItems value
	 */
			public void setCountItems (java.util.List<com.floreantpos.model.StockCountItem> countItems) {
			this.countItems = countItems;
	}

	public void addTocountItems (com.floreantpos.model.StockCountItem stockCountItem) {
		if (null == getCountItems()) setCountItems(new java.util.ArrayList<com.floreantpos.model.StockCountItem>());
		getCountItems().add(stockCountItem);
	}





	public boolean equals (Object obj) {
		if (null == obj) return false;
		if (!(obj instanceof com.floreantpos.model.StockCount)) return false;
		else {
			com.floreantpos.model.StockCount stockCount = (com.floreantpos.model.StockCount) obj;
			if (null == this.getId() || null == stockCount.getId()) return this == obj;
			else return (this.getId().equals(stockCount.getId()));
		}
	}

	public int hashCode () {
		if (Integer.MIN_VALUE == this.hashCode) {
			if (null == this.getId()) return super.hashCode();
			else {
				String hashStr = this.getClass().getName() + ":" + this.getId().hashCode();
				this.hashCode = hashStr.hashCode();
			}
		}
		return this.hashCode;
	}

	public int compareTo (Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString () {
		return super.toString();
	}


}