package com.floreantpos.model.ext;

import com.floreantpos.Messages;

public enum DiscountCondition {
	NONE("None"), //$NON-NLS-1$
	NEW_CUSTOMERS("New Customers only"), //$NON-NLS-1$
	EXISTING_CUSTOMERS("Existing customers only"), //$NON-NLS-1$
	FIRST_ORDER_ON_STORE(Messages.getString("FirstOrderOnStore")); //$NON-NLS-1$

	private final String name;

	DiscountCondition(String name) {
		this.name = name;
	}

	public String value() {
		return name;
	}

	public static DiscountCondition fromValue(String name) {
		for (DiscountCondition dc : DiscountCondition.values()) {
			if (dc.name().equals(name)) {
				return dc;
			}
		}
		return null;
	}

	@Override
	public String toString() {
		return name;
	}

}