package com.floreantpos.model.base;

import java.lang.Comparable;
import java.io.Serializable;


/**
 * This is an object that contains data related to the BOOKING_INFO table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="BOOKING_INFO"
 */

public abstract class BaseBookingInfo  implements Comparable, Serializable {

	public static String REF = "BookingInfo"; //$NON-NLS-1$
	public static String PROP_STATUS = "status"; //$NON-NLS-1$
	public static String PROP_OUTLET_ID = "outletId"; //$NON-NLS-1$
	public static String PROP_START_HOUR = "startHour"; //$NON-NLS-1$
	public static String PROP_START_MIN = "startMin"; //$NON-NLS-1$
	public static String PROP_REMAINING_BALANCE = "remainingBalance"; //$NON-NLS-1$
	public static String PROP_GUEST_COUNT = "guestCount"; //$NON-NLS-1$
	public static String PROP_CUSTOMER_ID = "customerId"; //$NON-NLS-1$
	public static String PROP_END_MIN = "endMin"; //$NON-NLS-1$
	public static String PROP_PROPERTIES = "properties"; //$NON-NLS-1$
	public static String PROP_PAID_AMOUNT = "paidAmount"; //$NON-NLS-1$
	public static String PROP_LAST_UPDATE_TIME = "lastUpdateTime"; //$NON-NLS-1$
	public static String PROP_LAST_SYNC_TIME = "lastSyncTime"; //$NON-NLS-1$
	public static String PROP_CLOSED = "closed"; //$NON-NLS-1$
	public static String PROP_USER_ID = "userId"; //$NON-NLS-1$
	public static String PROP_BOOKING_CHARGE = "bookingCharge"; //$NON-NLS-1$
	public static String PROP_BOOKING_ID = "bookingId"; //$NON-NLS-1$
	public static String PROP_END_HOUR = "endHour"; //$NON-NLS-1$
	public static String PROP_FROM_DATE = "fromDate"; //$NON-NLS-1$
	public static String PROP_TO_DATE = "toDate"; //$NON-NLS-1$
	public static String PROP_DELETED = "deleted"; //$NON-NLS-1$
	public static String PROP_ID = "id"; //$NON-NLS-1$
	public static String PROP_BOOKING_TYPE = "bookingType"; //$NON-NLS-1$
	public static String PROP_PAYMENT_STATUS = "paymentStatus"; //$NON-NLS-1$


	// constructors
	public BaseBookingInfo () {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BaseBookingInfo (java.lang.String id) {
		this.setId(id);
		initialize();
	}

	protected void initialize () {}



	private int hashCode = Integer.MIN_VALUE;

	// primary key
	private java.lang.String id;

	 long version;

	// fields
			private java.util.Date lastUpdateTime;
				private java.util.Date lastSyncTime;
				private java.util.Date fromDate;
				private java.util.Date toDate;
				private java.lang.Integer guestCount;
				private java.lang.String status;
				private java.lang.String paymentStatus;
				private java.lang.Double bookingCharge;
				private java.lang.Double remainingBalance;
				private java.lang.Double paidAmount;
				private java.lang.Boolean closed;
				private java.lang.String bookingType;
				private java.lang.String bookingId;
				private java.lang.String outletId;
				private java.lang.String userId;
				private java.lang.String customerId;
				private java.lang.Integer startHour;
				private java.lang.Integer startMin;
				private java.lang.Integer endHour;
				private java.lang.Integer endMin;
				private java.lang.String properties;
				private java.lang.Boolean deleted;
	
	// collections
	private java.util.List<com.floreantpos.model.ShopTable> tables;



	/**
	 * Return the unique identifier of this class
     * @hibernate.id
     *  generator-class="com.floreantpos.util.GlobalIdGenerator"
     *  column="ID"
     */
	public java.lang.String getId () {
		return id;
	}

	/**
	 * Set the unique identifier of this class
	 * @param id the new ID
	 */
	public void setId (java.lang.String id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}



	/**
	 * Return the value associated with the column: VERSION_NO
	 */

	public long getVersion () {
			return version;
	}



	/**
	 * Set the value related to the column: VERSION_NO
	 * @param version the VERSION_NO value
	 */
			public void setVersion (long version) {
			this.version = version;
	}




	/**
	 * Return the value associated with the column: LAST_UPDATE_TIME
	 */

	public java.util.Date getLastUpdateTime () {
			return lastUpdateTime;
	}



	/**
	 * Set the value related to the column: LAST_UPDATE_TIME
	 * @param lastUpdateTime the LAST_UPDATE_TIME value
	 */
			public void setLastUpdateTime (java.util.Date lastUpdateTime) {
			this.lastUpdateTime = lastUpdateTime;
	}



	/**
	 * Return the value associated with the column: LAST_SYNC_TIME
	 */

	public java.util.Date getLastSyncTime () {
			return lastSyncTime;
	}



	/**
	 * Set the value related to the column: LAST_SYNC_TIME
	 * @param lastSyncTime the LAST_SYNC_TIME value
	 */
			public void setLastSyncTime (java.util.Date lastSyncTime) {
			this.lastSyncTime = lastSyncTime;
	}



	/**
	 * Return the value associated with the column: FROM_DATE
	 */

	public java.util.Date getFromDate () {
			return fromDate;
	}



	/**
	 * Set the value related to the column: FROM_DATE
	 * @param fromDate the FROM_DATE value
	 */
			public void setFromDate (java.util.Date fromDate) {
			this.fromDate = fromDate;
	}



	/**
	 * Return the value associated with the column: TO_DATE
	 */

	public java.util.Date getToDate () {
			return toDate;
	}



	/**
	 * Set the value related to the column: TO_DATE
	 * @param toDate the TO_DATE value
	 */
			public void setToDate (java.util.Date toDate) {
			this.toDate = toDate;
	}



	/**
	 * Return the value associated with the column: GUEST_COUNT
	 */

	public java.lang.Integer getGuestCount () {
						return guestCount == null ? Integer.valueOf(0) : guestCount;
		}



	/**
	 * Set the value related to the column: GUEST_COUNT
	 * @param guestCount the GUEST_COUNT value
	 */
			public void setGuestCount (java.lang.Integer guestCount) {
			this.guestCount = guestCount;
	}



	/**
	 * Return the value associated with the column: STATUS
	 */

	public java.lang.String getStatus () {
			return status;
	}



	/**
	 * Set the value related to the column: STATUS
	 * @param status the STATUS value
	 */
			public void setStatus (java.lang.String status) {
			this.status = status;
	}



	/**
	 * Return the value associated with the column: PAYMENT_STATUS
	 */

	public java.lang.String getPaymentStatus () {
			return paymentStatus;
	}



	/**
	 * Set the value related to the column: PAYMENT_STATUS
	 * @param paymentStatus the PAYMENT_STATUS value
	 */
			public void setPaymentStatus (java.lang.String paymentStatus) {
			this.paymentStatus = paymentStatus;
	}



	/**
	 * Return the value associated with the column: BOOKING_CHARGE
	 */

	public java.lang.Double getBookingCharge () {
						return bookingCharge == null ? Double.valueOf(0) : bookingCharge;
		}



	/**
	 * Set the value related to the column: BOOKING_CHARGE
	 * @param bookingCharge the BOOKING_CHARGE value
	 */
			public void setBookingCharge (java.lang.Double bookingCharge) {
			this.bookingCharge = bookingCharge;
	}



	/**
	 * Return the value associated with the column: REMAINING_BALANCE
	 */

	public java.lang.Double getRemainingBalance () {
						return remainingBalance == null ? Double.valueOf(0) : remainingBalance;
		}



	/**
	 * Set the value related to the column: REMAINING_BALANCE
	 * @param remainingBalance the REMAINING_BALANCE value
	 */
			public void setRemainingBalance (java.lang.Double remainingBalance) {
			this.remainingBalance = remainingBalance;
	}



	/**
	 * Return the value associated with the column: PAID_AMOUNT
	 */

	public java.lang.Double getPaidAmount () {
						return paidAmount == null ? Double.valueOf(0) : paidAmount;
		}



	/**
	 * Set the value related to the column: PAID_AMOUNT
	 * @param paidAmount the PAID_AMOUNT value
	 */
			public void setPaidAmount (java.lang.Double paidAmount) {
			this.paidAmount = paidAmount;
	}



	/**
	 * Return the value associated with the column: CLOSED
	 */

	public java.lang.Boolean isClosed () {
					return closed == null ? Boolean.FALSE : closed;
		}

	public java.lang.Boolean getClosed () {
				return closed == null ? Boolean.FALSE : closed;
			}


	/**
	 * Set the value related to the column: CLOSED
	 * @param closed the CLOSED value
	 */
			public void setClosed (java.lang.Boolean closed) {
			this.closed = closed;
	}



	/**
	 * Return the value associated with the column: BOOKING_TYPE
	 */

	public java.lang.String getBookingType () {
			return bookingType;
	}



	/**
	 * Set the value related to the column: BOOKING_TYPE
	 * @param bookingType the BOOKING_TYPE value
	 */
			public void setBookingType (java.lang.String bookingType) {
			this.bookingType = bookingType;
	}



	/**
	 * Return the value associated with the column: BOOKING_ID
	 */

	public java.lang.String getBookingId () {
			return bookingId;
	}



	/**
	 * Set the value related to the column: BOOKING_ID
	 * @param bookingId the BOOKING_ID value
	 */
			public void setBookingId (java.lang.String bookingId) {
			this.bookingId = bookingId;
	}



	/**
	 * Return the value associated with the column: OUTLET_ID
	 */

	public java.lang.String getOutletId () {
			return outletId;
	}



	/**
	 * Set the value related to the column: OUTLET_ID
	 * @param outletId the OUTLET_ID value
	 */
			public void setOutletId (java.lang.String outletId) {
			this.outletId = outletId;
	}



	/**
	 * Return the value associated with the column: USER_ID
	 */

	public java.lang.String getUserId () {
			return userId;
	}



	/**
	 * Set the value related to the column: USER_ID
	 * @param userId the USER_ID value
	 */
			public void setUserId (java.lang.String userId) {
			this.userId = userId;
	}



	/**
	 * Return the value associated with the column: CUSTOMER_ID
	 */

	public java.lang.String getCustomerId () {
			return customerId;
	}



	/**
	 * Set the value related to the column: CUSTOMER_ID
	 * @param customerId the CUSTOMER_ID value
	 */
			public void setCustomerId (java.lang.String customerId) {
			this.customerId = customerId;
	}



	/**
	 * Return the value associated with the column: START_HOUR
	 */

	public java.lang.Integer getStartHour () {
						return startHour == null ? Integer.valueOf(0) : startHour;
		}



	/**
	 * Set the value related to the column: START_HOUR
	 * @param startHour the START_HOUR value
	 */
			public void setStartHour (java.lang.Integer startHour) {
			this.startHour = startHour;
	}



	/**
	 * Return the value associated with the column: START_MIN
	 */

	public java.lang.Integer getStartMin () {
						return startMin == null ? Integer.valueOf(0) : startMin;
		}



	/**
	 * Set the value related to the column: START_MIN
	 * @param startMin the START_MIN value
	 */
			public void setStartMin (java.lang.Integer startMin) {
			this.startMin = startMin;
	}



	/**
	 * Return the value associated with the column: END_HOUR
	 */

	public java.lang.Integer getEndHour () {
						return endHour == null ? Integer.valueOf(0) : endHour;
		}



	/**
	 * Set the value related to the column: END_HOUR
	 * @param endHour the END_HOUR value
	 */
			public void setEndHour (java.lang.Integer endHour) {
			this.endHour = endHour;
	}



	/**
	 * Return the value associated with the column: END_MIN
	 */

	public java.lang.Integer getEndMin () {
						return endMin == null ? Integer.valueOf(0) : endMin;
		}



	/**
	 * Set the value related to the column: END_MIN
	 * @param endMin the END_MIN value
	 */
			public void setEndMin (java.lang.Integer endMin) {
			this.endMin = endMin;
	}



	/**
	 * Return the value associated with the column: PROPERTIES
	 */

	public java.lang.String getProperties () {
			return properties;
	}



	/**
	 * Set the value related to the column: PROPERTIES
	 * @param properties the PROPERTIES value
	 */
			public void setProperties (java.lang.String properties) {
			this.properties = properties;
	}



	/**
	 * Return the value associated with the column: DELETED
	 */

	public java.lang.Boolean isDeleted () {
						return deleted == null ? Boolean.valueOf(false) : deleted;
			}

	public java.lang.Boolean getDeleted () {
					return deleted == null ? Boolean.valueOf(false) : deleted;
			}


	/**
	 * Set the value related to the column: DELETED
	 * @param deleted the DELETED value
	 */
			public void setDeleted (java.lang.Boolean deleted) {
			this.deleted = deleted;
	}


	/**
	 * Custom property
	 */
	public static String getDeletedDefaultValue () {
		return "false";
	}


	/**
	 * Return the value associated with the column: tables
	 */

	public java.util.List<com.floreantpos.model.ShopTable> getTables () {
			return tables;
	}



	/**
	 * Set the value related to the column: tables
	 * @param tables the tables value
	 */
			public void setTables (java.util.List<com.floreantpos.model.ShopTable> tables) {
			this.tables = tables;
	}

	public void addTotables (com.floreantpos.model.ShopTable shopTable) {
		if (null == getTables()) setTables(new java.util.ArrayList<com.floreantpos.model.ShopTable>());
		getTables().add(shopTable);
	}





	public boolean equals (Object obj) {
		if (null == obj) return false;
		if (!(obj instanceof com.floreantpos.model.BookingInfo)) return false;
		else {
			com.floreantpos.model.BookingInfo bookingInfo = (com.floreantpos.model.BookingInfo) obj;
			if (null == this.getId() || null == bookingInfo.getId()) return this == obj;
			else return (this.getId().equals(bookingInfo.getId()));
		}
	}

	public int hashCode () {
		if (Integer.MIN_VALUE == this.hashCode) {
			if (null == this.getId()) return super.hashCode();
			else {
				String hashStr = this.getClass().getName() + ":" + this.getId().hashCode();
				this.hashCode = hashStr.hashCode();
			}
		}
		return this.hashCode;
	}

	public int compareTo (Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString () {
		return super.toString();
	}


}