package com.floreantpos.model.base;

import java.lang.Comparable;
import java.io.Serializable;


/**
 * This is an object that contains data related to the CUSTOM_PAYMENT table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="CUSTOM_PAYMENT"
 */

public abstract class BaseCustomPayment  implements Comparable, Serializable {

	public static String REF = "CustomPayment"; //$NON-NLS-1$
	public static String PROP_REQUIRED_REF_NUMBER = "requiredRefNumber"; //$NON-NLS-1$
	public static String PROP_LAST_UPDATE_TIME = "lastUpdateTime"; //$NON-NLS-1$
	public static String PROP_LAST_SYNC_TIME = "lastSyncTime"; //$NON-NLS-1$
	public static String PROP_ENABLE = "enable"; //$NON-NLS-1$
	public static String PROP_DELETED = "deleted"; //$NON-NLS-1$
	public static String PROP_REF_NUMBER_FIELD_NAME = "refNumberFieldName"; //$NON-NLS-1$
	public static String PROP_NAME = "name"; //$NON-NLS-1$


	// constructors
	public BaseCustomPayment () {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BaseCustomPayment (
		java.lang.String id,
		java.lang.String outletId) {

		this.setId(id);
		this.setOutletId(outletId);
		initialize();
	}

	protected void initialize () {}



	private int hashCode = Integer.MIN_VALUE;

	// primary key

	private java.lang.String id;

	private java.lang.String outletId;

	 long version;

	// fields
			private java.util.Date lastUpdateTime;
				private java.util.Date lastSyncTime;
				private java.lang.String name;
				private java.lang.Boolean requiredRefNumber;
				private java.lang.String refNumberFieldName;
				private java.lang.Boolean enable;
				private java.lang.Boolean deleted;
	


	/**
     * @hibernate.property
     *  column=ID
	 * not-null=true
	 */
	public java.lang.String getId () {
		return this.id;
	}

	/**
	 * Set the value related to the column: ID
	 * @param id the ID value
	 */
	public void setId (java.lang.String id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}

	/**
     * @hibernate.property
     *  column=OUTLET_ID
	 * not-null=true
	 */
	public java.lang.String getOutletId () {
		return this.outletId;
	}

	/**
	 * Set the value related to the column: OUTLET_ID
	 * @param outletId the OUTLET_ID value
	 */
	public void setOutletId (java.lang.String outletId) {
		this.outletId = outletId;
		this.hashCode = Integer.MIN_VALUE;
	}



	/**
	 * Return the value associated with the column: VERSION_NO
	 */

	public long getVersion () {
			return version;
	}



	/**
	 * Set the value related to the column: VERSION_NO
	 * @param version the VERSION_NO value
	 */
			public void setVersion (long version) {
			this.version = version;
	}




	/**
	 * Return the value associated with the column: LAST_UPDATE_TIME
	 */

	public java.util.Date getLastUpdateTime () {
			return lastUpdateTime;
	}



	/**
	 * Set the value related to the column: LAST_UPDATE_TIME
	 * @param lastUpdateTime the LAST_UPDATE_TIME value
	 */
			public void setLastUpdateTime (java.util.Date lastUpdateTime) {
			this.lastUpdateTime = lastUpdateTime;
	}



	/**
	 * Return the value associated with the column: LAST_SYNC_TIME
	 */

	public java.util.Date getLastSyncTime () {
			return lastSyncTime;
	}



	/**
	 * Set the value related to the column: LAST_SYNC_TIME
	 * @param lastSyncTime the LAST_SYNC_TIME value
	 */
			public void setLastSyncTime (java.util.Date lastSyncTime) {
			this.lastSyncTime = lastSyncTime;
	}



	/**
	 * Return the value associated with the column: NAME
	 */

	public java.lang.String getName () {
			return name;
	}



	/**
	 * Set the value related to the column: NAME
	 * @param name the NAME value
	 */
			public void setName (java.lang.String name) {
			this.name = name;
	}



	/**
	 * Return the value associated with the column: REQUIRED_REF_NUMBER
	 */

	public java.lang.Boolean isRequiredRefNumber () {
					return requiredRefNumber == null ? Boolean.FALSE : requiredRefNumber;
		}

	public java.lang.Boolean getRequiredRefNumber () {
				return requiredRefNumber == null ? Boolean.FALSE : requiredRefNumber;
			}


	/**
	 * Set the value related to the column: REQUIRED_REF_NUMBER
	 * @param requiredRefNumber the REQUIRED_REF_NUMBER value
	 */
			public void setRequiredRefNumber (java.lang.Boolean requiredRefNumber) {
			this.requiredRefNumber = requiredRefNumber;
	}



	/**
	 * Return the value associated with the column: REF_NUMBER_FIELD_NAME
	 */

	public java.lang.String getRefNumberFieldName () {
			return refNumberFieldName;
	}



	/**
	 * Set the value related to the column: REF_NUMBER_FIELD_NAME
	 * @param refNumberFieldName the REF_NUMBER_FIELD_NAME value
	 */
			public void setRefNumberFieldName (java.lang.String refNumberFieldName) {
			this.refNumberFieldName = refNumberFieldName;
	}



	/**
	 * Return the value associated with the column: ENABLE
	 */

	public java.lang.Boolean isEnable () {
					return enable == null ? Boolean.FALSE : enable;
		}

	public java.lang.Boolean getEnable () {
				return enable == null ? Boolean.FALSE : enable;
			}


	/**
	 * Set the value related to the column: ENABLE
	 * @param enable the ENABLE value
	 */
			public void setEnable (java.lang.Boolean enable) {
			this.enable = enable;
	}



	/**
	 * Return the value associated with the column: DELETED
	 */

	public java.lang.Boolean isDeleted () {
						return deleted == null ? Boolean.valueOf(false) : deleted;
			}

	public java.lang.Boolean getDeleted () {
					return deleted == null ? Boolean.valueOf(false) : deleted;
			}


	/**
	 * Set the value related to the column: DELETED
	 * @param deleted the DELETED value
	 */
			public void setDeleted (java.lang.Boolean deleted) {
			this.deleted = deleted;
	}


	/**
	 * Custom property
	 */
	public static String getDeletedDefaultValue () {
		return "false";
	}




	public boolean equals (Object obj) {
		if (null == obj) return false;//abcd
		if (!(obj instanceof com.floreantpos.model.CustomPayment)) return false;
		else {
			com.floreantpos.model.CustomPayment customPayment = (com.floreantpos.model.CustomPayment) obj;
			if (null != this.getId() && null != customPayment.getId()) {
				if (!this.getId().equals(customPayment.getId())) {
					return false;
				}
			}
			else {
				return false;
			}
			if (null != this.getOutletId() && null != customPayment.getOutletId()) {
				if (!this.getOutletId().equals(customPayment.getOutletId())) {
					return false;
				}
			}
			else {
				return false;
			}
			return true;
		}
	}

	public int hashCode () {
		if (Integer.MIN_VALUE == this.hashCode) {
			StringBuilder sb = new StringBuilder();
			if (null != this.getId()) {
				sb.append(this.getId().hashCode());
				sb.append(":");
			}
			else {
				return super.hashCode();
			}
			if (null != this.getOutletId()) {
				sb.append(this.getOutletId().hashCode());
				sb.append(":");
			}
			else {
				return super.hashCode();
			}
			this.hashCode = sb.toString().hashCode();
		}
		return this.hashCode;
	}

	public int compareTo (Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString () {
		return super.toString();
	}


}