package com.floreantpos.model.base;

import java.io.Serializable;


/**
 * This is an object that contains data related to the COUPON_AND_DISCOUNT table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="COUPON_AND_DISCOUNT"
 */

public abstract class BaseDiscount  implements Comparable, Serializable {

	public static String REF = "Discount"; //$NON-NLS-1$
	public static String PROP_EXPIRY_DATE = "expiryDate"; //$NON-NLS-1$
	public static String PROP_MINIMUM_BUY = "minimumBuy"; //$NON-NLS-1$
	public static String PROP_APPLY_TO_MONDAY_ONLY = "applyToMondayOnly"; //$NON-NLS-1$
	public static String PROP_APPLY_TO_THURSDAY_ONLY = "applyToThursdayOnly"; //$NON-NLS-1$
	public static String PROP_PROPERTIES = "properties"; //$NON-NLS-1$
	public static String PROP_MODIFIABLE = "modifiable"; //$NON-NLS-1$
	public static String PROP_NAME = "name"; //$NON-NLS-1$
	public static String PROP_AUTO_APPLY = "autoApply"; //$NON-NLS-1$
	public static String PROP_START_DATE = "startDate"; //$NON-NLS-1$
	public static String PROP_LAST_UPDATE_TIME = "lastUpdateTime"; //$NON-NLS-1$
	public static String PROP_LAST_SYNC_TIME = "lastSyncTime"; //$NON-NLS-1$
	public static String PROP_APPLY_TO_SUNDAY_ONLY = "applyToSundayOnly"; //$NON-NLS-1$
	public static String PROP_DELETED = "deleted"; //$NON-NLS-1$
	public static String PROP_APPLY_TO_SATURDAY_ONLY = "applyToSaturdayOnly"; //$NON-NLS-1$
	public static String PROP_APPLY_TO_WEDNESDAY_ONLY = "applyToWednesdayOnly"; //$NON-NLS-1$
	public static String PROP_OUTLET_ID = "outletId"; //$NON-NLS-1$
	public static String PROP_APPLY_TO_FRIDAY_ONLY = "applyToFridayOnly"; //$NON-NLS-1$
	public static String PROP_ENABLED = "enabled"; //$NON-NLS-1$
	public static String PROP_SHOW_IN_FRONT_END = "showInFrontEnd"; //$NON-NLS-1$
	public static String PROP_MAXIMUM_OFF = "maximumOff"; //$NON-NLS-1$
	public static String PROP_APPLY_TO_TUESDAY_ONLY = "applyToTuesdayOnly"; //$NON-NLS-1$
	public static String PROP_APPLY_TO_ALL = "applyToAll"; //$NON-NLS-1$
	public static String PROP_TYPE = "type"; //$NON-NLS-1$
	public static String PROP_QUALIFICATION_TYPE = "qualificationType"; //$NON-NLS-1$
	public static String PROP_NEVER_EXPIRE = "neverExpire"; //$NON-NLS-1$
	public static String PROP_BARCODE = "barcode"; //$NON-NLS-1$
	public static String PROP_VALUE = "value"; //$NON-NLS-1$
	public static String PROP_ID = "id"; //$NON-NLS-1$

	public static String PROP_APPLY_IF_DIVISIBLE = "applyIfDivisible"; //$NON-NLS-1$

	// constructors
	public BaseDiscount () {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BaseDiscount (java.lang.String id) {
		this.setId(id);
		initialize();
	}

	protected void initialize () {}



	private int hashCode = Integer.MIN_VALUE;

	// primary key
	private java.lang.String id;

	 long version;

	// fields
			private java.util.Date lastUpdateTime;
				private java.util.Date lastSyncTime;
				private java.lang.String name;
				private java.lang.Integer type;
				private java.lang.String barcode;
				private java.lang.Integer qualificationType;
				private java.lang.Boolean applyToAll;
				private java.lang.Double minimumBuy;
				private java.lang.Double maximumOff;
				private java.lang.Double value;
				private java.util.Date expiryDate;
				private java.lang.Boolean enabled;
				private java.lang.Boolean showInFrontEnd;
				private java.lang.Boolean autoApply;
				private java.lang.Boolean modifiable;
				private java.lang.Boolean neverExpire;
				private java.util.Date startDate;
				private java.lang.Integer minimumReferrer;
				private java.lang.Boolean applyToSundayOnly;
				private java.lang.Boolean applyToMondayOnly;
				private java.lang.Boolean applyToTuesdayOnly;
				private java.lang.Boolean applyToWednesdayOnly;
				private java.lang.Boolean applyToThursdayOnly;
				private java.lang.Boolean applyToFridayOnly;
				private java.lang.Boolean applyToSaturdayOnly;
				private java.lang.String outletId;
				private java.lang.String properties;
				private java.lang.Boolean deleted;
				private java.lang.Boolean applyIfDivisible;
	
	// collections
	private java.util.List<com.floreantpos.model.MenuItem> menuItems;
	private java.util.List<com.floreantpos.model.MenuGroup> menuGroups;
	private java.util.List<com.floreantpos.model.MenuCategory> menuCategories;
	private java.util.List<com.floreantpos.model.Customer> referrers;



	/**
	 * Return the unique identifier of this class
     * @hibernate.id
     *  generator-class="com.floreantpos.util.GlobalIdGenerator"
     *  column="ID"
     */
	public java.lang.String getId () {
		return id;
	}

	/**
	 * Set the unique identifier of this class
	 * @param id the new ID
	 */
	public void setId (java.lang.String id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}



	/**
	 * Return the value associated with the column: VERSION_NO
	 */

	public long getVersion () {
			return version;
	}



	/**
	 * Set the value related to the column: VERSION_NO
	 * @param version the VERSION_NO value
	 */
			public void setVersion (long version) {
			this.version = version;
	}




	/**
	 * Return the value associated with the column: LAST_UPDATE_TIME
	 */

	public java.util.Date getLastUpdateTime () {
			return lastUpdateTime;
	}



	/**
	 * Set the value related to the column: LAST_UPDATE_TIME
	 * @param lastUpdateTime the LAST_UPDATE_TIME value
	 */
			public void setLastUpdateTime (java.util.Date lastUpdateTime) {
			this.lastUpdateTime = lastUpdateTime;
	}



	/**
	 * Return the value associated with the column: LAST_SYNC_TIME
	 */

	public java.util.Date getLastSyncTime () {
			return lastSyncTime;
	}



	/**
	 * Set the value related to the column: LAST_SYNC_TIME
	 * @param lastSyncTime the LAST_SYNC_TIME value
	 */
			public void setLastSyncTime (java.util.Date lastSyncTime) {
			this.lastSyncTime = lastSyncTime;
	}



	/**
	 * Return the value associated with the column: NAME
	 */

	public java.lang.String getName () {
			return name;
	}



	/**
	 * Set the value related to the column: NAME
	 * @param name the NAME value
	 */
			public void setName (java.lang.String name) {
			this.name = name;
	}



	/**
	 * Return the value associated with the column: TYPE
	 */

	public java.lang.Integer getType () {
						return type == null ? Integer.valueOf(0) : type;
		}



	/**
	 * Set the value related to the column: TYPE
	 * @param type the TYPE value
	 */
			public void setType (java.lang.Integer type) {
			this.type = type;
	}



	/**
	 * Return the value associated with the column: BARCODE
	 */

	public java.lang.String getBarcode () {
			return barcode;
	}



	/**
	 * Set the value related to the column: BARCODE
	 * @param barcode the BARCODE value
	 */
			public void setBarcode (java.lang.String barcode) {
			this.barcode = barcode;
	}



	/**
	 * Return the value associated with the column: QUALIFICATION_TYPE
	 */

	public java.lang.Integer getQualificationType () {
						return qualificationType == null ? Integer.valueOf(0) : qualificationType;
		}



	/**
	 * Set the value related to the column: QUALIFICATION_TYPE
	 * @param qualificationType the QUALIFICATION_TYPE value
	 */
			public void setQualificationType (java.lang.Integer qualificationType) {
			this.qualificationType = qualificationType;
	}

	/**
	 * Return the value associated with the column: MINIMUM_REFERRER
	 */

	public java.lang.Integer getMinimumReferrer () {
						return minimumReferrer == null ? Integer.valueOf(0) : minimumReferrer;
		}



	/**
	 * Set the value related to the column: MINIMUM_REFERRER
	 * @param minimumReferrer the MINIMUM_REFERRER value
	 */
			public void setMinimumReferrer (java.lang.Integer minimumReferrer) {
			this.minimumReferrer = minimumReferrer;
	}

	/**
	 * Return the value associated with the column: APPLY_TO_ALL
	 */

	public java.lang.Boolean isApplyToAll () {
					return applyToAll == null ? Boolean.FALSE : applyToAll;
		}

	public java.lang.Boolean getApplyToAll () {
				return applyToAll == null ? Boolean.FALSE : applyToAll;
			}


	/**
	 * Set the value related to the column: APPLY_TO_ALL
	 * @param applyToAll the APPLY_TO_ALL value
	 */
			public void setApplyToAll (java.lang.Boolean applyToAll) {
			this.applyToAll = applyToAll;
	}



	/**
	 * Return the value associated with the column: MINIMUM_BUY_AMOUNT
	 */

	public java.lang.Double getMinimumBuy () {
						return minimumBuy == null ? Double.valueOf(0) : minimumBuy;
		}



	/**
	 * Set the value related to the column: MINIMUM_BUY_AMOUNT
	 * @param minimumBuy the MINIMUM_BUY_AMOUNT value
	 */
			public void setMinimumBuy (java.lang.Double minimumBuy) {
			this.minimumBuy = minimumBuy;
	}



	/**
	 * Return the value associated with the column: MAXIMUM_OFF_AMOUNT
	 */

	public java.lang.Double getMaximumOff () {
						return maximumOff == null ? Double.valueOf(0) : maximumOff;
		}



	/**
	 * Set the value related to the column: MAXIMUM_OFF_AMOUNT
	 * @param maximumOff the MAXIMUM_OFF_AMOUNT value
	 */
			public void setMaximumOff (java.lang.Double maximumOff) {
			this.maximumOff = maximumOff;
	}



	/**
	 * Return the value associated with the column: VALUE
	 */

	public java.lang.Double getValue () {
						return value == null ? Double.valueOf(0) : value;
		}



	/**
	 * Set the value related to the column: VALUE
	 * @param value the VALUE value
	 */
			public void setValue (java.lang.Double value) {
			this.value = value;
	}



	/**
	 * Return the value associated with the column: EXPIRY_DATE
	 */

	public java.util.Date getExpiryDate () {
			return expiryDate;
	}



	/**
	 * Set the value related to the column: EXPIRY_DATE
	 * @param expiryDate the EXPIRY_DATE value
	 */
			public void setExpiryDate (java.util.Date expiryDate) {
			this.expiryDate = expiryDate;
	}



	/**
	 * Return the value associated with the column: ENABLED
	 */

	public java.lang.Boolean isEnabled () {
					return enabled == null ? Boolean.FALSE : enabled;
		}

	public java.lang.Boolean getEnabled () {
				return enabled == null ? Boolean.FALSE : enabled;
			}


	/**
	 * Set the value related to the column: ENABLED
	 * @param enabled the ENABLED value
	 */
			public void setEnabled (java.lang.Boolean enabled) {
			this.enabled = enabled;
	}

	
	/**
	 * Return the value associated with the column: SHOW_IN_FRONTEND
	 */
	public java.lang.Boolean isShowInFrontEnd () {
		return showInFrontEnd == null ? Boolean.FALSE : showInFrontEnd;
	}		
	
	public java.lang.Boolean getShowInFrontEnd () {
		return showInFrontEnd == null ? Boolean.FALSE : showInFrontEnd;
	}


	/**
	 * Set the value related to the column: SHOW_IN_FRONTEND
	 * @param showInFrontEnd the SHOW_IN_FRONTEND value
	 */
			public void setShowInFrontEnd (java.lang.Boolean showInFrontEnd) {
			this.showInFrontEnd = showInFrontEnd;
	}

			

	/**
	 * Return the value associated with the column: AUTO_APPLY
	 */

	public java.lang.Boolean isAutoApply () {
					return autoApply == null ? Boolean.FALSE : autoApply;
		}

	public java.lang.Boolean getAutoApply () {
				return autoApply == null ? Boolean.FALSE : autoApply;
			}


	/**
	 * Set the value related to the column: AUTO_APPLY
	 * @param autoApply the AUTO_APPLY value
	 */
			public void setAutoApply (java.lang.Boolean autoApply) {
			this.autoApply = autoApply;
	}



	/**
	 * Return the value associated with the column: MODIFIABLE
	 */

	public java.lang.Boolean isModifiable () {
					return modifiable == null ? Boolean.FALSE : modifiable;
		}

	public java.lang.Boolean getModifiable () {
				return modifiable == null ? Boolean.FALSE : modifiable;
			}


	/**
	 * Set the value related to the column: MODIFIABLE
	 * @param modifiable the MODIFIABLE value
	 */
			public void setModifiable (java.lang.Boolean modifiable) {
			this.modifiable = modifiable;
	}



	/**
	 * Return the value associated with the column: NEVER_EXPIRE
	 */

	public java.lang.Boolean isNeverExpire () {
					return neverExpire == null ? Boolean.FALSE : neverExpire;
		}

	public java.lang.Boolean getNeverExpire () {
				return neverExpire == null ? Boolean.FALSE : neverExpire;
			}


	/**
	 * Set the value related to the column: NEVER_EXPIRE
	 * @param neverExpire the NEVER_EXPIRE value
	 */
			public void setNeverExpire (java.lang.Boolean neverExpire) {
			this.neverExpire = neverExpire;
	}



	/**
	 * Return the value associated with the column: START_DATE
	 */

	public java.util.Date getStartDate () {
			return startDate;
	}



	/**
	 * Set the value related to the column: START_DATE
	 * @param startDate the START_DATE value
	 */
			public void setStartDate (java.util.Date startDate) {
			this.startDate = startDate;
	}



	/**
	 * Return the value associated with the column: APPLY_TO_SUNDAY_ONLY
	 */

	public java.lang.Boolean isApplyToSundayOnly () {
					return applyToSundayOnly == null ? Boolean.FALSE : applyToSundayOnly;
		}

	public java.lang.Boolean getApplyToSundayOnly () {
				return applyToSundayOnly == null ? Boolean.FALSE : applyToSundayOnly;
			}


	/**
	 * Set the value related to the column: APPLY_TO_SUNDAY_ONLY
	 * @param applyToSundayOnly the APPLY_TO_SUNDAY_ONLY value
	 */
			public void setApplyToSundayOnly (java.lang.Boolean applyToSundayOnly) {
			this.applyToSundayOnly = applyToSundayOnly;
	}



	/**
	 * Return the value associated with the column: APPLY_TO_MONDAY_ONLY
	 */

	public java.lang.Boolean isApplyToMondayOnly () {
					return applyToMondayOnly == null ? Boolean.FALSE : applyToMondayOnly;
		}

	public java.lang.Boolean getApplyToMondayOnly () {
				return applyToMondayOnly == null ? Boolean.FALSE : applyToMondayOnly;
			}


	/**
	 * Set the value related to the column: APPLY_TO_MONDAY_ONLY
	 * @param applyToMondayOnly the APPLY_TO_MONDAY_ONLY value
	 */
			public void setApplyToMondayOnly (java.lang.Boolean applyToMondayOnly) {
			this.applyToMondayOnly = applyToMondayOnly;
	}



	/**
	 * Return the value associated with the column: APPLY_TO_TUESDAY_ONLY
	 */

	public java.lang.Boolean isApplyToTuesdayOnly () {
					return applyToTuesdayOnly == null ? Boolean.FALSE : applyToTuesdayOnly;
		}

	public java.lang.Boolean getApplyToTuesdayOnly () {
				return applyToTuesdayOnly == null ? Boolean.FALSE : applyToTuesdayOnly;
			}


	/**
	 * Set the value related to the column: APPLY_TO_TUESDAY_ONLY
	 * @param applyToTuesdayOnly the APPLY_TO_TUESDAY_ONLY value
	 */
			public void setApplyToTuesdayOnly (java.lang.Boolean applyToTuesdayOnly) {
			this.applyToTuesdayOnly = applyToTuesdayOnly;
	}



	/**
	 * Return the value associated with the column: APPLY_TO_WEDNESDAY_ONLY
	 */

	public java.lang.Boolean isApplyToWednesdayOnly () {
					return applyToWednesdayOnly == null ? Boolean.FALSE : applyToWednesdayOnly;
		}

	public java.lang.Boolean getApplyToWednesdayOnly () {
				return applyToWednesdayOnly == null ? Boolean.FALSE : applyToWednesdayOnly;
			}


	/**
	 * Set the value related to the column: APPLY_TO_WEDNESDAY_ONLY
	 * @param applyToWednesdayOnly the APPLY_TO_WEDNESDAY_ONLY value
	 */
			public void setApplyToWednesdayOnly (java.lang.Boolean applyToWednesdayOnly) {
			this.applyToWednesdayOnly = applyToWednesdayOnly;
	}



	/**
	 * Return the value associated with the column: APPLY_TO_THURSDAY_ONLY
	 */

	public java.lang.Boolean isApplyToThursdayOnly () {
					return applyToThursdayOnly == null ? Boolean.FALSE : applyToThursdayOnly;
		}

	public java.lang.Boolean getApplyToThursdayOnly () {
				return applyToThursdayOnly == null ? Boolean.FALSE : applyToThursdayOnly;
			}


	/**
	 * Set the value related to the column: APPLY_TO_THURSDAY_ONLY
	 * @param applyToThursdayOnly the APPLY_TO_THURSDAY_ONLY value
	 */
			public void setApplyToThursdayOnly (java.lang.Boolean applyToThursdayOnly) {
			this.applyToThursdayOnly = applyToThursdayOnly;
	}



	/**
	 * Return the value associated with the column: APPLY_TO_FRIDAY_ONLY
	 */

	public java.lang.Boolean isApplyToFridayOnly () {
					return applyToFridayOnly == null ? Boolean.FALSE : applyToFridayOnly;
		}

	public java.lang.Boolean getApplyToFridayOnly () {
				return applyToFridayOnly == null ? Boolean.FALSE : applyToFridayOnly;
			}


	/**
	 * Set the value related to the column: APPLY_TO_FRIDAY_ONLY
	 * @param applyToFridayOnly the APPLY_TO_FRIDAY_ONLY value
	 */
			public void setApplyToFridayOnly (java.lang.Boolean applyToFridayOnly) {
			this.applyToFridayOnly = applyToFridayOnly;
	}



	/**
	 * Return the value associated with the column: APPLY_TO_SATURDAY_ONLY
	 */

	public java.lang.Boolean isApplyToSaturdayOnly () {
					return applyToSaturdayOnly == null ? Boolean.FALSE : applyToSaturdayOnly;
		}

	public java.lang.Boolean getApplyToSaturdayOnly () {
				return applyToSaturdayOnly == null ? Boolean.FALSE : applyToSaturdayOnly;
			}


	/**
	 * Set the value related to the column: APPLY_TO_SATURDAY_ONLY
	 * @param applyToSaturdayOnly the APPLY_TO_SATURDAY_ONLY value
	 */
			public void setApplyToSaturdayOnly (java.lang.Boolean applyToSaturdayOnly) {
			this.applyToSaturdayOnly = applyToSaturdayOnly;
	}



	/**
	 * Return the value associated with the column: OUTLET_ID
	 */

	public java.lang.String getOutletId () {
			return outletId;
	}



	/**
	 * Set the value related to the column: OUTLET_ID
	 * @param outletId the OUTLET_ID value
	 */
			public void setOutletId (java.lang.String outletId) {
			this.outletId = outletId;
	}



	/**
	 * Return the value associated with the column: PROPERTIES
	 */

	public java.lang.String getProperties () {
			return properties;
	}



	/**
	 * Set the value related to the column: PROPERTIES
	 * @param properties the PROPERTIES value
	 */
			public void setProperties (java.lang.String properties) {
			this.properties = properties;
	}

	/**
		 * Return the value associated with the column: APPLY_IF_DIVISIBLE
		 */

	public java.lang.Boolean isApplyIfDivisible() {
		return applyIfDivisible == null ? Boolean.FALSE : applyIfDivisible;
	}

	public java.lang.Boolean getApplyIfDivisible() {
		return applyIfDivisible == null ? Boolean.FALSE : applyIfDivisible;
	}

	/**
	 * Set the value related to the column: APPLY_IF_DIVISIBLE
	 * @param applyIfDivisible the APPLY_IF_DIVISIBLE value
	 */
	public void setApplyIfDivisible(java.lang.Boolean applyIfDivisible) {
		this.applyIfDivisible = applyIfDivisible;
	}

	/**
	 * Return the value associated with the column: DELETED
	 */

	public java.lang.Boolean isDeleted () {
						return deleted == null ? Boolean.valueOf(false) : deleted;
			}

	public java.lang.Boolean getDeleted () {
					return deleted == null ? Boolean.valueOf(false) : deleted;
			}


	/**
	 * Set the value related to the column: DELETED
	 * @param deleted the DELETED value
	 */
			public void setDeleted (java.lang.Boolean deleted) {
			this.deleted = deleted;
	}


	/**
	 * Custom property
	 */
	public static String getDeletedDefaultValue () {
		return "false";
	}


	/**
	 * Return the value associated with the column: menuItems
	 */

	public java.util.List<com.floreantpos.model.MenuItem> getMenuItems () {
			return menuItems;
	}



	/**
	 * Set the value related to the column: menuItems
	 * @param menuItems the menuItems value
	 */
			public void setMenuItems (java.util.List<com.floreantpos.model.MenuItem> menuItems) {
			this.menuItems = menuItems;
	}

	public void addTomenuItems (com.floreantpos.model.MenuItem menuItem) {
		if (null == getMenuItems()) setMenuItems(new java.util.ArrayList<com.floreantpos.model.MenuItem>());
		getMenuItems().add(menuItem);
	}



	/**
	 * Return the value associated with the column: menuGroups
	 */

	public java.util.List<com.floreantpos.model.MenuGroup> getMenuGroups () {
			return menuGroups;
	}



	/**
	 * Set the value related to the column: menuGroups
	 * @param menuGroups the menuGroups value
	 */
			public void setMenuGroups (java.util.List<com.floreantpos.model.MenuGroup> menuGroups) {
			this.menuGroups = menuGroups;
	}

	public void addTomenuGroups (com.floreantpos.model.MenuGroup menuGroup) {
		if (null == getMenuGroups()) setMenuGroups(new java.util.ArrayList<com.floreantpos.model.MenuGroup>());
		getMenuGroups().add(menuGroup);
	}



	/**
	 * Return the value associated with the column: menuCategories
	 */

	public java.util.List<com.floreantpos.model.MenuCategory> getMenuCategories () {
			return menuCategories;
	}



	/**
	 * Set the value related to the column: menuCategories
	 * @param menuCategories the menuCategories value
	 */
			public void setMenuCategories (java.util.List<com.floreantpos.model.MenuCategory> menuCategories) {
			this.menuCategories = menuCategories;
	}

	public void addTomenuCategories (com.floreantpos.model.MenuCategory menuCategory) {
		if (null == getMenuCategories()) setMenuCategories(new java.util.ArrayList<com.floreantpos.model.MenuCategory>());
		getMenuCategories().add(menuCategory);
	}


	/**
	 * Return the value associated with the column: referrers
	 */

	public java.util.List<com.floreantpos.model.Customer> getReferrers () {
			return referrers;
	}



	/**
	 * Set the value related to the column: referrers
	 * @param referrers the referrers value
	 */
			public void setReferrers (java.util.List<com.floreantpos.model.Customer> referrers) {
			this.referrers = referrers;
	}

	public void addToreferrers (com.floreantpos.model.Customer referrer) {
		if (null == getReferrers()) setReferrers(new java.util.ArrayList<com.floreantpos.model.Customer>());
		getReferrers().add(referrer);
	}



	public boolean equals (Object obj) {
		if (null == obj) return false;
		if (!(obj instanceof com.floreantpos.model.Discount)) return false;
		else {
			com.floreantpos.model.Discount discount = (com.floreantpos.model.Discount) obj;
			if (null == this.getId() || null == discount.getId()) return this == obj;
			else return (this.getId().equals(discount.getId()));
		}
	}

	public int hashCode () {
		if (Integer.MIN_VALUE == this.hashCode) {
			if (null == this.getId()) return super.hashCode();
			else {
				String hashStr = this.getClass().getName() + ":" + this.getId().hashCode();
				this.hashCode = hashStr.hashCode();
			}
		}
		return this.hashCode;
	}

	public int compareTo (Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString () {
		return super.toString();
	}


}