/**
 * ************************************************************************
 * * The contents of this file are subject to the MRPL 1.2
 * * (the  "License"),  being   the  Mozilla   Public  License
 * * Version 1.1  with a permitted attribution clause; you may not  use this
 * * file except in compliance with the License. You  may  obtain  a copy of
 * * the License at http://www.floreantpos.org/license.html
 * * Software distributed under the License  is  distributed  on  an "AS IS"
 * * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * * License for the specific  language  governing  rights  and  limitations
 * * under the License.
 * * The Original Code is FLOREANT POS.
 * * The Initial Developer of the Original Code is OROCUBE LLC
 * * All portions are Copyright (C) 2015 OROCUBE LLC
 * * All Rights Reserved.
 * ************************************************************************
 */
package com.floreantpos.main;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;

import javax.swing.ImageIcon;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.floreantpos.config.TerminalConfig;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.PosPrinters;
import com.floreantpos.model.Store;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.User;
import com.floreantpos.model.util.DataProvider;

public class Application {

	private boolean developmentMode = false;

	private User currentUser;

	private static Application instance;

	private static SimpleDateFormat dateFormat = new SimpleDateFormat("dd MMM, yyyy"); //$NON-NLS-1$

	private boolean systemInitialized;

	private static final String PRODUCT_NAME = "OROPOS"; //$NON-NLS-1$
	private static final String URL_POS_PRICING = "https://pos.orocube.com/pricing/"; //$NON-NLS-1$
	private static final String URL_REQUEST_PIN = "https://pos.orocube.com/download/#section-2.-Request-Pin"; //$NON-NLS-1$
	//private static final String PRODUCT_VERSION = "1.4";

	public static final String OROPOS_LICENSE_PIN = PRODUCT_NAME + ".license.pin"; //$NON-NLS-1$


	protected Application() {
	}

	public void start() {
	}

	private void checkForCloudConnection() {
	}

	private void initMqtt() {
	}

	public String getUpdateServerURL() {
		String updateUrl = TerminalConfig.getUpdateServerURL();
		if (StringUtils.isEmpty(updateUrl)) {
			updateUrl = "https://orodev.net/update/oropos"; //$NON-NLS-1$
		}
		return updateUrl;
	}

	public void initLicense(String systemUID) throws Exception {
	}

	private void showLIcenseSelectionDialog(Exception e) {
	}

	public synchronized static Application getInstance() {
		if (instance == null) {
			instance = new Application();

		}
		return instance;
	}

	public static void setInstance(Application application) {
		instance = application;
	}


	public static User getCurrentUser() {
		return getInstance().currentUser;
	}

	public void setCurrentUser(User currentUser) {
		this.currentUser = currentUser;
	}

	public Terminal getTerminal() {
		return DataProvider.get().getCurrentTerminal();
	}

	public synchronized Terminal refreshAndGetTerminal() {
		DataProvider.get().refreshCurrentTerminal();
		return DataProvider.get().getCurrentTerminal();
	}

	public static String formatDate(Date date) {
		return dateFormat.format(date);
	}

	public boolean isSystemInitialized() {
		return systemInitialized;
	}

	public void setSystemInitialized(boolean systemInitialized) {
		this.systemInitialized = systemInitialized;
	}

	public Store getStore() {
		return DataProvider.get().getStore();
	}

	public static Outlet getOutlet() {
		return DataProvider.get().getOutlet();
	}

	public static File getWorkingDir() {
		File file = new File(Application.class.getProtectionDomain().getCodeSource().getLocation().getPath());

		return file.getParentFile();
	}

	public boolean isDevelopmentMode() {
		return developmentMode;
	}

	public void setDevelopmentMode(boolean developmentMode) {
		this.developmentMode = developmentMode;
	}

	public Boolean isPriceIncludesTax() {
		return false;
	}

	public String getMqttDeviceId() {
		return "posdb.net";
	}

	public static PosPrinters getPrinters() {
		return null;
	}

	public void refreshStore() {
	}

}