package com.floreantpos.model.dao;

import java.util.ArrayList;

import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

import com.floreantpos.model.Campaign;
import com.floreantpos.model.Pagination;

public class CampaignDAO extends BaseCampaignDAO {

	/**
	 * Default constructor.  Can be used in place of getInstance()
	 */
	public CampaignDAO() {
	}

	public Campaign findByCampaignId(String campaignId) {
		try (Session session = createNewSession()) {
			Criteria criteria = session.createCriteria(getReferenceClass());
			criteria.add(Restrictions.eq(Campaign.PROP_CAMPAIGN_ID, campaignId).ignoreCase());
			criteria.setMaxResults(1);
			return (Campaign) criteria.uniqueResult();
		}
	}

	public int rowCountByCampaignId(String id, String campaignId) {
		try (Session session = createNewSession()) {
			Criteria criteria = session.createCriteria(getReferenceClass());
			criteria.setProjection(Projections.rowCount());
			if (StringUtils.isNotBlank(id)) {
				criteria.add(Restrictions.ne(Campaign.PROP_ID, id));
			}
			criteria.add(Restrictions.eq(Campaign.PROP_CAMPAIGN_ID, campaignId).ignoreCase());
			Number result = (Number) criteria.uniqueResult();
			if (result != null) {
				return result.intValue();
			}
			return 0;
		}
	}

	public void loadData(Pagination<Campaign> tableModel, String campaign) {
		try (Session session = createNewSession()) {
			Criteria criteria = session.createCriteria(Campaign.class);
			criteria.setProjection(Projections.rowCount());
			criteria.add(Restrictions.isNotNull(Campaign.PROP_TICKET_JSON));
			if (StringUtils.isNotBlank(campaign)) {
				criteria.add(Restrictions.eq(Campaign.PROP_CAMPAIGN_ID, campaign));
			}
			addDeletedFilter(criteria);
			Number result = (Number) criteria.uniqueResult();
			int rowCount = result == null ? 0 : result.intValue();
			tableModel.setNumRows(rowCount);
			if (rowCount == 0) {
				tableModel.setRows(new ArrayList<>());
				return;
			}
			criteria.setProjection(null);
			criteria.setFirstResult(tableModel.getCurrentRowIndex());
			criteria.setMaxResults(tableModel.getPageSize());
			tableModel.setRows(criteria.list());
		}
	}

}