/**
 * ************************************************************************
 * * The contents of this file are subject to the MRPL 1.2
 * * (the  "License"),  being   the  Mozilla   Public  License
 * * Version 1.1  with a permitted attribution clause; you may not  use this
 * * file except in compliance with the License. You  may  obtain  a copy of
 * * the License at http://www.floreantpos.org/license.html
 * * Software distributed under the License  is  distributed  on  an "AS IS"
 * * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * * License for the specific  language  governing  rights  and  limitations
 * * under the License.
 * * The Original Code is FLOREANT POS.
 * * The Initial Developer of the Original Code is OROCUBE LLC
 * * All portions are Copyright (C) 2015 OROCUBE LLC
 * * All Rights Reserved.
 * ************************************************************************
 */
package com.floreantpos.model.dao;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;

import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Restrictions;

import com.floreantpos.model.MenuItemModifierPage;
import com.floreantpos.model.MenuItemModifierSpec;
import com.floreantpos.model.ModifierGroup;
import com.orocube.rest.service.server.BaseDataServiceDao;

public class MenuItemModifierSpecDAO extends BaseMenuItemModifierSpecDAO {

	/**
	 * Default constructor.  Can be used in place of getInstance()
	 */
	public MenuItemModifierSpecDAO() {
	}

	@Override
	protected Serializable save(Object obj, Session s) {
		updateTime(obj);
		return super.save(obj, s);
	}

	@Override
	protected void update(Object obj, Session s) {
		updateTime(obj);
		super.update(obj, s);
	}

	@Override
	protected void saveOrUpdate(Object obj, Session s) {
		updateTime(obj);
		super.saveOrUpdate(obj, s);
	}

	public MenuItemModifierSpec initialize(MenuItemModifierSpec menuItemModifierSpec) {
		if (menuItemModifierSpec == null || menuItemModifierSpec.getId() == null)
			return menuItemModifierSpec;

		Session session = null;

		try {
			session = createNewSession();
			session.refresh(menuItemModifierSpec);

			Hibernate.initialize(menuItemModifierSpec.getDefaultModifierList());
			Hibernate.initialize(menuItemModifierSpec.getModifierPages());

			return menuItemModifierSpec;
		} finally {
			closeSession(session);
		}
	}

	public MenuItemModifierSpec findByGroup(ModifierGroup modifierGroup) {
		Session session = null;
		try {
			session = getSession();
			Criteria criteria = session.createCriteria(getReferenceClass());
			criteria.add(Restrictions.eq(MenuItemModifierSpec.PROP_MODIFIER_GROUP_ID, modifierGroup == null ? null : modifierGroup.getId()));
			List list = criteria.list();
			if (list != null && !list.isEmpty()) {
				return (MenuItemModifierSpec) list.get(0);
			}
		} finally {
			session.close();
		}
		return null;
	}

	public List<MenuItemModifierSpec> findAllByGroup(ModifierGroup modifierGroup) {
		try (Session session = createNewSession()) {
			Criteria criteria = session.createCriteria(MenuItemModifierSpec.class);
			addDeletedFilter(criteria);
			criteria.add(Restrictions.eq(MenuItemModifierSpec.PROP_MODIFIER_GROUP_ID, modifierGroup == null ? null : modifierGroup.getId()));
			return criteria.list();
		}
	}

	public MenuItemModifierSpec findByMenuItemId(String menuItemId) {
		Session session = null;
		try {
			session = createNewSession();
			Criteria criteria = session.createCriteria(getReferenceClass());
			criteria.add(Restrictions.eq(MenuItemModifierSpec.PROP_MENU_ITEM_ID, menuItemId));
			List list = criteria.list();
			if (list != null && !list.isEmpty()) {
				return (MenuItemModifierSpec) list.get(0);
			}
		} finally {
			session.close();
		}
		return null;
	}

	public List<MenuItemModifierSpec> findByMenuItem(String menuItemId) {
		Session session = null;
		try {
			session = createNewSession();
			Criteria criteria = session.createCriteria(getReferenceClass());
			criteria.add(Restrictions.eq(MenuItemModifierSpec.PROP_MENU_ITEM_ID, menuItemId));
			return criteria.list();
		} finally {
			session.close();
		}
	}

	public void saveOrUpdate(MenuItemModifierSpec spec, MenuItemModifierPage page) {
		Session session = null;
		Transaction tx = null;
		try {
			session = createNewSession();
			tx = session.beginTransaction();
			session.saveOrUpdate(page);
			session.saveOrUpdate(spec);
			tx.commit();
		} catch (Exception e) {
			tx.rollback();
			throw e;
		} finally {
			session.close();
		}
	}

	public void saveOrUpdateMenuItemModifierSpecList(List<MenuItemModifierSpec> dataList, boolean updateLastUpdateTime, boolean updateSyncTime)
			throws Exception {
		if (dataList == null)
			return;

		Transaction tx = null;
		Session session = null;
		try {
			session = createNewSession();
			tx = session.beginTransaction();

			for (Iterator<MenuItemModifierSpec> iterator = dataList.iterator(); iterator.hasNext();) {
				MenuItemModifierSpec item = (MenuItemModifierSpec) iterator.next();
				BaseDataServiceDao.get().saveOrSetVersionMenuItemModifierSpecs(session, updateLastUpdateTime, updateSyncTime, null, item);
				saveOrUpdate(item, session);
				//				if (existingItem != null) {
				//					long version = existingItem.getVersion();
				//					PropertyUtils.copyProperties(existingItem, item);
				//					existingItem.setVersion(version);
				//					existingItem.setUpdateLastUpdateTime(updateLastUpdateTime);
				//					existingItem.setUpdateSyncTime(updateSyncTime);
				//					update(existingItem, session);
				//				}
				//				else {
				//					item.setUpdateLastUpdateTime(updateLastUpdateTime);
				//					item.setUpdateSyncTime(updateSyncTime);
				//					save(item, session);
				//				}
			}
			tx.commit();
		} catch (Exception e) {
			tx.rollback();
			throw e;
		} finally {
			closeSession(session);
		}

	}

}