/**
 * ************************************************************************
 * * The contents of this file are subject to the MRPL 1.2
 * * (the  "License"),  being   the  Mozilla   Public  License
 * * Version 1.1  with a permitted attribution clause; you may not  use this
 * * file except in compliance with the License. You  may  obtain  a copy of
 * * the License at http://www.floreantpos.org/license.html
 * * Software distributed under the License  is  distributed  on  an "AS IS"
 * * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * * License for the specific  language  governing  rights  and  limitations
 * * under the License.
 * * The Original Code is FLOREANT POS.
 * * The Initial Developer of the Original Code is OROCUBE LLC
 * * All portions are Copyright (C) 2015 OROCUBE LLC
 * * All Rights Reserved.
 * ************************************************************************
 */
package com.floreantpos.report;

import java.util.List;

import javax.swing.table.AbstractTableModel;

import com.floreantpos.model.util.DateUtil;

public class VoidItemReportModel extends AbstractTableModel {
	private String[] columnNames = { "date", "order", "qty", "itemName", "amount", "voidReason", "itemWasted", "employee", "deletedBy" };//$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$ //$NON-NLS-8$ //$NON-NLS-9$ //$NON-NLS-10$ 
	private List<DeletedItem> items;

	public VoidItemReportModel() {
		super();
	}

	public int getRowCount() {
		if (items == null) {
			return 0;
		}

		return items.size();
	}

	public int getColumnCount() {
		return columnNames.length;
	}

	@Override
	public String getColumnName(int column) {
		return columnNames[column];
	}

	public Object getValueAt(int rowIndex, int columnIndex) {
		DeletedItem item = items.get(rowIndex);

		switch (columnIndex) {
			case 0:
				return DateUtil.formatSmall(item.getVoidDate());
			case 1:
				return item.getTicketId();

			case 2:
				return item.getQuantity();

			case 3:
				return item.getName();

			case 4:
				return item.getTotal();

			case 5:
				return item.getVoidReason();

			case 6:
				return item.getItemWasted();

			case 7:
				if (item.getOwner() != null)
					return item.getOwner().getFullName();
				return ""; //$NON-NLS-1$

			case 8:
				if (item.getVoidUser() != null)
					return item.getVoidUser().getFullName();
				return ""; //$NON-NLS-1$
		}

		return null;
	}

	public List<DeletedItem> getItems() {
		return items;
	}

	public void setItems(List<DeletedItem> items) {
		this.items = items;
	}
}
