package com.orocube.orostore.order.client.ui.license;

import java.io.Serializable;
import java.util.Date;

import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class TerminalLicense implements Serializable {

	private Date issueDate;
	private Date expiredDate;
	private String terminalKey;
	private String productId;
	private String productName;
	private Boolean status;
	private String orderId;
	private String terminalName;

	public TerminalLicense(String terminalKey, Date issueDate, Date expiredDate, Boolean status, String orderId) {
		super();
		this.terminalKey = terminalKey;
		this.issueDate = issueDate;
		this.expiredDate = expiredDate;
		this.status = status;
		this.setOrderId(orderId);
	}

	public String getTerminalKey() {
		return terminalKey;
	}

	public void setTerminalKeys(String terminalKey) {
		this.terminalKey = terminalKey;
	}

	public java.util.Date getIssueDate() {
		return issueDate;
	}

	public void setIssueDate(Date issueDate) {
		this.issueDate = issueDate;
	}

	public java.util.Date getExpiredDate() {
		return expiredDate;
	}

	public void setExpiredDate(Date expiryDate) {
		this.expiredDate = expiryDate;
	}

	public String getProductId() {
		return productId;
	}

	public void setProductId(String productId) {
		this.productId = productId;
	}

	public String getProductName() {
		return productName;
	}

	public void setProductName(String productName) {
		this.productName = productName;
	}

	public Boolean getStatus() {
		return status;
	}

	public void setStatus(Boolean status) {
		this.status = status;
	}

	public String getOrderId() {
		return orderId;
	}

	public void setOrderId(String orderId) {
		this.orderId = orderId;
	}

	public String getStatusMsg() {
		if (status) {
			return "Active";
		}
		return "Expired";
	}

	public String getTerminalName() {
		return terminalName;
	}

	public void setTerminalName(String terminalName) {
		this.terminalName = terminalName;
	}
}
