/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.pos.pricecalc;

import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.Agent;
import com.floreantpos.model.ComboTicketItem;
import com.floreantpos.model.Course;
import com.floreantpos.model.Customer;
import com.floreantpos.model.Department;
import com.floreantpos.model.Discount;
import com.floreantpos.model.Doctor;
import com.floreantpos.model.IUnit;
import com.floreantpos.model.InventoryStockUnit;
import com.floreantpos.model.InventoryUnit;
import com.floreantpos.model.InventoryUnitGroup;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuItemSize;
import com.floreantpos.model.ModifiableTicketItem;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.PackagingUnit;
import com.floreantpos.model.PizzaCrust;
import com.floreantpos.model.PizzaPrice;
import com.floreantpos.model.SalesArea;
import com.floreantpos.model.SubOrderType;
import com.floreantpos.model.Tax;
import com.floreantpos.model.TaxGroup;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemDiscount;
import com.floreantpos.model.TicketItemModifier;
import com.floreantpos.model.TicketItemTax;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.model.dao.MenuGroupDAO;
import com.floreantpos.model.dao.MenuItemSizeDAO;
import com.floreantpos.model.dao.PizzaCrustDAO;
import com.floreantpos.model.ext.UnitBaseItemPrice;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.model.util.InventoryUnitConversionRule;
import com.floreantpos.model.util.ReferralCommissionType;
import com.floreantpos.model.util.pricecalc.DataUtilCalculator;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class DataUtilCalc
implements DataUtilCalculator {
    private static DataUtilCalc instance = new DataUtilCalc();

    public TicketItem convertToTicketItem(MenuItem selectedMenuItem, Ticket ticket, double itemQuantity, boolean hasComboModifiers, IUnit destinationUnit, boolean checkEditablePrice, boolean useOnlinePrice) {
        List discountList;
        String referrerId;
        Object ticketItem = null;
        MenuItem menuItem = selectedMenuItem;
        boolean isComboItem = selectedMenuItem.isComboItem();
        if (selectedMenuItem.isVariant().booleanValue()) {
            menuItem = selectedMenuItem.getParentMenuItem();
            if (menuItem == null) {
                throw new PosException("Parent menu item is not set for variant " + selectedMenuItem.getId() + " : " + selectedMenuItem.getDisplayName());
            }
            isComboItem = menuItem.isComboItem();
            if (destinationUnit == null) {
                destinationUnit = selectedMenuItem.getUnit();
            }
        }
        ticketItem = isComboItem ? new ComboTicketItem() : (menuItem.isLabDoctorRequired() || menuItem.isPizzaType() != false || menuItem.hasModifiers() || hasComboModifiers ? new ModifiableTicketItem() : new TicketItem());
        ticketItem.setTaxIncluded(DataProvider.get().getOutlet().isItemPriceIncludesTax());
        OrderType orderType = null;
        if (ticket != null) {
            orderType = ticket.getOrderType();
        }
        if (orderType != null && orderType.isEnableCourse().booleanValue()) {
            Course course;
            String courseId = menuItem.getCourseOrganizeId();
            ticketItem.setCourseId(courseId);
            if (StringUtils.isNotEmpty((String)courseId) && (course = DataProvider.get().getCourse(courseId)) != null) {
                ticketItem.setCourseName(course.getShortName());
            }
        }
        ticketItem.setDataVersion(Integer.valueOf(2));
        ticketItem.setMenuItemId(selectedMenuItem.getId());
        ticketItem.setProductType(menuItem.getProductType());
        ticketItem.setBrandId(selectedMenuItem.getBrandId());
        ticketItem.setMenuItem(selectedMenuItem);
        ticketItem.setComboItem(menuItem.isComboItem());
        ticketItem.setPizzaType(selectedMenuItem.isPizzaType());
        ticketItem.setFractionalUnit(menuItem.isFractionalUnit());
        ticketItem.setName(selectedMenuItem.getName());
        ticketItem.setGroupId(menuItem.getMenuGroupId());
        ticketItem.setGroupName(menuItem.getMenuGroupName());
        ticketItem.setCategoryName(menuItem.getMenuCategoryName());
        ticketItem.setCategoryId(menuItem.getMenuCategoryId());
        ticketItem.setServiceChargeApplicable(menuItem.isServiceChargeApplicable());
        ticketItem.setServiceChargeRate(menuItem.getServiceCharge());
        ticketItem.setTaxOnServiceCharge(menuItem.isTaxOnServiceCharge());
        ticketItem.setUnitSelection(menuItem.isAllowUnitSelection());
        if (StringUtils.isNotEmpty((String)selectedMenuItem.getTranslatedName())) {
            ticketItem.addProperty("translatedName", selectedMenuItem.getTranslatedName());
        }
        this.setTicketItemUnitPriceAndCost(selectedMenuItem, (TicketItem)ticketItem, destinationUnit, ticket, checkEditablePrice, useOnlinePrice);
        ticketItem.setQuantity(Double.valueOf(itemQuantity));
        ticketItem.setInventoryItem(menuItem.isInventoryItem());
        ticketItem.setTicket(ticket);
        ticketItem.setShouldPrintToKitchen(menuItem.isShouldPrintToKitchen());
        ticketItem.setBeverage(menuItem.isBeverage());
        ticketItem.setPrinterGroup(menuItem.getPrinterGroup());
        ticketItem.setTicketDiscountApplicable(menuItem.isTicketDiscountApplicable());
        ticketItem.setReportGroupId(menuItem.getReportGroupId());
        ticketItem.setDeliveryDate(DateUtil.prepareDate((String)menuItem.getPreparationTime()));
        boolean isLabDoctorRequired = menuItem.isLabDoctorRequired();
        ticketItem.setLabDoctorRequired(isLabDoctorRequired);
        if (isLabDoctorRequired) {
            double labDoctorFee = menuItem.getLabDoctorFee();
            ticketItem.setLabDoctorFee(Double.valueOf(labDoctorFee));
            TicketItemModifier labDoctorFeeModifier = new TicketItemModifier();
            labDoctorFeeModifier.setItemQuantity(Double.valueOf(1.0));
            labDoctorFeeModifier.setName("Lab doctor fee");
            labDoctorFeeModifier.setUnitCost(Double.valueOf(labDoctorFee));
            labDoctorFeeModifier.setUnitPrice(Double.valueOf(labDoctorFee));
            labDoctorFeeModifier.putApplyDiscountOnDoctorFee(DataProvider.get().getStore().isApplyDiscountOnDoctorFee());
            labDoctorFeeModifier.addProperty("labDoctorFee", String.valueOf(true));
            labDoctorFeeModifier.setTicketItem((TicketItem)ticketItem);
            ticketItem.addToticketItemModifiers(labDoctorFeeModifier);
        }
        if (StringUtils.isNotBlank((String)(referrerId = ticket.getReferrerId()))) {
            Customer referrer = CustomerDAO.getInstance().get(referrerId);
            if (referrer != null) {
                if (referrer instanceof Agent) {
                    ticketItem.putRfRateOnReport(POSUtil.parseDouble((String)referrer.getRfRateOnReport()));
                    ticketItem.putRfOnReportType(referrer.getRfOnReportType());
                } else if (referrer instanceof Doctor && referrer.isReceiveReferralFee()) {
                    ticketItem.putRfRateOnReport(referrer.getDoctorRfRateOnReport());
                    ticketItem.putRfOnReportType(ReferralCommissionType.PERCENTAGE.name());
                }
            }
            String chargeType = ticketItem.getRfOnReportType();
            ReferralCommissionType referralCommissionType = ReferralCommissionType.fromName((String)chargeType);
            ticketItem.putRfOnReportType(chargeType);
            ticketItem.putRfRateOnReport(this.calculateReferrerCommissionRate((TicketItem)ticketItem, referralCommissionType, menuItem.getMenuGroupId()));
        }
        PosLog.debug(DataUtilCalc.class, (String)(ticketItem.getRfOnReportType() + " < > " + ticketItem.getRfRateOnReport()));
        this.setItemTaxes((TicketItem)ticketItem, selectedMenuItem.getTaxGroup(), ticket.getOrderType());
        ticketItem.setTestItems(selectedMenuItem.getTestItems());
        ticketItem.setShouldPrintToKitchen(menuItem.isShouldPrintToKitchen());
        ticketItem.setPrintKitchenSticker(menuItem.isPrintKitchenSticker());
        Boolean serviceChargeApplicable = ticket.getOrderType().isServiceChargeApplicable();
        if (serviceChargeApplicable.booleanValue()) {
            ticketItem.setServiceChargeApplicable(serviceChargeApplicable);
            ticketItem.setServiceChargeRate(ticket.getOutletServiceChargeRate());
        }
        if ((discountList = menuItem.getDiscounts()) != null) {
            for (Discount discount : discountList) {
                if (!discount.isAutoApply().booleanValue() || !discount.isEnabled().booleanValue() || discount.isExpired()) continue;
                TicketItemDiscount ticketItemDiscount = this.convertToTicketItemDiscount(discount, (TicketItem)ticketItem);
                ticketItem.addTodiscounts(ticketItemDiscount);
            }
        }
        if (menuItem.isService().booleanValue()) {
            ticketItem.setService(Boolean.valueOf(true));
            ticketItem.setTicketDiscountApplicable(Boolean.valueOf(false));
            ticketItem.setServiceType(menuItem.getServiceType());
            ticketItem.setPaymentType(menuItem.getPaymentType());
            ticketItem.setCustomerRequired(menuItem.isCustomerRequired());
        }
        return ticketItem;
    }

    public double calculateReferrerCommissionRate(TicketItem ticketItem, ReferralCommissionType referralCommissionType, String menuGroupId) {
        if (referralCommissionType.equals((Object)ReferralCommissionType.STANDARD)) {
            if (StringUtils.isNotBlank((String)menuGroupId)) {
                MenuGroup menuGroup = MenuGroupDAO.getInstance().get(menuGroupId);
                return menuGroup.getRefPercentage();
            }
            return 0.0;
        }
        return ticketItem.getRfRateOnReport();
    }

    public void setTicketItemUnitPriceAndCost(MenuItem selectedMenuItem, TicketItem ticketItem, IUnit destinationUnit, Ticket ticket, boolean checkEditablePrice, boolean useOnlinePrice) {
        if (selectedMenuItem.isEditablePrice().booleanValue() && checkEditablePrice) {
            if (destinationUnit != null) {
                double unitQuantity = selectedMenuItem.getUnitQuantity((IUnit)selectedMenuItem.getUnit(), destinationUnit);
                Double unitCost = selectedMenuItem.getItemCost() / unitQuantity;
                ticketItem.setUnitName(destinationUnit.getId());
                ticketItem.setUnitCost(unitCost);
            } else {
                ticketItem.setUnitName(selectedMenuItem.getUnitId());
                ticketItem.setUnitCost(Double.valueOf(selectedMenuItem.getItemCost()));
            }
            ticketItem.setUnitPrice(selectedMenuItem.getPrice());
        } else {
            Double priceRulePrice = useOnlinePrice ? selectedMenuItem.getOnlinePrice(ticket.getOutletId()).doubleValue() : this.getPriceFromPriceRule(selectedMenuItem, ticket, ticketItem);
            ticketItem.setUnitPrice(priceRulePrice);
            if (destinationUnit != null) {
                double unitQuantity = selectedMenuItem.getUnitQuantity((IUnit)selectedMenuItem.getUnit(), destinationUnit);
                Double unitPrice = this.getDestinationUnitPrice(selectedMenuItem, destinationUnit, ticketItem.getUnitPrice(), unitQuantity);
                Double unitCost = selectedMenuItem.getItemCost() / unitQuantity;
                ticketItem.setUnitName(destinationUnit.getId());
                ticketItem.setUnitCost(unitCost);
                ticketItem.setUnitPrice(unitPrice);
            } else {
                ticketItem.setUnitName(selectedMenuItem.getUnitId());
                ticketItem.setUnitCost(Double.valueOf(selectedMenuItem.getItemCost()));
            }
        }
        if (destinationUnit != null) {
            ticketItem.addProperty("unit_Name", destinationUnit.getName());
            ticketItem.addProperty("unit_Code", destinationUnit.getUniqueCode());
            ticketItem.addProperty("unit_display_name", destinationUnit.getDisplayName());
            ticketItem.addProperty("unit_Id", destinationUnit.getId());
            ticketItem.addProperty("unit_stock_countable", String.valueOf(destinationUnit.isStockCountable()));
            ticketItem.addProperty("unit_conversion_rate", String.valueOf(destinationUnit.getConversionRate()));
            if (destinationUnit instanceof InventoryUnit) {
                ticketItem.addProperty("unit_conversion_rule", String.valueOf(((InventoryUnit)destinationUnit).getConversionRule().getName()));
            }
        } else {
            InventoryUnit inventoryUnit = selectedMenuItem.getUnit();
            if (inventoryUnit != null) {
                ticketItem.addProperty("unit_Name", inventoryUnit.getName());
                ticketItem.addProperty("unit_Code", inventoryUnit.getCode());
                ticketItem.addProperty("unit_display_name", inventoryUnit.getDisplayName());
                ticketItem.addProperty("unit_Id", inventoryUnit.getId());
                ticketItem.addProperty("unit_stock_countable", String.valueOf(inventoryUnit.isStockCountable()));
                ticketItem.addProperty("unit_conversion_rate", String.valueOf(inventoryUnit.getConversionRate()));
                ticketItem.addProperty("unit_conversion_rule", String.valueOf(inventoryUnit.getConversionRule().getName()));
            }
        }
    }

    public void setItemTaxes(TicketItem ticketItem, TaxGroup itemTaxGroup, OrderType orderType) {
        SubOrderType subOrderType;
        TaxGroup orderBaseTaxGroup;
        MenuItem menuItem = ticketItem.getMenuItem();
        if (menuItem != null && orderType != null && (orderBaseTaxGroup = this.getOrderBaseTaxGroup(menuItem, "", orderType.getId())) != null) {
            itemTaxGroup = orderBaseTaxGroup;
        }
        if (ticketItem.getTicket() != null && (subOrderType = ticketItem.getTicket().getSubOrderType()) != null) {
            TaxGroup orderBaseTaxGroup2;
            if (subOrderType == SubOrderType.FOR_HERE) {
                orderBaseTaxGroup2 = this.getOrderBaseTaxGroup(menuItem, orderType.getId(), ".for_here");
                itemTaxGroup = orderBaseTaxGroup2 != null ? orderBaseTaxGroup2 : orderType.getForHereTaxGroup();
            } else if (subOrderType == SubOrderType.TO_GO) {
                orderBaseTaxGroup2 = this.getOrderBaseTaxGroup(menuItem, orderType.getId(), ".to_go");
                itemTaxGroup = orderBaseTaxGroup2 != null ? orderBaseTaxGroup2 : orderType.getToGoTaxGroup();
            }
        }
        if (itemTaxGroup == null && menuItem != null) {
            itemTaxGroup = menuItem.getTaxGroup();
        }
        if (itemTaxGroup == null) {
            TaxGroup orderTypeTaxGroup = orderType.getDefaultTaxGroup();
            itemTaxGroup = orderTypeTaxGroup != null ? orderTypeTaxGroup : this.getOutletTaxGroup();
        }
        if (itemTaxGroup == null) {
            ticketItem.setTaxes(null);
            return;
        }
        List taxes = itemTaxGroup.getTaxes();
        if (taxes != null) {
            ArrayList<TicketItemTax> ticketItemTaxes = new ArrayList<TicketItemTax>();
            for (Tax tax : taxes) {
                TicketItemTax ticketItemTax = new TicketItemTax();
                ticketItemTax.setId(tax.getId());
                ticketItemTax.setName(tax.getName());
                ticketItemTax.setRate(tax.getRate());
                ticketItemTaxes.add(ticketItemTax);
            }
            ticketItem.setTaxes(ticketItemTaxes);
        }
    }

    private TaxGroup getOutletTaxGroup() {
        Outlet outlet = DataProvider.get().getOutlet();
        if (outlet != null) {
            TaxGroup outletTaxGroup = outlet.getTaxGroup();
            return outletTaxGroup;
        }
        return null;
    }

    private TaxGroup getOrderBaseTaxGroup(MenuItem menuItem, String orderTypeId, String subOrderType) {
        if (menuItem == null) {
            return null;
        }
        String orderTypeTaxGroupId = menuItem.getProperty(orderTypeId + subOrderType + ".taxgroup");
        if (StringUtils.isBlank((String)orderTypeTaxGroupId)) {
            return null;
        }
        return DataProvider.get().getTaxGroupById(orderTypeTaxGroupId);
    }

    public TicketItemDiscount convertToTicketItemDiscount(Discount discount, TicketItem ticketItem) {
        TicketItemDiscount ticketItemDiscount = new TicketItemDiscount();
        ticketItemDiscount.setDiscountId(discount.getId());
        ticketItemDiscount.setAutoApply(discount.isAutoApply());
        ticketItemDiscount.setName(discount.getName());
        ticketItemDiscount.setType(discount.getType());
        ticketItemDiscount.setMinimumAmount(discount.getMinimumBuy());
        ticketItemDiscount.setValue(discount.getValue());
        ticketItemDiscount.setAmount(discount.getValue());
        ticketItemDiscount.setCouponQuantity(Double.valueOf(1.0));
        ticketItemDiscount.setTicketItem(ticketItem);
        ticketItemDiscount.setApplyIfDivisible(discount.isApplyIfDivisible());
        ticketItemDiscount.setDataVersion(Integer.valueOf(2));
        return ticketItemDiscount;
    }

    public List<IUnit> getUnits(MenuItem selectedMenuItem, boolean includeStockUnits, boolean includeRecipeUnits, boolean skipStockNotCountableUnits) {
        List groupUnits;
        ArrayList<IUnit> units = new ArrayList<IUnit>();
        InventoryUnit unit = selectedMenuItem.getUnit();
        if (unit != null && unit.getUnitGroup() != null && (groupUnits = unit.getUnitGroup().getUnits()) != null && groupUnits.size() > 0) {
            for (InventoryUnit groupUnit : groupUnits) {
                if (groupUnit.isDeleted().booleanValue() || skipStockNotCountableUnits && !groupUnit.isStockCountable()) continue;
                units.add((IUnit)groupUnit);
            }
        }
        List variantStockUnits = selectedMenuItem.getVariantStockUnits();
        if (includeStockUnits && variantStockUnits != null) {
            for (InventoryStockUnit stockUnit : variantStockUnits) {
                if (stockUnit.isRecipeUnit().booleanValue() && !includeRecipeUnits) continue;
                units.add((IUnit)stockUnit.getPackagingUnit());
            }
        }
        if (!units.isEmpty()) {
            units.sort(new Comparator<IUnit>(){

                @Override
                public int compare(IUnit o1, IUnit o2) {
                    String name1 = o1.getDisplayName();
                    String name2 = o2.getDisplayName();
                    if (StringUtils.isBlank((String)name1)) {
                        name1 = o1.getName();
                    }
                    if (StringUtils.isBlank((String)name2)) {
                        name2 = o2.getName();
                    }
                    return name1.compareToIgnoreCase(name2);
                }
            });
        }
        return units;
    }

    public double getPriceFromPriceRule(MenuItem menuItem, Ticket ticket) {
        return this.getPriceFromPriceRule(menuItem, ticket, null);
    }

    public double getPriceFromPriceRule(MenuItem menuItem, Ticket ticket, TicketItem ticketItem) {
        Double priceFromPriceRule = this.getPriceByUnitFromPriceRule(menuItem, ticket, null);
        if (priceFromPriceRule != null) {
            if (menuItem.isVariant().booleanValue()) {
                return priceFromPriceRule + menuItem.getPrice();
            }
            return priceFromPriceRule;
        }
        priceFromPriceRule = menuItem.isPizzaType() != false ? this.calculatePriceForPizzaItem(menuItem, ticketItem) : menuItem.getPrice();
        if (menuItem.isVariant().booleanValue()) {
            MenuItem parentMenuItem = menuItem.getParentMenuItem();
            if (parentMenuItem != null) {
                return priceFromPriceRule + parentMenuItem.getPrice();
            }
            PosLog.error(this.getClass(), (String)("Parent menu item is not set for variant " + menuItem.getId()));
        }
        return priceFromPriceRule;
    }

    public double getDestinationUnitPrice(Ticket ticket, MenuItem menuItem, IUnit destinationUnit, double unitQuantity) {
        return this.getDestinationUnitPrice(ticket, menuItem, destinationUnit, unitQuantity, null);
    }

    public double getDestinationUnitPrice(Ticket ticket, MenuItem menuItem, IUnit destinationUnit, double unitQuantity, TicketItem ticketItem) {
        Double priceFromPriceRule = this.getPriceByUnitFromPriceRule(menuItem, ticket, destinationUnit);
        if (priceFromPriceRule != null) {
            if (menuItem.isVariant().booleanValue()) {
                return priceFromPriceRule + this.calculatePrice(menuItem.getPrice(), (IUnit)menuItem.getUnit(), destinationUnit, menuItem);
            }
            return priceFromPriceRule;
        }
        priceFromPriceRule = menuItem.isPizzaType() != false ? this.calculatePriceForPizzaItem(menuItem, ticketItem) : menuItem.getPrice();
        if (menuItem.isVariant().booleanValue()) {
            priceFromPriceRule = priceFromPriceRule + menuItem.getParentMenuItem().getPrice();
        }
        return this.getDestinationUnitPrice(menuItem, destinationUnit, priceFromPriceRule, unitQuantity);
    }

    private Double calculatePriceForPizzaItem(MenuItem menuItem, TicketItem newTicketItem) {
        if (newTicketItem != null) {
            List sizeList = MenuItemSizeDAO.getInstance().findAll();
            List crustList = PizzaCrustDAO.getInstance().findAll();
            TicketItemModifier sizeAndCrustModifer = newTicketItem.getSizeModifier();
            if (sizeAndCrustModifer != null) {
                String sizeAndCrustName = sizeAndCrustModifer.getName().trim();
                String sizeName = "";
                String crustName = "";
                for (MenuItemSize menuItemSize : sizeList) {
                    if (!sizeAndCrustName.contains(menuItemSize.getName()) || menuItemSize.getName().length() <= sizeName.length()) continue;
                    sizeName = menuItemSize.getName();
                }
                for (PizzaCrust pizzaCrust : crustList) {
                    if (!sizeAndCrustName.contains(pizzaCrust.getName()) || pizzaCrust.getName().length() <= crustName.length()) continue;
                    crustName = pizzaCrust.getName();
                }
                List pizzaPrices = menuItem.getPizzaPriceList();
                if (pizzaPrices != null) {
                    for (PizzaPrice pizzaPrice : pizzaPrices) {
                        if (!pizzaPrice.getCrust().getName().equalsIgnoreCase(crustName) || !pizzaPrice.getSize().getName().equalsIgnoreCase(sizeName)) continue;
                        return pizzaPrice.getPrice(menuItem.getDefaultSellPortion().intValue());
                    }
                    throw new PosException("This item is not available.");
                }
            }
        }
        double defaultSellPortion = menuItem.getDefaultSellPortion().intValue();
        return menuItem.getPrice() * defaultSellPortion / 100.0;
    }

    public double getDestinationUnitPrice(MenuItem menuItem, IUnit destinationUnit, Double priceFromPriceRule, double unitQuantity) {
        double destinationUnitPrice = 0.0;
        if (destinationUnit != null) {
            destinationUnitPrice = priceFromPriceRule / unitQuantity;
            if (menuItem.isAllowUnitSelection() || menuItem.isAllowUnitWiseSelection()) {
                String priceProperty;
                String key = "unit.{name}.price";
                key = key.replace("{name}", destinationUnit.getId());
                String string = priceProperty = menuItem.isVariant() != false && menuItem.getParentMenuItem() != null ? menuItem.getParentMenuItem().getProperty(key) : menuItem.getProperty(key);
                if (StringUtils.isNotEmpty((String)priceProperty)) {
                    destinationUnitPrice = menuItem.isVariant() != false ? NumberUtil.parseDouble((String)priceProperty) + this.calculatePrice(menuItem.getPrice(), (IUnit)menuItem.getUnit(), destinationUnit, menuItem) : NumberUtil.parseDouble((String)priceProperty);
                }
            }
        }
        return destinationUnitPrice;
    }

    public Double getPriceByUnitFromPriceRule(MenuItem menuItem, Ticket ticket, IUnit unit) {
        Terminal terminal = DataProvider.get().getCurrentTerminal();
        Department department = terminal == null ? null : terminal.getDepartment();
        SalesArea salesArea = null;
        OrderType orderType = null;
        Customer customer = null;
        if (ticket != null) {
            orderType = ticket.getOrderType();
            salesArea = ticket.getSalesArea();
            customer = ticket.getCustomer();
        }
        return DataProvider.get().getPriceFromPriceRule(menuItem.isVariant() != false ? menuItem.getParentMenuItem() : menuItem, orderType, department, salesArea, customer, unit);
    }

    public Double calculateDefaultPizzaPrice(MenuItem menuItem) {
        if (menuItem.isPizzaType().booleanValue()) {
            MenuItemSize deafultPizzaSize = this.defaultPizzaSize(menuItem);
            PizzaCrust deafultPizzaCrust = this.deafultPizzaCrust(menuItem);
            if (deafultPizzaSize == null || deafultPizzaCrust == null) {
                return menuItem.getPrice();
            }
            List pizzaPriceList = menuItem.getPizzaPriceList();
            if (pizzaPriceList != null) {
                for (PizzaPrice pizzaPrice : pizzaPriceList) {
                    if (pizzaPrice.getSize() != deafultPizzaSize || pizzaPrice.getCrust() != deafultPizzaCrust) continue;
                    return pizzaPrice.getPrice();
                }
            }
        }
        return menuItem.getPrice();
    }

    public Double calculateDefaultPizzaCost(MenuItem menuItem) {
        if (menuItem.isPizzaType().booleanValue()) {
            MenuItemSize deafultPizzaSize = this.defaultPizzaSize(menuItem);
            PizzaCrust deafultPizzaCrust = this.deafultPizzaCrust(menuItem);
            if (deafultPizzaSize == null || deafultPizzaCrust == null) {
                return menuItem.getCost();
            }
            List pizzaPriceList = menuItem.getPizzaPriceList();
            if (pizzaPriceList != null) {
                for (PizzaPrice pizzaPrice : pizzaPriceList) {
                    if (pizzaPrice.getSize() != deafultPizzaSize || pizzaPrice.getCrust() != deafultPizzaCrust) continue;
                    return pizzaPrice.getCost();
                }
            }
        }
        return menuItem.getCost();
    }

    private MenuItemSize defaultPizzaSize(MenuItem menuItem) {
        MenuItemSize deafultSize = null;
        Set sizes = menuItem.getSizes();
        if (sizes != null) {
            for (MenuItemSize menuItemSize : sizes) {
                if (!menuItemSize.isDefaultSize().booleanValue()) continue;
                deafultSize = menuItemSize;
            }
            if (deafultSize == null && !sizes.isEmpty()) {
                deafultSize = (MenuItemSize)sizes.stream().findFirst().get();
            }
        }
        return deafultSize;
    }

    private PizzaCrust deafultPizzaCrust(MenuItem menuItem) {
        PizzaCrust deafultPizzaCrust = null;
        Set pizzaCrusts = menuItem.getPizzaCrusts();
        if (pizzaCrusts != null) {
            for (PizzaCrust pizzaCrust : pizzaCrusts) {
                if (!pizzaCrust.isDefaultCrust().booleanValue()) continue;
                deafultPizzaCrust = pizzaCrust;
            }
            if (deafultPizzaCrust == null && !pizzaCrusts.isEmpty()) {
                deafultPizzaCrust = (PizzaCrust)pizzaCrusts.stream().findFirst().get();
            }
        }
        return deafultPizzaCrust;
    }

    public Double getVariantCost(MenuItem menuItem, IUnit selectedUnit) {
        if (selectedUnit == null) {
            return menuItem.getVariantCost();
        }
        InventoryUnit unit = menuItem.getUnit();
        if (unit != null && selectedUnit.getId().equals(unit.getId())) {
            return menuItem.getVariantCost();
        }
        return this.calculateCost(menuItem.getVariantCost(), (IUnit)menuItem.getUnit(), selectedUnit, menuItem);
    }

    public Double getCost(MenuItem menuItem, String unitId) {
        if (unitId == null) {
            return menuItem.getCost();
        }
        InventoryUnit unit = menuItem.getUnit();
        if (unit != null) {
            List stockUnits;
            InventoryUnitGroup unitGroup = unit.getUnitGroup();
            if (unitGroup != null && unitGroup.getUnits() != null) {
                for (InventoryUnit inventoryUnit : unitGroup.getUnits()) {
                    if (!inventoryUnit.getId().equals(unitId)) continue;
                    return this.getCost(menuItem, (IUnit)inventoryUnit);
                }
            }
            if ((stockUnits = menuItem.getStockUnits()) != null && stockUnits.size() > 0) {
                for (InventoryStockUnit itemStockUnit : stockUnits) {
                    if (!unitId.equals(itemStockUnit.getPackagingUnit().getCode())) continue;
                    return this.getCost(menuItem, (IUnit)itemStockUnit.getPackagingUnit());
                }
            }
        }
        return menuItem.getCost();
    }

    public Double getCost(MenuItem menuItem, IUnit selectedUnit) {
        if (selectedUnit == null) {
            return menuItem.getCost();
        }
        InventoryUnit unit = menuItem.getUnit();
        if (unit != null && selectedUnit.getId().equals(unit.getId())) {
            return menuItem.getCost();
        }
        return this.calculateCost(menuItem.getCost(), (IUnit)menuItem.getUnit(), selectedUnit, menuItem);
    }

    public double calculateCost(Double unitCost, IUnit sourceUnit, IUnit targetUnit, MenuItem menuItem) {
        if (sourceUnit == null || targetUnit == null) {
            return unitCost;
        }
        if (targetUnit instanceof PackagingUnit) {
            PackagingUnit packagingUnit = (PackagingUnit)targetUnit;
            if (menuItem.getStockUnits() != null && !menuItem.getStockUnits().isEmpty()) {
                for (InventoryStockUnit stockUnit : menuItem.getStockUnits()) {
                    if (!stockUnit.getPackagingUnit().getId().equals(packagingUnit.getId())) continue;
                    return this.getInventoryUnitCost(unitCost, (InventoryUnit)sourceUnit, stockUnit.getUnit()) * stockUnit.getConversionValue();
                }
            }
        } else if (sourceUnit instanceof PackagingUnit) {
            PackagingUnit packagingUnit = (PackagingUnit)sourceUnit;
            if (menuItem.getStockUnits() != null && menuItem.getStockUnits().size() > 0) {
                for (InventoryStockUnit itemStockUnit : menuItem.getStockUnits()) {
                    if (!packagingUnit.getCode().equals(itemStockUnit.getPackagingUnit().getCode())) continue;
                    return this.getInventoryUnitCost(unitCost, itemStockUnit.getUnit(), (InventoryUnit)targetUnit) / itemStockUnit.getConversionValue();
                }
            }
        } else {
            InventoryUnit targetInventoryUnit = (InventoryUnit)targetUnit;
            if (!sourceUnit.getId().equals(targetInventoryUnit.getId())) {
                return this.getInventoryUnitCost(unitCost, (InventoryUnit)sourceUnit, targetInventoryUnit);
            }
        }
        return unitCost == null ? 0.0 : unitCost;
    }

    private double getInventoryUnitCost(Double unitCost, InventoryUnit sourceUnit, InventoryUnit targetUnit) {
        InventoryUnitConversionRule inventoryUnitConversionRule;
        double newUnitCost = unitCost;
        InventoryUnit inventoryUnit = targetUnit;
        String inventoryUnitConversionRuleName = inventoryUnit.getProperty("conversion.rule", InventoryUnitConversionRule.DIVISION.getName());
        if (!sourceUnit.isBaseUnit().booleanValue() && sourceUnit.getConversionRate() != 1.0) {
            newUnitCost = unitCost * sourceUnit.getConversionRate();
        }
        if ((inventoryUnitConversionRule = InventoryUnitConversionRule.fromName((String)inventoryUnitConversionRuleName)) == InventoryUnitConversionRule.MULTIPLICATION) {
            return newUnitCost * 1.0 / inventoryUnit.getConversionRate();
        }
        return newUnitCost / inventoryUnit.getConversionRate();
    }

    public double calculatePrice(Double unitPrice, IUnit sourceUnit, IUnit targetUnit, MenuItem menuItem) {
        if (sourceUnit == null || targetUnit == null) {
            return unitPrice;
        }
        if (targetUnit instanceof PackagingUnit) {
            PackagingUnit packagingUnit = (PackagingUnit)targetUnit;
            if (menuItem.getStockUnits() != null && !menuItem.getStockUnits().isEmpty()) {
                for (InventoryStockUnit stockUnit : menuItem.getStockUnits()) {
                    if (!stockUnit.getPackagingUnit().getId().equals(packagingUnit.getId())) continue;
                    return this.getInventoryUnitPrice(unitPrice, (InventoryUnit)sourceUnit, stockUnit.getUnit()) * stockUnit.getConversionValue();
                }
            }
        } else {
            InventoryUnit targetInventoryUnit = (InventoryUnit)targetUnit;
            if (!sourceUnit.getId().equals(targetInventoryUnit.getId())) {
                return this.getInventoryUnitPrice(unitPrice, (InventoryUnit)sourceUnit, targetInventoryUnit);
            }
        }
        return unitPrice == null ? 0.0 : unitPrice;
    }

    private double getInventoryUnitPrice(Double unitPrice, InventoryUnit sourceUnit, InventoryUnit targetUnit) {
        InventoryUnitConversionRule inventoryUnitConversionRule;
        double newUnitPrice = unitPrice;
        InventoryUnit inventoryUnit = targetUnit;
        String inventoryUnitConversionRuleName = inventoryUnit.getProperty("conversion.rule", InventoryUnitConversionRule.DIVISION.getName());
        if (!sourceUnit.isBaseUnit().booleanValue() && sourceUnit.getConversionRate() != 1.0) {
            newUnitPrice = unitPrice * sourceUnit.getConversionRate();
        }
        if ((inventoryUnitConversionRule = InventoryUnitConversionRule.fromName((String)inventoryUnitConversionRuleName)) == InventoryUnitConversionRule.MULTIPLICATION) {
            return newUnitPrice * 1.0 / inventoryUnit.getConversionRate();
        }
        return newUnitPrice / inventoryUnit.getConversionRate();
    }

    public double getUnitQuantity(IUnit sourceInventoryUnit, IUnit destinationInventoryUnit, MenuItem menuItem) {
        PackagingUnit stockUnit;
        if (destinationInventoryUnit instanceof PackagingUnit) {
            stockUnit = (PackagingUnit)destinationInventoryUnit;
            if (menuItem.getVariantStockUnits() != null && menuItem.getVariantStockUnits().size() > 0) {
                for (InventoryStockUnit itemStockUnit : menuItem.getVariantStockUnits()) {
                    if (!stockUnit.getCode().equals(itemStockUnit.getPackagingUnit().getCode())) continue;
                    return 1.0 / (itemStockUnit.getConversionValue() * this.getBaseUnitQuantity(itemStockUnit.getUnit().getId(), menuItem));
                }
            }
        }
        if (sourceInventoryUnit instanceof PackagingUnit) {
            stockUnit = (PackagingUnit)sourceInventoryUnit;
            if (menuItem.getVariantStockUnits() != null && menuItem.getVariantStockUnits().size() > 0) {
                for (InventoryStockUnit itemStockUnit : menuItem.getVariantStockUnits()) {
                    if (!stockUnit.getCode().equals(itemStockUnit.getPackagingUnit().getCode())) continue;
                    return destinationInventoryUnit.getConversionRate() * itemStockUnit.getBaseUnitValue();
                }
            }
        }
        if (sourceInventoryUnit != null && destinationInventoryUnit != null) {
            return sourceInventoryUnit.getConversionRate() == 0.0 ? destinationInventoryUnit.getConversionRate() : destinationInventoryUnit.getConversionRate() / sourceInventoryUnit.getConversionRate();
        }
        return 1.0;
    }

    public double getBaseUnitQuantity(String unitId, MenuItem menuItem) {
        InventoryUnit myUnit = menuItem.getUnit();
        if (myUnit == null || myUnit.getId().equals(unitId)) {
            return 1.0;
        }
        if (menuItem.getStockUnits() != null) {
            for (InventoryStockUnit packUnit : menuItem.getStockUnits()) {
                if (!packUnit.getPackagingUnit().getCode().equals(unitId)) continue;
                if (!menuItem.getUnit().isBaseUnit().booleanValue()) {
                    return menuItem.getUnit().getConversionRate() * packUnit.getBaseUnitValue();
                }
                return packUnit.getBaseUnitValue();
            }
        }
        if (myUnit.getUnitGroup() != null && myUnit.getUnitGroup().getUnits() != null) {
            for (InventoryUnit groupUnit : myUnit.getUnitGroup().getUnits()) {
                if (!groupUnit.getId().equals(unitId)) continue;
                return myUnit.getConversionRate() / groupUnit.getConversionRate();
            }
        }
        return 1.0;
    }

    public List<UnitBaseItemPrice> buildUnitBasePriceList(MenuItem menuItem, boolean regeneratePrice) {
        ArrayList<UnitBaseItemPrice> unitBasePrices = new ArrayList<UnitBaseItemPrice>();
        for (IUnit unit : menuItem.getUnits()) {
            InventoryUnit inventoryUnit;
            if (unit.equals(inventoryUnit = menuItem.getUnit())) continue;
            Double unitBaseItemPrice = this.calculateUnitBaseItemPrice(menuItem, unit, regeneratePrice);
            UnitBaseItemPrice itemPrice = new UnitBaseItemPrice(unit.getName(), unit.getId(), unitBaseItemPrice);
            unitBasePrices.add(itemPrice);
        }
        return unitBasePrices;
    }

    private Double calculateUnitBaseItemPrice(MenuItem menuItem, IUnit unit, boolean regeneratePrice) {
        String key = "unit.{name}.price".replace("{name}", unit.getId());
        String value = menuItem.getProperty(key);
        Double price = 0.0;
        price = StringUtils.isBlank((String)value) || regeneratePrice ? Double.valueOf(this.calculatePrice(menuItem.getPrice(), (IUnit)menuItem.getUnit(), unit, menuItem)) : Double.valueOf(NumberUtil.parseOrGetZero((String)value).doubleValue());
        menuItem.addProperty(key, String.valueOf(price));
        return price;
    }

    public static DataUtilCalc getInstance() {
        return instance;
    }
}

