/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos;

import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import jiconfont.IconCode;
import jiconfont.icons.GoogleMaterialDesignIcons;
import jiconfont.swing.IconFontSwing;

public class ContextPopupMenu {
    private static JPopupMenu a;

    public static void apply(JTextComponent ... jTextComponentArray) {
        for (final JTextComponent jTextComponent : jTextComponentArray) {
            if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) continue;
            jTextComponent.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    jTextComponent.requestFocusInWindow();
                    if (!jTextComponent.isEditable()) {
                        jTextComponent.setComponentPopupMenu(null);
                    }
                }
            });
            jTextComponent.setComponentPopupMenu(ContextPopupMenu.a());
        }
    }

    private static JPopupMenu a() {
        if (a == null) {
            a = new JPopupMenu();
            DefaultEditorKit.CutAction cutAction = new DefaultEditorKit.CutAction();
            cutAction.putValue("SmallIcon", IconFontSwing.buildIcon((IconCode)GoogleMaterialDesignIcons.CONTENT_CUT, (float)20.0f));
            cutAction.putValue("Name", "Cut");
            cutAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control X"));
            a.add(cutAction);
            DefaultEditorKit.CopyAction copyAction = new DefaultEditorKit.CopyAction();
            copyAction.putValue("SmallIcon", IconFontSwing.buildIcon((IconCode)GoogleMaterialDesignIcons.CONTENT_COPY, (float)20.0f));
            copyAction.putValue("Name", "Copy");
            copyAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control C"));
            a.add(copyAction);
            DefaultEditorKit.PasteAction pasteAction = new DefaultEditorKit.PasteAction();
            pasteAction.putValue("SmallIcon", IconFontSwing.buildIcon((IconCode)GoogleMaterialDesignIcons.CONTENT_PASTE, (float)20.0f));
            pasteAction.putValue("Name", "Paste");
            pasteAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control V"));
            a.add(pasteAction);
            SelectAll selectAll = new SelectAll();
            a.add(selectAll);
        }
        return a;
    }

    private static class SelectAll
    extends TextAction {
        public SelectAll() {
            super("Select All");
            this.putValue("SmallIcon", IconFontSwing.buildIcon((IconCode)GoogleMaterialDesignIcons.SELECT_ALL, (float)20.0f));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control A"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getFocusedComponent();
            jTextComponent.selectAll();
            jTextComponent.requestFocusInWindow();
        }
    }
}

