/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.actions;

import com.floreantpos.Messages;
import com.floreantpos.bo.ui.BackOfficeWindow;
import com.floreantpos.ui.dialog.ImageGalleryDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.Container;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;

public class ImageGalleryAction
extends AbstractAction {
    private ImageGalleryDialog a;

    public ImageGalleryAction() {
        super(Messages.getString("ImageGalleryAction.0"));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        BackOfficeWindow backOfficeWindow = POSUtil.getBackOfficeWindow();
        try {
            JTabbedPane jTabbedPane = backOfficeWindow.getTabbedPane();
            int n = jTabbedPane.indexOfTab(Messages.getString("ImageGalleryAction.0"));
            Container container = null;
            if (n == -1) {
                this.a = new ImageGalleryDialog(ImageGalleryDialog.SelectionMode.MULTIPLE);
                this.a.setTitlePanelVisible(false);
                this.a.setCloseButtonVisible(false);
                this.a.setSelectBtnVisible(false);
                this.a.disableSelectOnDblClick();
                container = this.a.getContentPane();
                jTabbedPane.addTab(Messages.getString("ImageGalleryAction.0"), container);
                SwingUtilities.invokeLater(() -> this.a.initData());
            } else {
                container = (JPanel)jTabbedPane.getComponentAt(n);
            }
            jTabbedPane.setSelectedComponent(container);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(backOfficeWindow, exception.getMessage(), exception);
        }
    }
}

