/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.actions;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosLog;
import com.floreantpos.actions.PosAction;
import com.floreantpos.main.Application;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.report.ReceiptPrintService;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.dialog.ReorderDialog;
import com.floreantpos.ui.views.order.OrderController;
import com.floreantpos.ui.views.order.actions.DataChangeListener;
import com.floreantpos.util.POSUtil;
import com.floreantpos.versioning.VersionInfo;
import java.util.List;

public class ItemReorderAction
extends PosAction {
    private Ticket a;

    public ItemReorderAction(Ticket ticket) {
        this.a = ticket;
    }

    public ItemReorderAction(DataChangeListener dataChangeListener) {
        super(Messages.getString("ItemReorderAction.0"), dataChangeListener);
    }

    @Override
    public void execute() {
        try {
            Object object;
            if (this.listener != null) {
                object = this.getSelectedObject();
                if (object == null) {
                    return;
                }
                if (object instanceof Ticket) {
                    this.a = (Ticket)object;
                }
            }
            this.a = TicketDAO.getInstance().loadFullTicket(this.a.getId());
            object = Ticket.clone(this.a);
            if (((Ticket)object).getTicketItems().size() == 0) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("ItemReorderAction.1"));
                return;
            }
            ReorderDialog reorderDialog = new ReorderDialog((Ticket)object);
            reorderDialog.setTitle(VersionInfo.getAppName());
            reorderDialog.setDefaultCloseOperation(2);
            reorderDialog.setSize(PosUIManager.getSize((int)1024, (int)650));
            reorderDialog.open();
            if (reorderDialog.isCanceled()) {
                return;
            }
            List<TicketItem> list = reorderDialog.getTicketItems();
            if (list == null || list.isEmpty()) {
                return;
            }
            for (TicketItem ticketItem : list) {
                ticketItem.setTicket(this.a);
                this.a.addToticketItems(ticketItem);
            }
            this.a.calculatePrice();
            OrderController.saveOrder(this.a);
            if (this.a.getOrderType().isShouldPrintToKitchen().booleanValue() && this.a.needsKitchenPrint()) {
                ReceiptPrintService.printToKitchen(this.a);
                POSMessageDialog.showMessage(Messages.getString("ItemReorderAction.3"));
            }
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
            POSMessageDialog.showError(Application.getPosWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
    }
}

