/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.actions;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.main.Application;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.User;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.dialog.PasswordEntryDialog;
import com.floreantpos.ui.views.order.actions.DataChangeListener;
import com.floreantpos.util.POSUtil;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import org.apache.commons.lang.StringUtils;

public abstract class PosAction
extends AbstractAction {
    private boolean a = true;
    protected UserPermission requiredPermission;
    protected ActionEvent event;
    protected static User authorizedUser;
    protected DataChangeListener listener;
    protected boolean mandatoryPermission;

    public PosAction() {
    }

    public PosAction(String string) {
        super(string);
    }

    public PosAction(Icon icon) {
        super(null, icon);
    }

    public PosAction(String string, Icon icon) {
        super(string, icon);
    }

    public PosAction(String string, UserPermission userPermission) {
        super(string);
        this.requiredPermission = userPermission;
    }

    public PosAction(Icon icon, UserPermission userPermission) {
        super(null, icon);
        this.requiredPermission = userPermission;
    }

    public PosAction(String string, DataChangeListener dataChangeListener) {
        super(string);
        this.listener = dataChangeListener;
    }

    public PosAction(DataChangeListener dataChangeListener) {
        this.listener = dataChangeListener;
    }

    public void setDataChangedListener(DataChangeListener dataChangeListener) {
        this.listener = dataChangeListener;
    }

    public DataChangeListener getDataChangedListener() {
        return this.listener;
    }

    public Object getSelectedObject() {
        if (this.listener == null) {
            return null;
        }
        return this.listener.getSelectedData();
    }

    public UserPermission getRequiredPermission() {
        return this.requiredPermission;
    }

    public void setRequiredPermission(UserPermission userPermission) {
        this.requiredPermission = userPermission;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        try {
            this.event = actionEvent;
            User user = this.getCurrentUser();
            if (this.requiredPermission == null) {
                PosAction.setAuthorizedUser(user);
                this.execute();
                return;
            }
            if (user == null) {
                return;
            }
            PosAction.setAuthorizedUser(user);
            if (!this.hasPermission(user, this.requiredPermission)) {
                return;
            }
            this.execute();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
        }
    }

    public boolean hasPermissionToAccessTicket(Ticket ticket) {
        User user = this.getCurrentUser();
        if (ticket != null && ticket.getOwner() != null && ticket.getOwner().getId().equals(user.getId())) {
            return true;
        }
        return this.hasPermission(user, UserPermission.EDIT_OTHER_USERS_TICKETS);
    }

    public boolean hasPermission(User user, UserPermission userPermission) {
        if (this.isMandatoryPermission()) {
            return this.checkGrantPermission(userPermission);
        }
        if (!user.hasPermission(userPermission)) {
            throw new PosException(userPermission.toString() + ": " + Messages.getString("PosAction.2"));
        }
        return true;
    }

    public static boolean checkPermission(User user, UserPermission userPermission) {
        return PosAction.checkPermission(user, userPermission, true, false);
    }

    public static boolean checkPermission(User user, UserPermission userPermission, boolean bl) {
        return PosAction.checkPermission(user, userPermission, bl, false);
    }

    public static boolean checkWithPermission(User user, UserPermission userPermission) {
        return PosAction.checkPermission(user, userPermission, true, true);
    }

    public static boolean checkPermission(User user, UserPermission userPermission, boolean bl, boolean bl2) {
        if (!user.hasPermission(userPermission)) {
            if (!bl2) {
                if (bl) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), userPermission.toString() + ": " + Messages.getString("PosAction.2"));
                    return false;
                }
                throw new PosException(userPermission.toString() + ": " + Messages.getString("PosAction.2"));
            }
            String string = PasswordEntryDialog.show(POSUtil.getFocusedWindow(), userPermission.toString(), Messages.getString("PosAction.0"));
            if (StringUtils.isEmpty((String)string)) {
                return false;
            }
            User user2 = UserDAO.getInstance().findUserBySecretKey(string);
            if (user2 == null) {
                String string2 = Messages.getString("PosAction.1");
                if (bl) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), string2);
                    return false;
                }
                throw new PosException(string2);
            }
            if (!user2.hasPermissionInAnyRole(userPermission)) {
                String string3 = userPermission.toString() + ": " + Messages.getString("PosAction.2");
                if (bl) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), string3);
                    return false;
                }
                throw new PosException(string3);
            }
            PosAction.setAuthorizedUser(user2);
            return true;
        }
        PosAction.setAuthorizedUser(user);
        return true;
    }

    public abstract void execute() throws Exception;

    public ActionEvent getActionEvent() {
        return this.event;
    }

    public boolean isVisible() {
        return this.a;
    }

    public void setVisible(boolean bl) {
        this.a = bl;
    }

    public static void setAuthorizedUser(User user) {
        authorizedUser = user;
    }

    public static User getAuthorizedUser() {
        if (authorizedUser == null) {
            return Application.getCurrentUser();
        }
        return authorizedUser;
    }

    public boolean isMandatoryPermission() {
        return this.mandatoryPermission;
    }

    public void setMandatoryPermission(boolean bl) {
        this.mandatoryPermission = bl;
    }

    protected User getCurrentUser() {
        return Application.getCurrentUser();
    }

    protected boolean checkGrantPermission(UserPermission userPermission) {
        String string = PasswordEntryDialog.show(POSUtil.getFocusedWindow(), userPermission.toString(), Messages.getString("PosAction.0"));
        if (StringUtils.isEmpty((String)string)) {
            return false;
        }
        User user = UserDAO.getInstance().findUserBySecretKey(string);
        if (user == null) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("PosAction.1"));
            return false;
        }
        if (!user.hasPermissionInAnyRole(userPermission)) {
            String string2 = StringUtils.isNotBlank((String)((String)this.getValue("Name"))) ? (String)this.getValue("Name") : userPermission.toString();
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), string2 + ": " + Messages.getString("PosAction.2"));
            return false;
        }
        PosAction.setAuthorizedUser(user);
        return true;
    }

    public static boolean doCheckPermission(UserPermission userPermission) {
        User user = PasswordEntryDialog.getUser(Application.getPosWindow(), Messages.getString("LoginView.1"), Messages.getString("EnterSecretKey"));
        if (user == null) {
            return false;
        }
        if (!user.hasPermissionInAnyRole(userPermission)) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), userPermission.toString() + ": " + Messages.getString("PosAction.2"));
            return false;
        }
        return true;
    }
}

