/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.actions;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.actions.WithPermissionPosAction;
import com.floreantpos.main.Application;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.TransferTicketDialog;
import com.floreantpos.ui.views.order.StyledTicketSelectionDialog;
import com.floreantpos.util.POSUtil;
import com.floreantpos.versioning.VersionInfo;
import java.util.ArrayList;
import java.util.List;

public class TransferTicketItemsAction
extends WithPermissionPosAction {
    public TransferTicketItemsAction() {
        super(Messages.getString("TransferTicketItemsAction.0"));
        this.setRequiredPermission(UserPermission.TRANSFER_TICKET);
    }

    @Override
    public void execute() {
        try {
            List<Ticket> list = TicketDAO.getInstance().findMergableTickets(authorizedUser, true);
            StyledTicketSelectionDialog styledTicketSelectionDialog = new StyledTicketSelectionDialog(list);
            styledTicketSelectionDialog.setCaption(Messages.getString("TransferTicketItemsAction.1"));
            styledTicketSelectionDialog.setRequiredNumber(2);
            styledTicketSelectionDialog.openFullScreen();
            if (styledTicketSelectionDialog.isCanceled()) {
                return;
            }
            List<Ticket> list2 = styledTicketSelectionDialog.getSelectedTickets();
            if (list2.size() <= 0) {
                return;
            }
            ArrayList<Ticket> arrayList = new ArrayList<Ticket>();
            for (Ticket ticket : list2) {
                arrayList.add(TicketDAO.getInstance().loadFullTicket(ticket.getId()));
            }
            TransferTicketDialog transferTicketDialog = new TransferTicketDialog(arrayList);
            transferTicketDialog.setTitle(VersionInfo.getAppName());
            transferTicketDialog.openFullScreen();
            if (transferTicketDialog.isCanceled()) {
                return;
            }
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("TransferTicketItemsAction.4"));
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
    }
}

