/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.actions;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.actions.WithPermissionPosAction;
import com.floreantpos.main.Application;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.services.TicketService;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.dialog.VoidTicketDialog;
import com.floreantpos.ui.views.order.actions.DataChangeListener;
import com.floreantpos.util.POSUtil;
import java.awt.Window;
import org.apache.commons.lang.StringUtils;

public class VoidTicketAction
extends WithPermissionPosAction {
    Ticket a;

    public VoidTicketAction(DataChangeListener dataChangeListener) {
        super(POSConstants.VOID_TICKET_BUTTON_TEXT + "/" + POSConstants.REFUND_BUTTON_TEXT, dataChangeListener);
        super.setRequiredPermission(UserPermission.VOID_TICKET);
        this.setMandatoryPermission(true);
    }

    public VoidTicketAction(Ticket ticket) {
        super(POSConstants.VOID_TICKET_BUTTON_TEXT + "/" + POSConstants.REFUND_BUTTON_TEXT);
        super.setRequiredPermission(UserPermission.VOID_TICKET);
        this.setMandatoryPermission(true);
        this.a = ticket;
    }

    @Override
    public void execute() {
        try {
            Object object;
            Ticket ticket = null;
            if (this.a == null) {
                object = this.getSelectedObject();
                if (object == null) {
                    return;
                }
                ticket = object instanceof Ticket ? (Ticket)object : TicketService.getTicket((String)object);
            } else {
                ticket = this.a;
            }
            if (ticket.isVoided().booleanValue()) {
                POSMessageDialog.showMessage(Application.getPosWindow(), POSConstants.TICKET_IS_VOIDED);
                return;
            }
            if (ticket.getPaidAmount() > 0.0) {
                POSMessageDialog.showMessage(Application.getPosWindow(), Messages.getString("VoidTicketAction.0"));
                return;
            }
            TicketDAO.getInstance().loadFullTicket(ticket);
            if (StringUtils.isBlank((String)ticket.getId())) {
                if (this.listener != null) {
                    this.listener.dataRemoved(ticket);
                }
            } else {
                object = new VoidTicketDialog(POSUtil.getFocusedWindow(), ticket);
                ((Window)object).setSize(PosUIManager.getSize((int)550, (int)280));
                ((POSDialog)object).open();
                if (((POSDialog)object).isCanceled()) {
                    return;
                }
                if (this.listener != null) {
                    this.listener.dataChanged(ticket);
                }
            }
            POSMessageDialog.showMessage(Messages.getString("VoidTicketAction.3"));
        }
        catch (PosException posException) {
            POSMessageDialog.showError(Application.getPosWindow(), posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
    }
}

