/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.actions;

import com.floreantpos.Messages;
import com.floreantpos.actions.PosAction;
import com.floreantpos.bo.ui.BackOfficeWindow;
import com.floreantpos.bo.ui.explorer.AttendanceHistoryExplorer;
import com.floreantpos.model.UserPermission;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import javax.swing.Icon;
import javax.swing.JTabbedPane;

public class AttendanceHistoryAction
extends PosAction {
    public AttendanceHistoryAction() {
        super(Messages.getString("AttendanceHistoryAction.0"));
        super.setRequiredPermission(UserPermission.EMPLOYEE_PRODUCTIVITY_AND_PAYROLL_REPORT);
        this.setMandatoryPermission(true);
    }

    public AttendanceHistoryAction(String string) {
        super(string);
        super.setRequiredPermission(UserPermission.EMPLOYEE_PRODUCTIVITY_AND_PAYROLL_REPORT);
        this.setMandatoryPermission(true);
    }

    public AttendanceHistoryAction(String string, Icon icon) {
        super(string, icon);
        super.setRequiredPermission(UserPermission.EMPLOYEE_PRODUCTIVITY_AND_PAYROLL_REPORT);
        this.setMandatoryPermission(true);
    }

    @Override
    public void execute() throws Exception {
        BackOfficeWindow backOfficeWindow = POSUtil.getBackOfficeWindow();
        try {
            JTabbedPane jTabbedPane = backOfficeWindow.getTabbedPane();
            AttendanceHistoryExplorer attendanceHistoryExplorer = null;
            int n = jTabbedPane.indexOfTab(Messages.getString("AttendanceHistoryAction.0"));
            if (n == -1) {
                attendanceHistoryExplorer = new AttendanceHistoryExplorer();
                jTabbedPane.addTab(Messages.getString("AttendanceHistoryAction.0"), attendanceHistoryExplorer);
            } else {
                attendanceHistoryExplorer = (AttendanceHistoryExplorer)jTabbedPane.getComponentAt(n);
            }
            jTabbedPane.setSelectedComponent(attendanceHistoryExplorer);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(backOfficeWindow, exception.getMessage(), exception);
        }
    }
}

