/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.actions;

import com.floreantpos.Messages;
import com.floreantpos.bo.ui.BackOfficeWindow;
import com.floreantpos.bo.ui.explorer.BrandExplorer;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JTabbedPane;

public class BrandExplorerAction
extends AbstractAction {
    public BrandExplorerAction() {
        super(Messages.getString("Brand"));
    }

    public BrandExplorerAction(String string) {
        super(string);
    }

    public BrandExplorerAction(String string, Icon icon) {
        super(string, icon);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        BackOfficeWindow backOfficeWindow = POSUtil.getBackOfficeWindow();
        try {
            BrandExplorer brandExplorer = null;
            JTabbedPane jTabbedPane = backOfficeWindow.getTabbedPane();
            int n = jTabbedPane.indexOfTab(Messages.getString("Brand"));
            if (n == -1) {
                brandExplorer = new BrandExplorer();
                jTabbedPane.addTab(Messages.getString("Brand"), brandExplorer);
            } else {
                brandExplorer = (BrandExplorer)jTabbedPane.getComponentAt(n);
            }
            jTabbedPane.setSelectedComponent(brandExplorer);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(backOfficeWindow, exception.getMessage(), exception);
        }
    }
}

