/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.actions;

import com.floreantpos.Messages;
import com.floreantpos.PosLog;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuItemModifierPage;
import com.floreantpos.model.MenuItemModifierPageItem;
import com.floreantpos.model.MenuItemModifierSpec;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.model.dao.InventoryUnitDAO;
import com.floreantpos.model.dao.InventoryUnitGroupDAO;
import com.floreantpos.model.dao.MenuCategoryDAO;
import com.floreantpos.model.dao.MenuGroupDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.MenuItemModifierSpecDAO;
import com.floreantpos.model.dao.MenuModifierDAO;
import com.floreantpos.model.dao.ModifierGroupDAO;
import com.floreantpos.model.dao.TaxDAO;
import com.floreantpos.model.dao.TaxGroupDAO;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.datamigrate.Elements;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import org.apache.commons.io.IOUtils;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class DataExportAction
extends AbstractAction {
    public DataExportAction() {
        super(Messages.getString("DataExportAction.0"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Session session = null;
        Transaction transaction = null;
        FileWriter fileWriter = null;
        GenericDAO genericDAO = new GenericDAO();
        try {
            JFileChooser jFileChooser = DataExportAction.getFileChooser();
            int n = jFileChooser.showSaveDialog(POSUtil.getBackOfficeWindow());
            if (n != 0) {
                return;
            }
            File file = jFileChooser.getSelectedFile();
            if (file.exists() && (n = JOptionPane.showConfirmDialog(POSUtil.getBackOfficeWindow(), Messages.getString("DataExportAction.1") + file.getName() + "?", Messages.getString("CONFIRM"), 0)) != 0) {
                return;
            }
            JAXBContext jAXBContext = JAXBContext.newInstance((Class[])new Class[]{Elements.class});
            Marshaller marshaller = jAXBContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
            StringWriter stringWriter = new StringWriter();
            session = genericDAO.createNewSession();
            transaction = session.beginTransaction();
            Elements elements = new Elements();
            elements.setTaxes(TaxDAO.getInstance().findAll(session));
            elements.setTaxGroups(TaxGroupDAO.getInstance().findAll(session));
            elements.setUnits(InventoryUnitDAO.getInstance().findAll(session));
            elements.setUnitGroups(InventoryUnitGroupDAO.getInstance().findAll(session));
            elements.setMenuCategories(MenuCategoryDAO.getInstance().findAll(session));
            elements.setMenuGroups(MenuGroupDAO.getInstance().findAll(session));
            elements.setMenuModifiers(MenuModifierDAO.getInstance().findAll(session));
            elements.setModifierGroups(ModifierGroupDAO.getInstance().findAll(session));
            elements.setMenuItems(MenuItemDAO.getInstance().findAll(session));
            List list = MenuItemModifierSpecDAO.getInstance().findAll(session);
            elements.setMenuItemModifierGroups(list);
            for (MenuItemModifierSpec menuItemModifierSpec : list) {
                Set<MenuItemModifierPage> set = menuItemModifierSpec.getModifierPages();
                if (set == null) continue;
                for (MenuItemModifierPage menuItemModifierPage : set) {
                    menuItemModifierPage.setModifierSpecId(menuItemModifierSpec.getId());
                    List<MenuItemModifierPageItem> list2 = menuItemModifierPage.getPageItems();
                    if (list2 == null) continue;
                    for (MenuItemModifierPageItem menuItemModifierPageItem : list2) {
                        menuItemModifierPageItem.setParentPage(null);
                    }
                }
            }
            marshaller.marshal((Object)elements, (Writer)stringWriter);
            transaction.commit();
            fileWriter = new FileWriter(file);
            fileWriter.write(stringWriter.toString());
            fileWriter.close();
            POSMessageDialog.showMessage(POSUtil.getBackOfficeWindow(), Messages.getString("DataExportAction.4"));
            IOUtils.closeQuietly((Writer)fileWriter);
            genericDAO.closeSession(session);
        }
        catch (Exception exception) {
            if (transaction != null) {
                transaction.rollback();
            }
            PosLog.error(this.getClass(), exception);
            POSMessageDialog.showMessage(POSUtil.getBackOfficeWindow(), exception.getMessage());
        }
        finally {
            IOUtils.closeQuietly(fileWriter);
            genericDAO.closeSession(session);
        }
    }

    public static JFileChooser getFileChooser() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.setSelectedFile(new File("menu-items.xml"));
        jFileChooser.setFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return "XML File";
            }

            @Override
            public boolean accept(File file) {
                return file.getName().endsWith(".xml");
            }
        });
        return jFileChooser;
    }

    public static JFileChooser getFileChooser(String string, final String string2, final String ... stringArray) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.setSelectedFile(new File(string));
        jFileChooser.setAcceptAllFileFilterUsed(false);
        jFileChooser.setFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return string2;
            }

            @Override
            public boolean accept(File file) {
                for (String string : stringArray) {
                    if (!file.getName().endsWith(string)) continue;
                    return true;
                }
                return file.isDirectory();
            }
        });
        return jFileChooser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a() {
        MenuItemModifierSpecDAO menuItemModifierSpecDAO = MenuItemModifierSpecDAO.getInstance();
        Session session = menuItemModifierSpecDAO.createNewSession();
        Transaction transaction = session.beginTransaction();
        try {
            List list = MenuItemDAO.getInstance().findAll(session);
            for (MenuItem menuItem : list) {
                List<MenuItemModifierSpec> list2 = menuItem.getMenuItemModiferSpecs();
                for (MenuItemModifierSpec menuItemModifierSpec : list2) {
                    menuItemModifierSpecDAO.saveOrUpdate(menuItemModifierSpec, session);
                }
            }
            transaction.commit();
        }
        catch (Exception exception) {
            if (transaction != null) {
                transaction.rollback();
            }
        }
        finally {
            menuItemModifierSpecDAO.closeSession(session);
        }
    }
}

