/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.actions;

import com.floreantpos.Messages;
import com.floreantpos.PosLog;
import com.floreantpos.actions.PosAction;
import com.floreantpos.bo.actions.DataExportAction;
import com.floreantpos.model.UserPermission;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.ProgressObserver;
import com.floreantpos.ui.dialog.DetailsProgressibleDialog;
import com.floreantpos.ui.export_import.service.DataBackupService;
import com.floreantpos.util.POSUtil;
import com.ibm.icu.text.SimpleDateFormat;
import java.io.File;
import java.util.Date;
import javax.swing.JFileChooser;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public class DatabaseBackupAction
extends PosAction {
    public static final String BACKUP_EXTENSION = ".orodb";
    public static final String BACKUP_FILE_NAME = new SimpleDateFormat("dd-MM-yyyy(hhmm)").format(new Date());
    private File a;

    public DatabaseBackupAction() {
        super(Messages.getString("DatabaseBackupAction.0"), UserPermission.PERFORM_ADMINISTRATIVE_TASK);
        this.setMandatoryPermission(true);
    }

    @Override
    public void execute() throws Exception {
        String string = String.format("backup_%s.orodb", BACKUP_FILE_NAME);
        JFileChooser jFileChooser = DataExportAction.getFileChooser(string, "ORO backup file (*.orodb)", BACKUP_EXTENSION);
        int n = jFileChooser.showSaveDialog(POSUtil.getBackOfficeWindow());
        if (n != 0) {
            return;
        }
        this.a = jFileChooser.getSelectedFile();
        String string2 = FilenameUtils.getExtension((String)this.a.getName());
        if (StringUtils.isBlank((CharSequence)string2) || !BACKUP_EXTENSION.endsWith(string2)) {
            this.a = new File(this.a.getAbsolutePath() + BACKUP_EXTENSION);
        }
        DetailsProgressibleDialog detailsProgressibleDialog = new DetailsProgressibleDialog(){

            @Override
            public void execute(ProgressObserver progressObserver) {
                try {
                    DataBackupService dataBackupService = new DataBackupService(progressObserver, DatabaseBackupAction.this.a);
                    dataBackupService.startBackup();
                    this.showCompleteMsg(Messages.getString("DatabaseBackupAction.1"));
                }
                catch (Exception exception) {
                    PosLog.error(DatabaseBackupAction.class, "Error during backing up database", exception);
                    progressObserver.printError(exception.getMessage());
                }
            }
        };
        detailsProgressibleDialog.setMinimumSize(PosUIManager.getSize((int)650, (int)400));
        detailsProgressibleDialog.setTitle(Messages.getString("DatabaseBackupAction.3"));
        detailsProgressibleDialog.open();
    }
}

