/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.actions;

import com.floreantpos.Messages;
import com.floreantpos.PosLog;
import com.floreantpos.actions.PosAction;
import com.floreantpos.bo.actions.DataExportAction;
import com.floreantpos.main.ProcessUtil;
import com.floreantpos.model.UserPermission;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.ProgressObserver;
import com.floreantpos.ui.dialog.DetailsProgressibleDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.export_import.service.DataRestorService;
import com.floreantpos.util.POSUtil;
import java.io.File;
import java.sql.SQLException;
import javax.swing.JFileChooser;

public class DatabaseRestoreAction
extends PosAction {
    public DatabaseRestoreAction() {
        super(Messages.getString("DatabaseRestoreAction.0"), UserPermission.PERFORM_ADMINISTRATIVE_TASK);
        this.setMandatoryPermission(true);
    }

    @Override
    public void execute() throws Exception {
        this.a();
    }

    private void a() throws SQLException {
        JFileChooser jFileChooser = DataExportAction.getFileChooser("", String.format(Messages.getString("DatabaseRestoreAction.1"), ".orodb"), ".orodb");
        int n = jFileChooser.showOpenDialog(POSUtil.getBackOfficeWindow());
        if (n != 0) {
            return;
        }
        final File file = jFileChooser.getSelectedFile();
        DetailsProgressibleDialog detailsProgressibleDialog = new DetailsProgressibleDialog(){

            @Override
            public void execute(ProgressObserver progressObserver) {
                DataRestorService dataRestorService = new DataRestorService(progressObserver, file);
                try {
                    dataRestorService.startRestore();
                    POSMessageDialog.showMessage(Messages.getString("DatabaseRestoreAction.2"));
                    ProcessUtil.restart();
                }
                catch (Exception exception) {
                    PosLog.error(this.getClass(), exception);
                    progressObserver.printError(exception.getMessage());
                }
            }
        };
        detailsProgressibleDialog.setTitle(Messages.getString("DatabaseRestoreAction.3"));
        detailsProgressibleDialog.setMinimumSize(PosUIManager.getSize((int)650, (int)400));
        detailsProgressibleDialog.open();
    }
}

